/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.properties;

import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScmPropertiesViewInput {
    private final AbstractFileSystemItemWrapper wrapper;
    private IVersionable cachedItem;

    public static ScmPropertiesViewInput createFor(AbstractFileSystemItemWrapper wrapper) {
        return new ScmPropertiesViewInput(wrapper);
    }

    public ScmPropertiesViewInput(AbstractFileSystemItemWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public AbstractFileSystemItemWrapper getWrapper() {
        return this.wrapper;
    }

    public ITeamRepository getRepository() {
        return this.wrapper.getRepository();
    }

    public String computeName(IProgressMonitor monitor) {
        return this.wrapper.getFQName();
    }

    private IVersionable fetchState(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.cachedItem == null) {
            IVersionableHandle handle = this.getVersionableHandle();
            IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).versionableManager();
            this.cachedItem = versionableManager.fetchCompleteState(handle, monitor);
        }
        return this.cachedItem;
    }

    public IFileItem fetchFileItem(IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionable state = this.fetchState(monitor);
        return (IFileItem)(IFileItem.ITEM_TYPE.equals(state.getItemType()) ? state : null);
    }

    public FileState fetchState(boolean forceRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionable state = this.fetchState(monitor);
        return ClientFileStateFactory.create((ITeamRepository)this.getRepository(), (IItemType)state.getItemType(), (IVersionable)state);
    }

    public IVersionableHandle getVersionableHandle() {
        return (IVersionableHandle)this.wrapper.getFileItem().toHandle();
    }

    public IComponentHandle fetchComponentHandle(IProgressMonitor monitor) throws TeamRepositoryException {
        ItemId componentId = this.wrapper.getWorkspace().fetchComponentId(monitor);
        return (IComponentHandle)componentId.toHandle();
    }
}

