/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.properties;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.internal.IFileItemProperties;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.properties.PropertyNamespaceManager;
import com.ibm.team.filesystem.rcp.ui.internal.properties.SCMPropertyEntry;
import com.ibm.team.filesystem.rcp.ui.internal.util.SCMPropertiesUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.properties.VersionablePropertiesArea;
import com.ibm.team.internal.filesystem.ui.util.ItemPermissionUtil;
import com.ibm.team.internal.filesystem.ui.views.properties.ScmPropertiesViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.LoggedInRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.AbstractViewWithInput;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ScmPropertiesView
extends AbstractViewWithInput {
    public static final String ID = "com.ibm.team.filesystem.ui.changes.views.ScmPropertiesView";
    private VersionablePropertiesArea propertiesArea;
    private VersionablePropertiesArea.SCMProperties properties = new VersionablePropertiesArea.SCMProperties();
    private LoggedInRunner loggedInRunner;
    private ScmPropertiesViewInput input;
    private final IPropertyChangeListener versionIdentifiersPropertyChangeListener;

    public ScmPropertiesView(IPartSite site, Object initialInput) {
        super(site, ScmPropertiesViewInput.class, initialInput);
        this.loggedInRunner = new LoggedInRunner(site.getOperationRunner());
        Composite parent = site.getParent();
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(parent);
        this.propertiesArea = new VersionablePropertiesArea(parent);
        this.propertiesArea.setInput(this.properties);
        site.setSelectionProvider(this.propertiesArea.getSelectionProvider());
        this.versionIdentifiersPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("pref_show_version_identifiers_repository_id".equals(property)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ScmPropertiesView.this.inputChanged(ScmPropertiesView.this.input);
                        }
                    });
                }
            }
        };
        RcpUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.versionIdentifiersPropertyChangeListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.view_properties");
    }

    protected void inputChanged(Object item) {
        ScmPropertiesViewInput input;
        Display display = Display.getCurrent();
        this.input = input = (ScmPropertiesViewInput)item;
        this.refreshView(input, display, false);
        super.inputChanged(item);
    }

    private void refreshView(ScmPropertiesViewInput item, final Display display, boolean forceRefresh) {
        Composite c = this.getSite().getParent();
        if (this.input == null) {
            return;
        }
        final ScmPropertiesViewInput newInput = this.input;
        this.loggedInRunner.cancelAll();
        this.loggedInRunner.enqueue(this.input.getRepository(), Messages.StructuralChangesView_computingInputJobName, (Operation)new RepositoryOperation((Control)c, forceRefresh, item){
            private final /* synthetic */ Control val$c;
            private final /* synthetic */ boolean val$forceRefresh;
            private final /* synthetic */ ScmPropertiesViewInput val$item;
            {
                this.val$c = control;
                this.val$forceRefresh = bl;
                this.val$item = scmPropertiesViewInput2;
            }

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (newInput.getVersionableHandle() == null) {
                    String contextName = newInput.getWrapper().getWorkspace().getContext((IProgressMonitor)progress.newChild(100)).getName();
                    final String dialogTitle = Messages.ScmPropertiesView_DeletedFileDialogTitle;
                    final String dialogMessage = NLS.bind((String)Messages.ScmPropertiesView_DeletedFileDialogMessage, (Object)contextName);
                    SWTUtil.greedyExec((Display)display, (Control)this.val$c, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JFaceUtils.showMessage((String)dialogTitle, (String)dialogMessage, (int)2);
                        }
                    });
                    return;
                }
                SWTUtil.greedyExec((Display)display, (Control)this.val$c, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ScmPropertiesView.this.setInputDescription(val$item, Messages.StructuralChangesView_pendingDescription);
                    }
                });
                final String contentDescription = newInput.computeName((IProgressMonitor)progress.newChild(20));
                SWTUtil.greedyExec((Display)display, (Control)this.val$c, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ScmPropertiesView.this.setInputDescription(val$item, contentDescription);
                    }
                });
                final FileState fileState = newInput.fetchState(this.val$forceRefresh, (IProgressMonitor)progress.newChild(35));
                IVersionableIdentifier[] identifiers = SCMPlatform.getWorkspaceManager((ITeamRepository)newInput.getRepository()).getVersionableIdentifiers(new IVersionableHandle[]{this.val$item.getVersionableHandle()}, (IProgressMonitor)progress.newChild(15));
                boolean showRepo = RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_repository_id");
                final IFileItem fileItem = newInput.fetchFileItem((IProgressMonitor)progress.newChild(20));
                final String versionId = identifiers[0] == null ? "" : (showRepo ? identifiers[0].getLongVersionId() : identifiers[0].getShortVersionId());
                ITeamRepository repo = newInput.getRepository();
                IVersionableHandle vh = newInput.getVersionableHandle();
                IComponentHandle componentHandle = newInput.fetchComponentHandle((IProgressMonitor)progress.newChild(5));
                IAuditable context = ItemPermissionUtil.fetchPermissionContext(vh, componentHandle, repo, (IProgressMonitor)progress.newChild(5));
                final String contextName = ItemPermissionUtil.getPermissionContextName(context);
                SWTUtil.greedyExec((Display)display, (Control)this.val$c, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IFileContent content;
                        VersionablePropertiesArea.SCMProperties entries = new VersionablePropertiesArea.SCMProperties();
                        PropertyNamespaceManager namespaceManager = PropertyNamespaceManager.getInstance();
                        Map properties = fileState.getProperties();
                        for (Map.Entry entry : properties.entrySet()) {
                            if (((String)entry.getKey()).startsWith("scm") && !IFileItemProperties.definedUserProperties.contains(entry.getKey())) continue;
                            String value = namespaceManager.hasDisplayValue((String)entry.getKey()) ? Messages.StructuralChangesView_pendingDescription : (String)entry.getValue();
                            SCMPropertyEntry scmPropertyEntry = new SCMPropertyEntry((String)entry.getKey(), value);
                            entries.addEntry(scmPropertyEntry);
                        }
                        if (fileState.getStateId().getItemType().equals(IFileItem.ITEM_TYPE)) {
                            entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_0, Boolean.toString(fileState.isExectuable())));
                            if (fileState.getContentType() != null) {
                                entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_1, fileState.getContentType()));
                            }
                            entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_2, fileState.getLineDelimiter().toString()));
                            if (fileState.getTimestamp().getTime() != -1L) {
                                entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_4, DateFormat.getDateTimeInstance().format(fileState.getTimestamp())));
                            }
                            if (fileState.getCharacterEncoding() != "") {
                                entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_5, fileState.getCharacterEncoding()));
                            }
                        } else if (fileState.getStateId().getItemType().equals(ISymbolicLink.ITEM_TYPE)) {
                            entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_3, fileState.getTarget()));
                            if (fileState.isDirectoryLink()) {
                                entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_6, Messages.ScmPropertiesView_6_value));
                            } else {
                                entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_6, Messages.ScmPropertiesView_6_value2));
                            }
                        }
                        entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_read_access, contextName));
                        entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_7, versionId));
                        if (fileItem != null && (content = fileItem.getContent()) != null) {
                            String size = NLS.bind((String)Messages.ScmPropertiesView_bytes, (Object)Long.toString(content.getSize()));
                            entries.addEntry(new SCMPropertyEntry(Messages.ScmPropertiesView_size, size));
                        }
                        ScmPropertiesView.this.propertiesArea.setInput(entries);
                    }
                });
                Map properties = fileState.getProperties();
                ScmPropertiesView.populatePropertiesBG(properties, ScmPropertiesView.this.propertiesArea, display, this.val$c, repo, monitor);
            }
        });
    }

    public void dispose() {
        RcpUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.versionIdentifiersPropertyChangeListener);
        super.dispose();
    }

    public static void populatePropertiesBG(Map<String, String> properties, final VersionablePropertiesArea versionablePropertiesArea, final Display display, Control c, ITeamRepository repo, IProgressMonitor monitor) {
        final HashMap<String, HashMap<String, String>> displayValues = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String property = entry.getKey();
            HashMap<String, String> map = (HashMap<String, String>)displayValues.get(property);
            if (map == null) {
                map = new HashMap<String, String>();
                displayValues.put(property, map);
            }
            map.put(entry.getValue(), entry.getValue());
        }
        SCMPropertiesUtil.populatePropertiesBG(displayValues, (ITeamRepository)repo, (IProgressMonitor)monitor);
        SWTUtil.greedyExec((Display)display, (Control)c, (Runnable)new Runnable(){

            @Override
            public void run() {
                block0: for (Map.Entry entry : displayValues.entrySet()) {
                    String key = (String)entry.getKey();
                    Map map = (Map)entry.getValue();
                    for (Map.Entry mapEntry : map.entrySet()) {
                        if (display == null || display.isDisposed()) break block0;
                        SCMPropertyEntry scmProperty = new SCMPropertyEntry(key, (String)mapEntry.getKey(), (String)mapEntry.getValue());
                        versionablePropertiesArea.getInput().addEntry(scmProperty);
                    }
                }
            }
        });
    }
}

