/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.queries;

import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.era.NullRootComputer;
import com.ibm.team.filesystem.client.internal.namespace.ConflictInfo;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.internal.filesystem.ui.configuration.HistoryIndexer;
import com.ibm.team.internal.filesystem.ui.views.history.entries.VersionableHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.queries.AbstractHistoryViewQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class VersionableHistoryViewQuery
extends AbstractHistoryViewQuery {
    private AbstractFileSystemItemWrapper focusItem;
    private HistoryIndexer indexer = new HistoryIndexer();
    private boolean searchIntermediates = false;

    public VersionableHistoryViewQuery(ITeamRepository repo, ItemNamespace namespace, AbstractFileSystemItemWrapper focusItem, IOperationRunner runner, int entryCount) {
        super(repo, namespace, runner, entryCount);
        this.focusItem = focusItem;
    }

    @Override
    protected List fetchResult(IItemContext context, int length, IProgressMonitor monitor) throws TeamRepositoryException {
        AbstractFileSystemItemWrapper focusItem = this.focusItem;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repository2 = context.getNamespace().getRepository();
        boolean writable = VersionableHistoryViewQuery.isWritable(context);
        ArrayList changeSets = NewCollection.arrayList();
        changeSets.addAll(context.findChangeSetsAffecting(focusItem.getItem(), this.getSearchIntermediates(), length, (IProgressMonitor)progress.newChild(10)));
        ConflictInfo conflictInfo = context.getConflictInfo(focusItem.getItem());
        Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)repository2, (Collection)DeliveryInfo.getChangeSetList((List)changeSets), (IProgressMonitor)progress.newChild(10));
        ItemId componentId = context.getNamespace().fetchComponentId((IProgressMonitor)progress.newChild(5));
        EraDescriptor currentEra = EraDescriptor.createWithActiveChanges((ITeamRepository)repository2, null, (List)changeSets, (ItemId)componentId, (ConflictInfo)conflictInfo, (IRemoteFunction)NullRootComputer.getInstance(), (IProgressMonitor)progress.newChild(5));
        ArrayList versionables = NewCollection.arrayList();
        ArrayList result = NewCollection.arrayList();
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repository2);
        boolean showRepo = RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_repository_id");
        while (currentEra != null && !currentEra.isEmpty()) {
            StateId fileItem;
            progress.setWorkRemaining(100);
            int index = this.indexer.getIndexOf(currentEra, (IProgressMonitor)progress.newChild(1));
            VersionableHistoryEntry entry = VersionableHistoryEntry.constructEntry(currentEra, index, context, focusItem, writable, false, (IProgressMonitor)progress.newChild(2));
            AbstractFileSystemItemWrapper targetItem = entry.getTargetItem();
            if (targetItem != null && !(fileItem = targetItem.getFileItem()).isDeleted()) {
                versionables.add((IVersionableHandle)fileItem.toHandle());
            }
            result.add(entry);
            currentEra = currentEra.discardLast((IProgressMonitor)progress.newChild(25));
        }
        IVersionableIdentifier[] identifiers = wm.getVersionableIdentifiers(versionables.toArray(new IVersionableHandle[versionables.size()]), null);
        int idx = 0;
        for (VersionableHistoryEntry entry : result) {
            StateId fileItem;
            AbstractFileSystemItemWrapper targetItem = entry.getTargetItem();
            if (targetItem == null || (fileItem = targetItem.getFileItem()).isDeleted()) continue;
            if (identifiers[idx] != null) {
                entry.setVersionId(showRepo ? identifiers[idx].getLongVersionId() : identifiers[idx].getShortVersionId());
                entry.setVersionNumber(identifiers[idx].getShortVersionId());
            }
            ++idx;
        }
        fetched.size();
        return result;
    }

    public void setSearchIntermediates(boolean setting) {
        this.searchIntermediates = setting;
    }

    public boolean getSearchIntermediates() {
        return this.searchIntermediates;
    }
}

