/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.queries;

import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.EraNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.entries.AbstractHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.entries.BaselineHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.entries.ChangeInWorkspaceHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.queries.AbstractHistoryViewQuery;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.query.PagedQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.ChangeHistoryEntry;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.HistoricBasis;
import com.ibm.team.scm.common.internal.ScmFactory;
import com.ibm.team.scm.common.internal.dto.ChangeHistoryWithBaselinesResult;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PagedConfigurationHistoryViewQuery
extends PagedQuery<AbstractHistoryEntry> {
    private WorkspaceNamespace workspaceNamespace;
    private IItemContext context;
    private ChangeHistoryHandle nextPageToken;
    private List<AbstractHistoryEntry> cachedEntries;
    private int index = Integer.MAX_VALUE;
    private BaselineHistoryEntry baselineEntryToFix = null;
    private ChangeInWorkspaceHistoryEntry changeSetEntryToFix = null;
    private boolean isHidingBaselines = false;
    private IChangeListener changeSetListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property == IItemContext.PROP_HISTORY) {
                PagedConfigurationHistoryViewQuery.this.refresh();
            }
        }
    };
    private ISharedItemChangeListener baselineListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (Object o : events) {
                IBaseline baseline;
                ItemId componentId;
                ISharedItemChangeEvent event;
                IItem item;
                if (!(o instanceof ISharedItemChangeEvent) || !((item = (event = (ISharedItemChangeEvent)o).getSharedItem()) instanceof IBaseline) || !(componentId = new ItemId((IItemHandle)(baseline = (IBaseline)item).getComponent())).equals((Object)PagedConfigurationHistoryViewQuery.this.workspaceNamespace.getComponentId())) continue;
                PagedConfigurationHistoryViewQuery.this.refresh();
                return;
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagedConfigurationHistoryViewQuery(WorkspaceNamespace workspaceNamespace, int pageSize, boolean isHidingBaselines, IOperationRunner runner) {
        super(workspaceNamespace.getRepository(), runner);
        this.workspaceNamespace = workspaceNamespace;
        this.isHidingBaselines = isHidingBaselines;
        PagedConfigurationHistoryViewQuery pagedConfigurationHistoryViewQuery = this;
        synchronized (pagedConfigurationHistoryViewQuery) {
            this.pageSize = pageSize;
        }
    }

    protected PagedQuery.QueryResult<AbstractHistoryEntry> fetchNextPage(int requestedPageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.context == null) {
            this.context = this.workspaceNamespace.createContext((IProgressMonitor)progress.newChild(10));
            progress.setWorkRemaining(90);
            this.context.addHistoryListener(this.changeSetListener);
        }
        boolean isWritable = AbstractHistoryViewQuery.isWritable(this.context);
        IConnection connection = this.context.getConnection();
        if (!(connection instanceof IWorkspaceConnection)) {
            return PagedQuery.QueryResult.emptyResult();
        }
        IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)connection;
        IComponentHandle componentHandle = (IComponentHandle)this.workspaceNamespace.getComponentId().toHandle();
        int requestedRemaining = requestedPageSize;
        while (requestedRemaining > 0) {
            int startIndex;
            int pageSize = Math.min(requestedRemaining, 512);
            ChangeHistoryWithBaselinesResult changeHistoryResult = workspaceConnection.fetchChangeHistoryWithBaselines(componentHandle, this.nextPageToken, pageSize, (IProgressMonitor)progress.newChild(20));
            this.nextPageToken = changeHistoryResult.getNextPageToken();
            ArrayList<ItemId> changeSetsToFetch = new ArrayList<ItemId>();
            for (Object obj : changeHistoryResult.getChangeHistoryEntries()) {
                ChangeHistoryEntry changeHistoryEntry = (ChangeHistoryEntry)obj;
                changeSetsToFetch.add(new ItemId((IItemHandle)changeHistoryEntry.getChangeSet()));
            }
            Map fetchedChangeSets = RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), changeSetsToFetch, (IProgressMonitor)progress.newChild(20));
            ArrayList<AbstractHistoryEntry> historyEntries = new ArrayList<AbstractHistoryEntry>();
            int currentIndex = startIndex = this.index - this.numberOfEntries(changeHistoryResult);
            ChangeInWorkspaceHistoryEntry nextChangeSetEntryToFix = null;
            ChangeInWorkspaceHistoryEntry previousChangeSetEntry = null;
            BaselineHistoryEntry nextBaselineEntryToFix = null;
            BaselineHistoryEntry previousBaselineEntry = null;
            SubMonitor loopProgress = progress.newChild(50).setWorkRemaining(changeHistoryResult.getChangeHistoryEntries().size() * 100);
            for (Object obj : changeHistoryResult.getChangeHistoryEntries()) {
                ChangeHistoryEntry changeHistoryEntry = (ChangeHistoryEntry)obj;
                IChangeSet changeSet = (IChangeSet)fetchedChangeSets.get(new ItemId((IItemHandle)changeHistoryEntry.getChangeSet()));
                ChangeHistoryHandle changeHistory = ScmFactory.eINSTANCE.createChangeHistoryHandle();
                changeHistory.setItemId(changeHistoryEntry.getChangeHistoryId());
                EraDescriptor staticEraDescriptor = EraDescriptor.createStaticDescriptor((WorkspaceNamespace)((WorkspaceNamespace)this.context.getNamespace()), (ChangeHistoryHandle)changeHistory, (IProgressMonitor)loopProgress.newChild(10));
                EraNamespace staticNamespace = EraNamespace.create((EraDescriptor)staticEraDescriptor);
                ChangeInWorkspaceHistoryEntry currentChangeSetEntry = new ChangeInWorkspaceHistoryEntry(this.context, (ItemNamespace)staticNamespace, changeHistoryEntry, previousChangeSetEntry, changeSet, isWritable, currentIndex++);
                historyEntries.add(currentChangeSetEntry);
                if (previousChangeSetEntry == null) {
                    nextChangeSetEntryToFix = currentChangeSetEntry;
                }
                previousChangeSetEntry = currentChangeSetEntry;
                if (this.isHidingBaselines) continue;
                Map<ItemId<IBaseline>, IBaseline> fetchedBaselines = this.fetchBaselines(changeHistoryResult.getChangeSetToBaselinesMap(), (IProgressMonitor)loopProgress.newChild(90));
                List historicBases = (List)changeHistoryResult.getChangeSetToBaselinesMap().get(changeSet.getItemId());
                if (historicBases == null || historicBases.isEmpty()) continue;
                for (HistoricBasis historyEntry : historicBases) {
                    ItemId deliveredBy;
                    IBaseline baseline = fetchedBaselines.get(new ItemId((IItemHandle)historyEntry.getBasis()));
                    Timestamp deliveryTime = null;
                    if (historyEntry.getDeliveredBy() == null) {
                        deliveredBy = ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
                    } else {
                        deliveredBy = new ItemId((IItemHandle)historyEntry.getDeliveredBy());
                        deliveryTime = historyEntry.getDeliveryDate();
                    }
                    BaselineHistoryEntry currentBaselineEntry = new BaselineHistoryEntry(this.context, baseline, previousBaselineEntry, (ItemId<IContributor>)deliveredBy, deliveryTime, (ItemId<IComponent>)this.workspaceNamespace.getComponentId(), currentIndex++);
                    historyEntries.add(currentBaselineEntry);
                    if (previousBaselineEntry == null) {
                        nextBaselineEntryToFix = currentBaselineEntry;
                    }
                    previousBaselineEntry = currentBaselineEntry;
                }
            }
            if (previousChangeSetEntry != null) {
                if (this.changeSetEntryToFix != null) {
                    this.changeSetEntryToFix.setPrevious(previousChangeSetEntry);
                }
                this.changeSetEntryToFix = nextChangeSetEntryToFix;
            }
            if (previousBaselineEntry != null) {
                if (this.baselineEntryToFix != null) {
                    this.baselineEntryToFix.setPrevious(previousBaselineEntry);
                }
                this.baselineEntryToFix = nextBaselineEntryToFix;
            }
            if (this.cachedEntries == null) {
                this.cachedEntries = new ArrayList<AbstractHistoryEntry>();
            }
            this.cachedEntries.addAll(historyEntries);
            this.index = startIndex - 1;
            if (this.nextPageToken == null) {
                requestedRemaining = 0;
                continue;
            }
            requestedRemaining -= historyEntries.size();
        }
        PagedQuery.QueryResult result = new PagedQuery.QueryResult(this.cachedEntries, 0L, this.nextPageToken != null);
        return result;
    }

    private Map<ItemId<IBaseline>, IBaseline> fetchBaselines(Map changeSetToBaselinesMap, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<ItemId> baselinesToFetch = new ArrayList<ItemId>();
        Collection values = changeSetToBaselinesMap.values();
        for (List list : values) {
            for (HistoricBasis historicBasis : list) {
                baselinesToFetch.add(new ItemId((IItemHandle)historicBasis.getBasis()));
            }
        }
        return RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), baselinesToFetch, (IProgressMonitor)monitor);
    }

    private int numberOfEntries(ChangeHistoryWithBaselinesResult era) {
        int size = era.getChangeHistoryEntries().size();
        for (Object obj : era.getChangeSetToBaselinesMap().values()) {
            size += ((Collection)obj).size();
        }
        return size;
    }

    protected void attachListeners() {
        this.getRepository().itemManager().addItemChangeListener(IBaseline.ITEM_TYPE, this.baselineListener);
    }

    protected void detachListeners() {
        this.getRepository().itemManager().removeItemChangeListener(IBaseline.ITEM_TYPE, this.baselineListener);
        if (this.context != null) {
            this.context.removeHistoryListener(this.changeSetListener);
        }
    }

    public String getName() {
        return Messages.HistoryViewQuery_queryName;
    }

    protected void doFlushCache(IProgressMonitor monitor) throws TeamRepositoryException {
        super.doFlushCache(monitor);
        this.cachedEntries = null;
        this.nextPageToken = null;
        this.index = Integer.MAX_VALUE;
        this.baselineEntryToFix = null;
        this.changeSetEntryToFix = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goMore() {
        if (!this.internalHasMore()) {
            return;
        }
        PagedConfigurationHistoryViewQuery pagedConfigurationHistoryViewQuery = this;
        synchronized (pagedConfigurationHistoryViewQuery) {
            this.nextPageRequested = true;
        }
        this.update();
    }
}

