/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.queries;

import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EmptyEraDescriptor;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.EmptyNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IContextHistory;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.views.history.entries.VersionableHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.queries.AbstractHistoryViewQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FolderHistoryViewQuery
extends AbstractHistoryViewQuery {
    private FolderItemWrapper folder;
    private Map<UUID, Integer> knownIndices = new HashMap<UUID, Integer>();

    public FolderHistoryViewQuery(ITeamRepository repo, ItemNamespace namespace, FolderItemWrapper folder, IOperationRunner runner, int entryCount) {
        super(repo, namespace, runner, entryCount);
        this.folder = folder;
    }

    @Override
    protected List fetchResult(IItemContext context, int length, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IContextHistory contextHistory = context.getHistory();
        if (contextHistory == null) {
            return Collections.EMPTY_LIST;
        }
        IChangeHistory changeHistory = contextHistory.getChangeHistory();
        if (changeHistory == null) {
            return Collections.EMPTY_LIST;
        }
        ITeamRepository repository = context.getNamespace().getRepository();
        boolean writable = FolderHistoryViewQuery.isWritable(context);
        List historyForFolder = changeHistory.getHistoryForFolder((IFolderHandle)this.folder.getItem().toHandle(), length, (IProgressMonitor)progress.newChild(10));
        Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)repository, this.getChangeSetList(historyForFolder), (IProgressMonitor)progress.newChild(10));
        EmptyNamespace namespace = new EmptyNamespace(repository, new ItemId((IItemHandle)changeHistory.getComponent()));
        EmptyEraDescriptor descriptor = new EmptyEraDescriptor(repository, new ItemId((IItemHandle)changeHistory.getComponent()));
        this.generateIndices(historyForFolder);
        ArrayList result = NewCollection.arrayList();
        for (IChangeHistoryEntryChange changeHistoryEntry : historyForFolder) {
            IChangeSet changeSet = (IChangeSet)fetched.get(ItemId.create((IItemHandle)changeHistoryEntry.changeSet()));
            DeliveryInfo delivery = new DeliveryInfo(changeHistoryEntry);
            VersionableHistoryEntry historyViewEntry = new VersionableHistoryEntry((EraDescriptor)descriptor, changeSet, this.getIndex(changeHistoryEntry), context, (ItemNamespace)namespace, null, (ItemId<IContributor>)delivery.getDeliveredBy(), delivery.getDeliveryDate(), writable, false);
            result.add(historyViewEntry);
        }
        return result;
    }

    private int getIndex(IChangeHistoryEntryChange changeHistoryEntry) {
        return this.knownIndices.get(changeHistoryEntry.changeSet().getItemId());
    }

    private void generateIndices(List<IChangeHistoryEntryChange> historyForFolder) {
        block17: {
            Object index;
            int missingCount;
            int lastIndexAssigned;
            block19: {
                block18: {
                    if (!this.knownIndices.isEmpty()) break block18;
                    int index2 = historyForFolder.size();
                    for (IChangeHistoryEntryChange changeHistoryEntry : historyForFolder) {
                        this.knownIndices.put(changeHistoryEntry.changeSet().getItemId(), index2--);
                    }
                    break block17;
                }
                lastIndexAssigned = -1;
                for (Integer index3 : this.knownIndices.values()) {
                    if (index3 <= lastIndexAssigned) continue;
                    lastIndexAssigned = index3;
                }
                missingCount = 0;
                boolean foundLast = false;
                boolean reindex = false;
                for (IChangeHistoryEntryChange changeHistoryEntry : historyForFolder) {
                    index = this.knownIndices.get(changeHistoryEntry.changeSet().getItemId());
                    if (foundLast) {
                        if (index == null) {
                            reindex = true;
                            break;
                        }
                        if ((Integer)index > lastIndexAssigned) {
                            reindex = true;
                            break;
                        }
                    } else if (index == null) {
                        ++missingCount;
                    } else if ((Integer)index == lastIndexAssigned) {
                        foundLast = true;
                    } else {
                        reindex = true;
                        break;
                    }
                    if (index == null && !foundLast) {
                        ++missingCount;
                        continue;
                    }
                    if ((Integer)index == lastIndexAssigned) {
                        foundLast = true;
                        continue;
                    }
                    if (index == null) {
                        reindex = true;
                        continue;
                    }
                    if ((Integer)index <= lastIndexAssigned) continue;
                    lastIndexAssigned = (Integer)index;
                    reindex = true;
                }
                if (!reindex) break block19;
                this.knownIndices.clear();
                int index4 = lastIndexAssigned + historyForFolder.size();
                for (IChangeHistoryEntryChange changeHistoryEntry : historyForFolder) {
                    this.knownIndices.put(changeHistoryEntry.changeSet().getItemId(), index4--);
                }
                break block17;
            }
            if (missingCount <= 0) break block17;
            for (IChangeHistoryEntryChange changeHistoryEntry : historyForFolder) {
                index = this.knownIndices.get(changeHistoryEntry.changeSet().getItemId());
                if (index == null) {
                    this.knownIndices.put(changeHistoryEntry.changeSet().getItemId(), lastIndexAssigned + missingCount--);
                    continue;
                }
                break;
            }
        }
    }

    private Collection<ItemId<IChangeSet>> getChangeSetList(List<IChangeHistoryEntryChange> historyForFolder) {
        ArrayList<ItemId<IChangeSet>> result = new ArrayList<ItemId<IChangeSet>>();
        for (IChangeHistoryEntryChange changeHistoryEntryChange : historyForFolder) {
            result.add((ItemId<IChangeSet>)new ItemId((IItemHandle)changeHistoryEntryChange.changeSet()));
        }
        return result;
    }
}

