/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.queries;

import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.internal.filesystem.ui.configuration.HistoryIndexer;
import com.ibm.team.internal.filesystem.ui.views.history.entries.VersionableHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.queries.AbstractHistoryViewQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ConfigurationHistoryViewQuery
extends AbstractHistoryViewQuery {
    private volatile int startPosition = 0;
    private volatile ItemId<IChangeSet> selectedChangeSet = ItemId.getNullItem((IItemType)IChangeSet.ITEM_TYPE);
    private HistoryIndexer indexer = new HistoryIndexer();

    public ConfigurationHistoryViewQuery(ITeamRepository repo, ItemNamespace namespace, IOperationRunner runner, int entryCount) {
        super(repo, namespace, runner, entryCount);
    }

    @Override
    protected List fetchResult(IItemContext localContext, int entryCount, IProgressMonitor progress) throws TeamRepositoryException {
        EraDescriptor descriptor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        boolean writable = ConfigurationHistoryViewQuery.isWritable(localContext);
        if (!this.selectedChangeSet.isNull() && (descriptor = localContext.getChangeSets((IProgressMonitor)monitor.newChild(1))) != null) {
            int theIndex = descriptor.findIndexOf(this.selectedChangeSet, (IProgressMonitor)monitor.newChild(1));
            this.startPosition = Math.max(theIndex - entryCount / 2, 0);
            this.selectedChangeSet = ItemId.getNullItem((IItemType)IChangeSet.ITEM_TYPE);
        }
        monitor.setWorkRemaining(100);
        ArrayList<VersionableHistoryEntry> entries = new ArrayList<VersionableHistoryEntry>();
        EraDescriptor changeSets = localContext.getChangeSets((IProgressMonitor)monitor.newChild(20));
        changeSets = changeSets.discardLast(this.startPosition, (IProgressMonitor)monitor.newChild(10));
        List deliveries = changeSets.getLastDeliveries(entryCount, (IProgressMonitor)monitor.newChild(20));
        int index = this.indexer.getIndexOf(changeSets, (IProgressMonitor)monitor.newChild(10));
        ITeamRepository repo = this.getRepository();
        Map fetchedChangeSets = RepoFetcher.fetchCurrents((ITeamRepository)repo, (Collection)DeliveryInfo.getChangeSetList((List)deliveries), (IProgressMonitor)monitor.newChild(20));
        ArrayList orderedDeliveries = new ArrayList();
        orderedDeliveries.addAll(deliveries);
        Collections.reverse(orderedDeliveries);
        SubMonitor loopProgress = monitor.newChild(20).setWorkRemaining(orderedDeliveries.size());
        EraDescriptor nextDescriptor = changeSets;
        for (DeliveryInfo next : orderedDeliveries) {
            SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
            ItemId changeSetId = next.getChangeSet();
            IChangeSet changeSet = (IChangeSet)fetchedChangeSets.get(changeSetId);
            VersionableHistoryEntry entry = VersionableHistoryEntry.createEntry(nextDescriptor, index, localContext, null, writable, true, next, changeSet);
            entries.add(entry);
            --index;
            nextDescriptor = nextDescriptor.discardLast((IProgressMonitor)iterationProgress.newChild(40));
        }
        return entries;
    }

    public void setStartPosition(int startPosition) {
        if (startPosition == this.startPosition) {
            return;
        }
        this.startPosition = startPosition;
        this.update();
    }

    public void makeVisible(ItemId<IChangeSet> selectedChangeSet) {
        this.selectedChangeSet = selectedChangeSet;
    }
}

