/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.queries;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.entries.BaselineHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.queries.BaselinesInRepositoryQuery;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.query.PagedQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentInfo;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BaselinesInWorkspaceQuery
extends PagedQuery<BaselineHistoryEntry> {
    private ISharedItemChangeListener itemListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            boolean needsRefresh = false;
            boolean needsUpdate = false;
            for (Object o : events) {
                String afterDescription;
                IBaseline baseline;
                ItemId componentId;
                ISharedItemChangeEvent event;
                IItem item;
                if (!(o instanceof ISharedItemChangeEvent) || !((item = (event = (ISharedItemChangeEvent)o).getSharedItem()) instanceof IBaseline) || !(componentId = new ItemId((IItemHandle)(baseline = (IBaseline)item).getComponent())).equals((Object)BaselinesInWorkspaceQuery.this.workspace.getComponentId())) continue;
                if (event.getAfterState() == null || event.getBeforeState() == null) {
                    needsUpdate = true;
                    continue;
                }
                String beforeDescription = ((IBaseline)event.getBeforeState()).getComment();
                if (beforeDescription.equals(afterDescription = ((IBaseline)event.getAfterState()).getComment())) continue;
                needsRefresh = true;
                break;
            }
            if (needsRefresh) {
                BaselinesInWorkspaceQuery.this.refresh();
            } else if (needsUpdate) {
                BaselinesInWorkspaceQuery.this.update();
            }
        }
    };
    private final WorkspaceNamespace workspace;
    private IItemContext dynamicContext;
    private long start = 0L;
    private List<IComponentInfo> fetchedInfos;

    public BaselinesInWorkspaceQuery(WorkspaceNamespace workspace, IOperationRunner runner) {
        super(workspace.getRepository(), runner);
        this.workspace = workspace;
    }

    public String getName() {
        return Messages.BaselinesInWorkspaceQuery_queryName;
    }

    protected void attachListeners() {
        this.getRepository().itemManager().addItemChangeListener(IBaseline.ITEM_TYPE, this.itemListener);
    }

    protected void detachListeners() {
        this.getRepository().itemManager().removeItemChangeListener(IBaseline.ITEM_TYPE, this.itemListener);
    }

    protected PagedQuery.QueryResult<BaselineHistoryEntry> fetchNextPage(int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        IConnection connection;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)60);
        if (this.dynamicContext == null) {
            this.dynamicContext = this.workspace.createContext((IProgressMonitor)progress.newChild(10));
            progress.setWorkRemaining(60);
        }
        if (!((connection = this.dynamicContext.getConnection()) instanceof IWorkspaceConnection)) {
            return PagedQuery.QueryResult.emptyResult();
        }
        IWorkspaceConnection wc = (IWorkspaceConnection)connection;
        IComponentHandle componentHandle = (IComponentHandle)this.workspace.getComponentId().toHandle();
        long numBasis = ConnectionUtil.getNumBasisInHistory((IWorkspaceConnection)wc, (ItemId)this.workspace.getComponentId(), (IProgressMonitor)progress.newChild(10));
        long maxItems = Math.min(numBasis - this.start, (long)pageSize);
        if (maxItems <= 0L) {
            return PagedQuery.QueryResult.emptyResult();
        }
        long queryStart = numBasis - this.start - maxItems;
        List componentInfo = wc.getComponentAuditTrail(componentHandle, queryStart, maxItems, (IProgressMonitor)progress.newChild(1));
        this.start += (long)componentInfo.size();
        this.addInfos(componentInfo);
        List<BaselineHistoryEntry> historyEntries = BaselinesInRepositoryQuery.convertToHistoryEntries(this.dynamicContext, this.fetchedInfos, (IProgressMonitor)progress.newChild(20));
        PagedQuery.QueryResult result = new PagedQuery.QueryResult(historyEntries, 0L, queryStart > 0L);
        return result;
    }

    private void addInfos(List<IComponentInfo> componentInfo) {
        if (this.fetchedInfos == null) {
            this.fetchedInfos = componentInfo;
        } else {
            ArrayList<IComponentInfo> result = new ArrayList<IComponentInfo>(this.fetchedInfos.size() + componentInfo.size());
            result.addAll(componentInfo);
            result.addAll(this.fetchedInfos);
            this.fetchedInfos = result;
        }
    }

    protected void doFlushCache(IProgressMonitor monitor) throws TeamRepositoryException {
        super.doFlushCache(monitor);
        this.fetchedInfos = null;
        this.start = 0L;
    }
}

