/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.queries;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.impl.RepositoryContext;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.history.entries.BaselineHistoryEntry;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentInfo;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class BaselinesInRepositoryQuery
extends RepositoryQuery {
    private ItemId<IComponent> component;
    private ISharedItemChangeListener itemListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                IBaseline baseLine;
                if (event.getAfterState() != null && event.getBeforeState() != null || !(baseLine = (IBaseline)event.getSharedItem()).getComponent().getItemId().equals((Object)BaselinesInRepositoryQuery.this.component.getItemUUID())) continue;
                BaselinesInRepositoryQuery.this.update();
                break;
            }
        }
    };

    public BaselinesInRepositoryQuery(ITeamRepository repository, ItemId<IComponent> component, IOperationRunner runner) {
        super(repository, runner);
        Assert.isNotNull(component);
        this.component = component;
    }

    public String getName() {
        return NLS.bind((String)Messages.BaselinesInRepositoryQuery_queryName, (Object)RepositoryUtils.getLabel(this.getRepository()));
    }

    protected void attachListeners() {
        this.getRepository().itemManager().addItemChangeListener(IBaseline.ITEM_TYPE, this.itemListener);
    }

    protected void detachListeners() {
        this.getRepository().itemManager().removeItemChangeListener(IBaseline.ITEM_TYPE, this.itemListener);
    }

    public List fetchResult(boolean shouldRefresh, IProgressMonitor reporter) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)2);
        ITeamRepository repo = this.getRepository();
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        List baselineHandles = ItemLists.handlesToIds((Collection)manager.findBaselines(IBaselineSearchCriteria.FACTORY.newInstance().setComponentRequired((IComponentHandle)this.component.toHandle()), Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(1)));
        Collection fetchedBaselines = RepoFetcher.fetchCurrents((ITeamRepository)repo, (Collection)baselineHandles, (boolean)shouldRefresh, (IProgressMonitor)progress.newChild(1)).values();
        ArrayList sortedBaselines = NewCollection.arrayList();
        sortedBaselines.addAll(fetchedBaselines);
        Collections.sort(sortedBaselines, new Comparator<IBaseline>(){

            @Override
            public int compare(IBaseline o1, IBaseline o2) {
                return NullUtil.compare((Comparable)o1.getCreationDate(), (Comparable)o2.getCreationDate());
            }
        });
        RepositoryContext dynContext = new RepositoryContext(repo);
        return BaselinesInRepositoryQuery.convertToHistoryEntries((IItemContext)dynContext, sortedBaselines, false);
    }

    public static List<BaselineHistoryEntry> convertToHistoryEntries(IItemContext dynamicContext, List<IBaseline> baselines, boolean reverse) {
        int index = 0;
        BaselineHistoryEntry prev = null;
        ArrayList result = NewCollection.arrayList();
        HashMap<UUID, IBaseline> seenBaselines = new HashMap<UUID, IBaseline>();
        int i = reverse ? baselines.size() - 1 : 0;
        while (!(reverse ? i < 0 : i >= baselines.size())) {
            IBaseline baseline = baselines.get(i);
            if (!seenBaselines.containsKey(baseline.getItemId())) {
                prev = new BaselineHistoryEntry(dynamicContext, baseline, prev, index);
                ++index;
                result.add(prev);
                seenBaselines.put(baseline.getItemId(), baseline);
            }
            if (reverse) {
                --i;
                continue;
            }
            ++i;
        }
        return result;
    }

    public static List<BaselineHistoryEntry> convertToHistoryEntries(IItemContext dynamicContext, List<IComponentInfo> componentInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = dynamicContext.getNamespace().getRepository();
        ArrayList baselines = NewCollection.arrayList();
        ItemId component = dynamicContext.getNamespace().fetchComponentId((IProgressMonitor)progress.newChild(10));
        for (IComponentInfo next : componentInfo) {
            baselines.add(ConnectionUtil.getBaseline((IComponentInfo)next));
        }
        Map fetchedBaselines = RepoFetcher.fetchCurrents((ITeamRepository)repo, (Collection)baselines, (IProgressMonitor)progress.newChild(90));
        int index = 0;
        BaselineHistoryEntry prev = null;
        ArrayList result = NewCollection.arrayList();
        for (IComponentInfo baselineInfo : componentInfo) {
            ItemId baselineId = ConnectionUtil.getBaseline((IComponentInfo)baselineInfo);
            IBaseline baseline = (IBaseline)fetchedBaselines.get(baselineId);
            prev = new BaselineHistoryEntry(dynamicContext, baseline, prev, (ItemId<IContributor>)new ItemId((IItemHandle)baselineInfo.deliveredBy()), baselineInfo.deliveryDate(), (ItemId<IComponent>)component, index);
            ++index;
            result.add(prev);
        }
        return result;
    }
}

