/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.queries;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractHistoryViewQuery
extends RepositoryQuery {
    private IChangeListener changeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property == IItemContext.PROP_HISTORY) {
                AbstractHistoryViewQuery.this.update();
            }
        }
    };
    private volatile int entryCount;
    private IItemContext context = null;
    private ItemNamespace namespace;
    private boolean allocated;

    public AbstractHistoryViewQuery(ITeamRepository repo, ItemNamespace namespace, IOperationRunner runner, int entryCount) {
        super(repo, runner);
        this.namespace = namespace;
        this.entryCount = entryCount;
    }

    public String getName() {
        return Messages.HistoryViewQuery_queryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFlushCache(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemContext localContext;
        AbstractHistoryViewQuery abstractHistoryViewQuery = this;
        synchronized (abstractHistoryViewQuery) {
            localContext = this.context;
        }
        if (localContext != null) {
            localContext.refresh(monitor);
        }
    }

    protected List fetchResult(boolean needsRefresh, IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IItemContext localContext = this.initializeContext((IProgressMonitor)monitor.newChild(1));
        return this.fetchResult(localContext, this.entryCount, (IProgressMonitor)monitor.newChild(99));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IItemContext initializeContext(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemContext localContext;
        AbstractHistoryViewQuery abstractHistoryViewQuery = this;
        synchronized (abstractHistoryViewQuery) {
            localContext = this.context;
        }
        if (localContext == null) {
            localContext = this.namespace.getContext(monitor);
            abstractHistoryViewQuery = this;
            synchronized (abstractHistoryViewQuery) {
                if (this.context == null) {
                    this.context = localContext;
                    if (this.allocated) {
                        this.context.addHistoryListener(this.changeListener);
                    }
                } else {
                    localContext = this.context;
                }
            }
        }
        return localContext;
    }

    protected abstract List fetchResult(IItemContext var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected static boolean isWritable(IItemContext context) {
        if (context instanceof WorkspaceContext) {
            WorkspaceContext wc = (WorkspaceContext)context;
            return ConnectionUtil.getOwner((IWorkspaceConnection)wc.getWorkspace()).equals(Repositories.getLoggedInContributor(context.getNamespace().getRepository()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detachListeners() {
        this.detachListener();
        AbstractHistoryViewQuery abstractHistoryViewQuery = this;
        synchronized (abstractHistoryViewQuery) {
            this.allocated = false;
        }
    }

    private synchronized void detachListener() {
        if (this.context != null) {
            this.context.removeHistoryListener(this.changeListener);
            this.context = null;
        }
    }

    protected synchronized void attachListeners() {
        this.allocated = true;
        if (this.context != null) {
            this.context.addHistoryListener(this.changeListener);
        }
    }
}

