/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.inputs;

import com.ibm.team.internal.filesystem.ui.views.history.WorkspaceHistoryPageSource;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.team.ui.history.IHistoryPageSource;

public class WorkspaceHistoryViewInput
implements IAdaptable {
    public static final String SHOW_WORKSPACE_HISTORY_PAGE = "/scm/ShowWorkspaceHistory";
    private ITeamRepository fRepo;
    private IWorkspace fWorkspace;
    private IComponent fComponent;
    private int maxResults;
    private String uri;

    public WorkspaceHistoryViewInput(ITeamRepository repo, IWorkspace workspace) {
        this(repo, workspace, null);
    }

    public WorkspaceHistoryViewInput(ITeamRepository repo, IWorkspace workspace, IComponent component) {
        if (repo == null || workspace == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.fRepo = repo;
        this.fWorkspace = workspace;
        this.fComponent = component;
    }

    public ITeamRepository getRepository() {
        return this.fRepo;
    }

    public IWorkspace getWorkspace() {
        return this.fWorkspace;
    }

    public IComponent getComponent() {
        return this.fComponent;
    }

    public Object getAdapter(Class adapterType) {
        if (adapterType == IHistoryPageSource.class) {
            return WorkspaceHistoryPageSource.getInstance();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fRepo == null ? 0 : this.fRepo.getId().hashCode());
        result = 31 * result + (this.fWorkspace == null ? 0 : this.fWorkspace.getItemId().hashCode());
        result = 31 * result + (this.fComponent == null ? 0 : this.fComponent.getItemId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceHistoryViewInput other = (WorkspaceHistoryViewInput)obj;
        if (this.fRepo == null ? other.fRepo != null : other.fRepo == null || !this.fRepo.getId().equals((Object)other.fRepo.getId())) {
            return false;
        }
        if (this.fWorkspace == null ? other.fWorkspace != null : !this.fWorkspace.sameItemId((IItemHandle)other.fWorkspace)) {
            return false;
        }
        if (this.fComponent == null ? other.fComponent != null : !this.fComponent.sameItemId((IItemHandle)other.fComponent)) {
            return false;
        }
        return this.maxResults == other.maxResults;
    }

    public String getBaseUri() {
        String uriToFix = this.fRepo.getRepositoryURI();
        if (uriToFix.endsWith("/")) {
            uriToFix = uriToFix.substring(0, uriToFix.length() - 1);
        }
        if (uriToFix.endsWith("/secure")) {
            uriToFix = uriToFix.substring(0, uriToFix.length() - "/secure".length());
        }
        String uri = uriToFix;
        return uri;
    }

    public String getUri() {
        if (this.uri != null) {
            return this.uri;
        }
        this.uri = this.getEmbeddedHistoryUri();
        return this.uri;
    }

    private String getEmbeddedHistoryUri() {
        String embeddedUri = this.getBaseUri();
        boolean debug = Boolean.getBoolean("com.ibm.team.filesystem.WorkspaceHistoryView.debug");
        embeddedUri = String.valueOf(embeddedUri) + SHOW_WORKSPACE_HISTORY_PAGE + (debug ? "?debug=true&firebug=true" : "");
        String nl = System.getProperty("osgi.nl");
        if (nl != null) {
            Locale locale = Locale.forLanguageTag(nl.replace('_', '-'));
            embeddedUri = String.valueOf(embeddedUri) + (debug ? "&" : "?");
            embeddedUri = String.valueOf(embeddedUri) + "country=" + locale.getCountry() + "&lang=" + locale.getLanguage();
        }
        String workspaceId = this.getWorkspace().getItemId().getUuidValue();
        embeddedUri = String.valueOf(embeddedUri) + "#workspaceId=" + workspaceId;
        if (this.fComponent != null) {
            String componentId = this.getComponent().getItemId().getUuidValue();
            embeddedUri = String.valueOf(embeddedUri) + "&componentId=" + componentId;
        }
        if (this.maxResults != 100) {
            embeddedUri = String.valueOf(embeddedUri) + "&maxResults=" + this.maxResults;
        }
        return embeddedUri;
    }

    public void locationChanged(String location) {
        if (location.startsWith(this.getEmbeddedHistoryUri())) {
            this.uri = location;
        }
    }

    public void setMaxResults(int maxResults) {
        if (this.maxResults != maxResults) {
            this.maxResults = maxResults;
            this.uri = null;
        }
    }
}

