/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.inputs;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractConfigurationHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.queries.PagedConfigurationHistoryViewQuery;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import org.eclipse.jface.viewers.IFilter;

public class WorkspaceConfigurationHistoryViewInput
extends AbstractConfigurationHistoryViewInput {
    private boolean hidingBaselines = false;

    public WorkspaceConfigurationHistoryViewInput(WorkspaceNamespace context) {
        this(context, null);
    }

    public WorkspaceConfigurationHistoryViewInput(WorkspaceNamespace context, IFilter selectionTester) {
        super((ItemNamespace)context, selectionTester);
    }

    @Override
    public AbstractHistoryViewInput getHistoryInputForCurrentFlowTarget(ItemNamespace collaboratorPlace) {
        if (collaboratorPlace instanceof WorkspaceNamespace) {
            WorkspaceNamespace workspaceNamespace = (WorkspaceNamespace)collaboratorPlace;
            return new WorkspaceConfigurationHistoryViewInput(workspaceNamespace);
        }
        return null;
    }

    @Override
    public boolean getShowDateAddedColumn() {
        return true;
    }

    @Override
    public boolean getShowAddedByColumn() {
        return true;
    }

    @Override
    public ISetWithListeners createQuery(IOperationRunner runner, int maxResults) {
        return new PagedConfigurationHistoryViewQuery((WorkspaceNamespace)this.getNamespace(), maxResults, this.isHidingBaselines(), runner);
    }

    public void setHideBaselines(boolean value) {
        this.hidingBaselines = value;
    }

    public boolean isHidingBaselines() {
        return this.hidingBaselines;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.hidingBaselines ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceConfigurationHistoryViewInput other = (WorkspaceConfigurationHistoryViewInput)obj;
        return this.hidingBaselines == other.hidingBaselines;
    }
}

