/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.inputs;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.BaselinesInRepositoryHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.queries.BaselinesInWorkspaceQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class BaselinesInWorkspaceHistoryViewInput
extends AbstractHistoryViewInput {
    public BaselinesInWorkspaceHistoryViewInput(WorkspaceNamespace workspace) {
        super((ItemNamespace)workspace, null);
    }

    @Override
    public AbstractHistoryViewInput getHistoryInputForCurrentFlowTarget(ItemNamespace collaboratorPlace) {
        if (collaboratorPlace instanceof WorkspaceNamespace) {
            WorkspaceNamespace workspaceNamespace = (WorkspaceNamespace)collaboratorPlace;
            return new BaselinesInWorkspaceHistoryViewInput(workspaceNamespace);
        }
        return null;
    }

    @Override
    public ISetWithListeners createQuery(IOperationRunner runner, int maxResults) {
        WorkspaceNamespace workspaceNamespace = (WorkspaceNamespace)this.getNamespace();
        return new BaselinesInWorkspaceQuery(workspaceNamespace, runner);
    }

    @Override
    public AbstractHistoryViewInput getAllStatesInput() {
        WorkspaceNamespace workspaceNamespace = (WorkspaceNamespace)this.getNamespace();
        return new BaselinesInRepositoryHistoryViewInput(workspaceNamespace.getRepository(), (ItemId<IComponent>)workspaceNamespace.getComponentId());
    }

    @Override
    public String computeInputName(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IItemContext context = this.getNamespace().getContext((IProgressMonitor)progress.newChild(35));
        IConnection connection = context.getConnection();
        String workspaceName = connection == null ? context.getName() : connection.getName();
        ItemId componentId = this.getNamespace().fetchComponentId((IProgressMonitor)progress.newChild(35));
        IComponent component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)this.getRepository(), (ItemId)componentId, (IProgressMonitor)progress.newChild(30));
        String componentName = component.getName();
        if (TeamPlatform.getTeamRepositoryService().getTeamRepositories().length > 1) {
            String repositoryName = RepositoryUtils.getLabel(this.getRepository());
            return NLS.bind((String)Messages.BaselinesInWorkspaceHistoryInput_1, (Object[])new Object[]{componentName, workspaceName, repositoryName});
        }
        return NLS.bind((String)Messages.BaselinesInWorkspaceHistoryInput_0, (Object)componentName, (Object)workspaceName);
    }

    @Override
    public String getBiggerInputDescription() {
        return null;
    }

    @Override
    public AbstractHistoryViewInput getBiggerInput() {
        return null;
    }

    @Override
    public boolean getShowBaselineDescriptionColumn() {
        return true;
    }

    @Override
    public boolean getShowDateAddedColumn() {
        return true;
    }

    @Override
    public boolean getShowAddedByColumn() {
        return true;
    }

    @Override
    public boolean getShowPlannedForColumn() {
        return false;
    }
}

