/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.inputs;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.queries.BaselinesInRepositoryQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;

public class BaselinesInRepositoryHistoryViewInput
extends AbstractHistoryViewInput {
    private ItemId<IComponent> componentId;

    public BaselinesInRepositoryHistoryViewInput(ITeamRepository repository, ItemId<IComponent> component) {
        super((ItemNamespace)RepositoryNamespace.create((ITeamRepository)repository), null);
        this.componentId = component;
    }

    @Override
    public ISetWithListeners createQuery(IOperationRunner runner, int maxResults) {
        return new BaselinesInRepositoryQuery(this.getRepository(), this.componentId, runner);
    }

    @Override
    public AbstractHistoryViewInput getHistoryInputForCurrentFlowTarget(ItemNamespace namespace) {
        return null;
    }

    @Override
    public AbstractHistoryViewInput getAllStatesInput() {
        return null;
    }

    @Override
    public String computeInputName(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IComponent component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)this.getRepository(), this.componentId, (IProgressMonitor)progress.newChild(50));
        String componentName = component.getName();
        return NLS.bind((String)Messages.BaselinesInRepositoryHistoryInput_0, (Object)componentName, (Object)this.getNamespaceName((IProgressMonitor)progress.newChild(50)));
    }

    @Override
    public String getBiggerInputDescription() {
        return null;
    }

    @Override
    public AbstractHistoryViewInput getBiggerInput() {
        return null;
    }

    @Override
    public boolean getShowBaselineDescriptionColumn() {
        return true;
    }

    @Override
    public boolean getShowPlannedForColumn() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = prime * super.hashCode();
        return result += Util.hashCode(this.componentId);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaselinesInRepositoryHistoryViewInput other = (BaselinesInRepositoryHistoryViewInput)obj;
        return this.componentId.equals(other.componentId);
    }
}

