/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.inputs;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.FileStateSelectionTester;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractFolderHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.VersionableInBaselineHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.VersionableInRepositoryHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.VersionableInWorkspaceHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.queries.VersionableHistoryViewQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractVersionableHistoryViewInput
extends AbstractHistoryViewInput {
    public static AbstractHistoryViewInput newVersionableHistoryViewInput(AbstractFileSystemItemWrapper itemWrapper) {
        if (itemWrapper instanceof FolderItemWrapper) {
            FolderItemWrapper folder = (FolderItemWrapper)itemWrapper;
            return AbstractFolderHistoryViewInput.createHistoryViewInputFor(folder);
        }
        ItemNamespace namespace = itemWrapper.getWorkspace();
        if (namespace instanceof WorkspaceNamespace) {
            return new VersionableInWorkspaceHistoryViewInput(itemWrapper);
        }
        if (namespace instanceof BaselineNamespace) {
            return new VersionableInBaselineHistoryViewInput(itemWrapper);
        }
        return new VersionableInRepositoryHistoryViewInput(itemWrapper);
    }

    protected AbstractVersionableHistoryViewInput(AbstractFileSystemItemWrapper itemWrapper) {
        super(itemWrapper, (IFilter)new FileStateSelectionTester(itemWrapper.getFileItem()));
    }

    @Override
    public String computeInputName(IProgressMonitor monitor) throws TeamRepositoryException {
        String name = this.getFocusItem().getName();
        if (this.getRepository() != null && TeamPlatform.getTeamRepositoryService().getTeamRepositories().length > 1) {
            String repoName = RepositoryUtils.getLabel(this.getRepository());
            return NLS.bind((String)Messages.VersionableHistoryInput_0, (Object[])new Object[]{name, this.getNamespaceName(monitor), repoName});
        }
        return NLS.bind((String)Messages.FileHistoryInput_0, (Object)name, (Object)this.getNamespaceName(monitor));
    }

    @Override
    public AbstractHistoryViewInput getAllStatesInput() {
        AbstractFileSystemItemWrapper focusItem = this.getFocusItem();
        Object itemWrapper = AbstractFileSystemItemWrapper.newWrapper(focusItem.getFileItem(), focusItem.getFQName(), (ItemNamespace)RepositoryNamespace.create((ITeamRepository)this.getRepository()));
        AbstractHistoryViewInput versionableHistoryInput = AbstractVersionableHistoryViewInput.newVersionableHistoryViewInput(itemWrapper);
        return versionableHistoryInput;
    }

    @Override
    public boolean getShowMergeGraphColumn() {
        return true;
    }

    @Override
    public boolean getShowVersionIdColumn() {
        return true;
    }

    @Override
    public ISetWithListeners createQuery(IOperationRunner runner, int maxResults) {
        return new VersionableHistoryViewQuery(this.getRepository(), this.getNamespace(), this.getFocusItem(), runner, maxResults);
    }
}

