/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.inputs;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IFilter;

public abstract class AbstractHistoryViewInput {
    protected ItemNamespace namespace;
    private IFilter selectionTester;
    protected AbstractFileSystemItemWrapper itemId;

    public AbstractHistoryViewInput(ItemNamespace context, IFilter selectionTester) {
        this(context, null, selectionTester);
    }

    public AbstractHistoryViewInput(AbstractFileSystemItemWrapper itemId, IFilter selectionTester) {
        this(itemId.getWorkspace(), itemId, selectionTester);
    }

    private AbstractHistoryViewInput(ItemNamespace context, AbstractFileSystemItemWrapper itemId, IFilter selectionTester) {
        this.namespace = context;
        this.itemId = itemId;
        this.selectionTester = selectionTester;
    }

    public final ItemNamespace getNamespace() {
        return this.namespace;
    }

    public final ITeamRepository getRepository() {
        return this.namespace.getRepository();
    }

    public abstract AbstractHistoryViewInput getHistoryInputForCurrentFlowTarget(ItemNamespace var1);

    public abstract AbstractHistoryViewInput getAllStatesInput();

    public abstract String getBiggerInputDescription();

    public abstract AbstractHistoryViewInput getBiggerInput();

    public final IFilter getSelectionTester() {
        return this.selectionTester;
    }

    public final AbstractFileSystemItemWrapper getFocusItem() {
        return this.itemId;
    }

    public abstract String computeInputName(IProgressMonitor var1) throws TeamRepositoryException;

    protected String getNamespaceName(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemContext context = this.getNamespace().getContext(monitor);
        return context.getName();
    }

    public abstract ISetWithListeners createQuery(IOperationRunner var1, int var2);

    public boolean getShowCommentColumn() {
        return true;
    }

    public boolean getShowCreatorColumn() {
        return true;
    }

    public boolean getShowDateModifiedColumn() {
        return true;
    }

    public boolean getShowMergeGraphColumn() {
        return false;
    }

    public boolean getShowBaselineDescriptionColumn() {
        return false;
    }

    public boolean getShowDateAddedColumn() {
        return false;
    }

    public boolean getShowAddedByColumn() {
        return false;
    }

    public boolean getShowVersionIdColumn() {
        return false;
    }

    public boolean getShowPlannedForColumn() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractHistoryViewInput other = (AbstractHistoryViewInput)obj;
        if (this.itemId == null ? other.itemId != null : !this.itemId.equals((Object)other.itemId)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals((Object)other.namespace));
    }
}

