/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.inputs;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.FolderInBaselineHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.FolderInWorkspaceHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.queries.FolderHistoryViewQuery;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractFolderHistoryViewInput
extends AbstractHistoryViewInput {
    public static AbstractHistoryViewInput createHistoryViewInputFor(FolderItemWrapper folderWrapper) {
        ItemNamespace namespace = folderWrapper.getWorkspace();
        if (namespace instanceof WorkspaceNamespace) {
            return new FolderInWorkspaceHistoryViewInput(folderWrapper, null);
        }
        if (namespace instanceof BaselineNamespace) {
            return new FolderInBaselineHistoryViewInput(folderWrapper, null);
        }
        return null;
    }

    public AbstractFolderHistoryViewInput(FolderItemWrapper itemId, IFilter selectionTester) {
        super(itemId, selectionTester);
    }

    @Override
    public AbstractHistoryViewInput getAllStatesInput() {
        return null;
    }

    @Override
    public String getBiggerInputDescription() {
        return null;
    }

    @Override
    public AbstractHistoryViewInput getBiggerInput() {
        return null;
    }

    @Override
    public String computeInputName(IProgressMonitor monitor) throws TeamRepositoryException {
        String name = this.getFocusItem().getName();
        if (this.getRepository() != null && TeamPlatform.getTeamRepositoryService().getTeamRepositories().length > 1) {
            String repoName = RepositoryUtils.getLabel(this.getRepository());
            return NLS.bind((String)Messages.VersionableHistoryInput_0, (Object[])new Object[]{name, this.getNamespaceName(monitor), repoName});
        }
        return NLS.bind((String)Messages.FileHistoryInput_0, (Object)name, (Object)this.getNamespaceName(monitor));
    }

    @Override
    public ISetWithListeners createQuery(IOperationRunner runner, int maxResults) {
        return new FolderHistoryViewQuery(this.getRepository(), this.getNamespace(), (FolderItemWrapper)this.getFocusItem(), runner, maxResults);
    }
}

