/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.inputs;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.ChangeSetSelectionTester;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.BaselineConfigurationHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.WorkspaceConfigurationHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.queries.ConfigurationHistoryViewQuery;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractConfigurationHistoryViewInput
extends AbstractHistoryViewInput {
    public static AbstractConfigurationHistoryViewInput newConfigurationHistoryViewInput(ItemNamespace namespace, ItemId<IChangeSet> changeSet) {
        ChangeSetSelectionTester selection;
        ChangeSetSelectionTester changeSetSelectionTester = selection = changeSet == null ? null : new ChangeSetSelectionTester(changeSet);
        if (namespace instanceof WorkspaceNamespace) {
            WorkspaceNamespace workspaceNamespace = (WorkspaceNamespace)namespace;
            return new WorkspaceConfigurationHistoryViewInput(workspaceNamespace, (IFilter)selection);
        }
        if (namespace instanceof BaselineNamespace) {
            BaselineNamespace baselineNamespace = (BaselineNamespace)namespace;
            return new BaselineConfigurationHistoryViewInput(baselineNamespace, (IFilter)selection);
        }
        StatusUtil.log(AbstractConfigurationHistoryViewInput.class, (String)namespace.toString());
        return new AbstractConfigurationHistoryViewInput(namespace, (IFilter)selection){};
    }

    protected AbstractConfigurationHistoryViewInput(ItemNamespace context) {
        this(context, null);
    }

    protected AbstractConfigurationHistoryViewInput(ItemNamespace context, IFilter selectionTester) {
        super(context, selectionTester);
    }

    @Override
    public String computeInputName(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.getRepository() != null && TeamPlatform.getTeamRepositoryService().getTeamRepositories().length > 1) {
            return NLS.bind((String)Messages.VersionableHistoryInput_1, (Object)this.getNamespaceName(monitor), (Object)RepositoryUtils.getLabel(this.getRepository()));
        }
        return this.getNamespaceName(monitor);
    }

    @Override
    public AbstractHistoryViewInput getHistoryInputForCurrentFlowTarget(ItemNamespace namespace) {
        return null;
    }

    @Override
    public AbstractHistoryViewInput getAllStatesInput() {
        return null;
    }

    @Override
    public String getBiggerInputDescription() {
        return null;
    }

    @Override
    public AbstractHistoryViewInput getBiggerInput() {
        return null;
    }

    @Override
    public ISetWithListeners createQuery(IOperationRunner runner, int maxResults) {
        return new ConfigurationHistoryViewQuery(this.getRepository(), this.getNamespace(), runner, maxResults);
    }
}

