/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.hooks;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.WorkspaceHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.web.common.AbstractRichClientHook;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.internal.filesystem.ui.web.common.SimpleJSONdeSerializer;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class ShowOperationHistoryHook
extends AbstractRichClientHook {
    public static final String NAME = "showOperationHistory";
    private static final String FIELD_WORKSPACE_ID = "workspaceId";
    private static final String FIELD_COMPONENT_ID = "componentId";

    public ShowOperationHistoryHook(ITeamRepository repo, IWorkbenchPartSite site, IOperationRunner operationRunner) {
        super(repo, site, operationRunner);
    }

    @Override
    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs, EmbeddedBrowser.EmbeddedFunctionCallback callback) {
        JSONObject jsonArgs = callArgs.getUntyped(0, null);
        final String workspaceId = (String)SimpleJSONdeSerializer.getField(FIELD_WORKSPACE_ID, jsonArgs, this.getRepository());
        final String componentId = (String)SimpleJSONdeSerializer.getField(FIELD_COMPONENT_ID, jsonArgs, this.getRepository());
        if (workspaceId == null) {
            return;
        }
        this.getOperationRunner().enqueue(Messages.ShowOperationHistory_JOBNAME, (Operation)new RepositoryOperation(this.getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                List items;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IItemManager itemManager = ShowOperationHistoryHook.this.getRepository().itemManager();
                ArrayList<Object> handles = new ArrayList<Object>();
                handles.add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)ShowOperationHistoryHook.this.getRepository(), UUID.valueOf((String)workspaceId), null));
                if (componentId != null) {
                    handles.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)ShowOperationHistoryHook.this.getRepository(), UUID.valueOf((String)componentId), null));
                }
                if ((items = itemManager.fetchCompleteItems(handles, 0, (IProgressMonitor)progress.newChild(75))).isEmpty()) {
                    return;
                }
                final IWorkspace workspace = (IWorkspace)items.get(0);
                if (workspace == null) {
                    return;
                }
                final IComponent component = componentId == null ? null : (IComponent)items.get(1);
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkspaceHistoryViewInput input = new WorkspaceHistoryViewInput(ShowOperationHistoryHook.this.getRepository(), workspace, component);
                        HistoryViewUtil.showHistory(UIContext.createPageContext((Shell)ShowOperationHistoryHook.this.getWorkbenchPartSite().getShell(), (IWorkbenchPage)JFaceUtils.getWorkbenchPage()), input);
                    }
                });
            }
        });
    }
}

