/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.hooks;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.ContributorPicker;
import com.ibm.team.internal.filesystem.ui.web.common.AbstractRichClientHook;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class SelectUserHook
extends AbstractRichClientHook {
    public static final String NAME = "selectUser";

    public SelectUserHook(ITeamRepository repo, IWorkbenchPartSite site, IOperationRunner operationRunner) {
        super(repo, site, operationRunner);
    }

    @Override
    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs, final EmbeddedBrowser.EmbeddedFunctionCallback callback) {
        final UIContext context = this.getUIContext();
        if (context != null) {
            ItemId<IContributor> contributor;
            String shellTitle = Messages.OwnerSelectionField_4;
            String dialogTitle = Messages.OwnerSelectionField_9;
            String dialogMessage = Messages.OwnerSelectionField_5;
            try {
                contributor = ContributorPicker.pickContributor(context, shellTitle, dialogTitle, dialogMessage, this.getRepository(), null);
            }
            catch (Exception e) {
                callback.setResult(null, null);
                return;
            }
            this.getOperationRunner().enqueue(Messages.TeamPlaceOverviewPage_fetchingContributor, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                    try {
                        final IContributor theContributor = (IContributor)RepoFetcher.fetchCurrent((ITeamRepository)SelectUserHook.this.getRepository(), (ItemId)contributor, (IProgressMonitor)monitor);
                        context.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                JSONObject contributor = new JSONObject();
                                contributor.put((Object)"name", (Object)theContributor.getName());
                                contributor.put((Object)"itemId", (Object)theContributor.getItemId().getUuidValue());
                                contributor.put((Object)"userId", (Object)theContributor.getUserId());
                                callback.setResult(contributor, null);
                            }
                        });
                    }
                    catch (Exception e) {
                        context.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                callback.setResult(null, e);
                            }
                        });
                    }
                }
            });
        }
    }

    private UIContext getUIContext() {
        IWorkbenchPage activePage = JFaceUtils.getWorkbenchPage();
        if (activePage != null && activePage.getWorkbenchWindow() != null) {
            IWorkbenchWindow workbenchWindow = activePage.getWorkbenchWindow();
            return UIContext.createPageContext((Display)workbenchWindow.getShell().getDisplay(), (Shell)workbenchWindow.getShell(), (IWorkbenchPage)activePage);
        }
        return null;
    }
}

