/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.hooks;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.IWorkspaceRollbackOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.internal.filesystem.ui.web.common.AbstractRichClientHook;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.internal.filesystem.ui.web.common.SimpleJSONdeSerializer;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ReplaceInWorkspaceHook
extends AbstractRichClientHook {
    public static final String NAME = "replaceInWorkspace";
    private static final String FIELD_SELECTED_STATE = "selectedState";
    private static final String FIELD_WORKSPACE = "workspace";
    private static final String FIELD_COMPONENT_IDS = "componentIds";

    public ReplaceInWorkspaceHook(ITeamRepository repo, IWorkbenchPartSite site, IOperationRunner operationRunner) {
        super(repo, site, operationRunner);
    }

    @Override
    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs, EmbeddedBrowser.EmbeddedFunctionCallback callback) {
        JSONObject jsonArgs = callArgs.getUntyped(0, null);
        final WorkspaceComponentState selectedState = (WorkspaceComponentState)SimpleJSONdeSerializer.getField(FIELD_SELECTED_STATE, jsonArgs, this.getRepository());
        final IWorkspaceHandle workspace = (IWorkspaceHandle)SimpleJSONdeSerializer.getField(FIELD_WORKSPACE, jsonArgs, this.getRepository());
        final List componentFilter = (List)SimpleJSONdeSerializer.getField(FIELD_COMPONENT_IDS, jsonArgs, this.getRepository());
        if (selectedState == null || workspace == null) {
            throw new IllegalArgumentException();
        }
        this.getOperationRunner().enqueue(Messages.ReplaceInWorkspace_JOBNAME, (Operation)new RepositoryOperation(this.getRepository()){

            public void repositoryRun(IProgressMonitor progress, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                UIContext context = ReplaceInWorkspaceHook.this.getUIContext();
                if (context == null) {
                    return;
                }
                WarnWorkspaceUpdate dilemmaHandler = new WarnWorkspaceUpdate(context, Messages.ReplaceWorkspaceWithFlowTarget_1){

                    @Override
                    public int noBackupBaselineForComponent(Collection<ConfigurationFacade> configurations, IProgressMonitor monitor) {
                        return this.noBackupBaselineForReplace(configurations, monitor);
                    }

                    @Override
                    public int componentInMultipleHierarchies(IWorkspaceConnection workspace, Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subcomponents, IProgressMonitor monitor) {
                        if (componentFilter == null || componentFilter.size() == 0) {
                            return 0;
                        }
                        return this.componentInMultipleHierarchiesForReplace(workspace, selectedComponents, subcomponents, Collections.EMPTY_LIST, monitor);
                    }

                    @Override
                    public int inaccessibleComponentsNotInSeedWorkspace(Collection<ConfigurationFacade> inaccessibleComponents, IProgressMonitor monitor) {
                        return this.inaccessibleComponentsNotInSeedWorkspaceForReplace(inaccessibleComponents, monitor);
                    }
                };
                try {
                    IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)ReplaceInWorkspaceHook.this.getRepository());
                    IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspace, (IProgressMonitor)monitor.newChild(20));
                    IWorkspaceRollbackOperation op = IOperationFactory.instance.getWorkspaceRollbackOperation((WorkspaceUpdateDilemmaHandler)dilemmaHandler);
                    op.rollback(workspaceConnection, ReplaceInWorkspaceHook.this.getRepository(), (IHistoryReference)selectedState, componentFilter, (IProgressMonitor)monitor.newChild(10));
                    op.run((IProgressMonitor)monitor.newChild(70));
                }
                catch (TeamRepositoryException e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)ReplaceInWorkspaceHook.this.getWorkbenchPartSite().getShell(), (String)Messages.ReplaceInWorkspace_JOBNAME, (String)e.getMessage());
                        }
                    });
                }
            }
        });
    }

    private UIContext getUIContext() {
        IWorkbenchPage activePage = JFaceUtils.getWorkbenchPage();
        if (activePage != null && activePage.getWorkbenchWindow() != null) {
            IWorkbenchWindow workbenchWindow = activePage.getWorkbenchWindow();
            return UIContext.createPageContext((Display)workbenchWindow.getShell().getDisplay(), (Shell)workbenchWindow.getShell(), (IWorkbenchPage)activePage);
        }
        return null;
    }
}

