/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.hooks;

import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeHistorySyncReportInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.internal.filesystem.ui.web.common.AbstractRichClientHook;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.internal.filesystem.ui.web.common.SimpleJSONdeSerializer;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class OpenChangesHook
extends AbstractRichClientHook {
    public static final String NAME = "openChanges";
    private static final String FIELD_SELECTED_OPERATIONS = "selectedOperations";
    private static final String FIELD_SELECTED_CHANGESETS = "selectedChangesets";
    private static final String FIELD_CONTAINING_WORKSPACE = "containingWorkspace";
    private static final String FIELD_VIEW_ID = "viewID";
    private static final String FIELD_COMPONENT_IDS = "componentIds";
    private static final String CONSTANT_VIEW_CHANGE_EXPLORER = "changeExplorer";
    private static final String CONSTANT_VIEW_CHANGE_SUMMARY = "changeSummary";

    public OpenChangesHook(ITeamRepository repo, IWorkbenchPartSite site, IOperationRunner operationRunner) {
        super(repo, site, operationRunner);
    }

    @Override
    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs, EmbeddedBrowser.EmbeddedFunctionCallback callback) {
        JSONObject jsonArgs = callArgs.getUntyped(0, null);
        List selectedOperations = (List)SimpleJSONdeSerializer.getField(FIELD_SELECTED_OPERATIONS, jsonArgs, this.getRepository());
        List selectedChangeSets = (List)SimpleJSONdeSerializer.getField(FIELD_SELECTED_CHANGESETS, jsonArgs, this.getRepository());
        String viewID = (String)SimpleJSONdeSerializer.getField(FIELD_VIEW_ID, jsonArgs, this.getRepository());
        List components = (List)SimpleJSONdeSerializer.getField(FIELD_COMPONENT_IDS, jsonArgs, this.getRepository());
        IWorkspaceHandle containingWorkspace = (IWorkspaceHandle)SimpleJSONdeSerializer.getField(FIELD_CONTAINING_WORKSPACE, jsonArgs, this.getRepository());
        if (selectedOperations == null || selectedChangeSets == null || viewID == null) {
            throw new IllegalArgumentException();
        }
        RepositoryOperation repositoryOperation = null;
        if (!selectedOperations.isEmpty()) {
            repositoryOperation = this.getCompareHistoryOperation(viewID, selectedOperations, selectedChangeSets, components);
        } else if (!selectedChangeSets.isEmpty()) {
            repositoryOperation = this.getOpenChangesOperation(viewID, selectedChangeSets, containingWorkspace);
        }
        if (repositoryOperation != null) {
            this.getOperationRunner().enqueue(Messages.OpenChangeExplorerHook_JOB_NAME, (Operation)repositoryOperation);
        }
    }

    private RepositoryOperation getOpenChangesOperation(final String viewID, final List<IChangeSetHandle> selectedChangeSets, final IWorkspaceHandle containingWorkspace) {
        return new RepositoryOperation(this.getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                boolean shouldProceed = OpenChangesHook.this.warnIfNotCurrent(viewID, selectedChangeSets, (IProgressMonitor)progress.newChild(50));
                if (shouldProceed) {
                    WorkspaceId snapshotID = WorkspaceId.create((ITeamRepository)OpenChangesHook.this.getRepository(), (IWorkspaceHandle)containingWorkspace);
                    ChangeSetInput changeSetInput = new ChangeSetInput((SnapshotId)snapshotID, selectedChangeSets);
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    Runnable displayRunnable = OpenChangesHook.this.getDisplayRunnable(viewID, (SnapshotId)snapshotID, changeSetInput, selectedChangeSets);
                    if (display != null && !display.isDisposed()) {
                        display.asyncExec(displayRunnable);
                    }
                }
            }
        };
    }

    private boolean warnIfNotCurrent(String viewID, List<IChangeSetHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = this.getRepository();
        HashMap<UUID, ItemLocator> changeSetLocators = new HashMap<UUID, ItemLocator>();
        for (IChangeSetHandle handle : handles) {
            if (!handle.hasStateId()) continue;
            ItemLocator changeSetLocator = ItemLocator.create((ITeamRepository)repository, (IAuditableHandle)handle);
            changeSetLocators.put(handle.getItemId(), changeSetLocator);
        }
        boolean shouldWarn = false;
        Map currents = ItemFetcher.fetchCurrents(changeSetLocators.values(), (boolean)false, (IProgressMonitor)monitor);
        for (IChangeSetHandle handle : handles) {
            ItemLocator locator;
            IChangeSet changeSet;
            if (!handle.hasStateId() || (changeSet = (IChangeSet)currents.get(locator = (ItemLocator)changeSetLocators.get(handle.getItemId()))).sameStateId((IItemHandle)handle)) continue;
            shouldWarn = true;
            break;
        }
        if (shouldWarn) {
            String message;
            String[] buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            String string = message = viewID.equals(CONSTANT_VIEW_CHANGE_EXPLORER) ? Messages.OpenChanges_ChangeSetStatesWarning_ChangeExplorer : Messages.OpenChanges_ChangeSetStatesWarning_ChangeSummary;
            return JFaceUtils.showMessageButtonsBlocking((String)Messages.OpenChanges_ChangeSetStatesTitle, (String)message, (String[])buttons, (int)4, (int)0) == 0;
        }
        return true;
    }

    private Runnable getDisplayRunnable(final String viewID, final SnapshotId snapshot, final StructuralChangesViewInput input, final List<IChangeSetHandle> changeSets) {
        return new Runnable(){

            @Override
            public void run() {
                if (viewID.equals(OpenChangesHook.CONSTANT_VIEW_CHANGE_EXPLORER)) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    ChangesViewConverter.openChangeExplorer(page, input);
                } else if (viewID.equals(OpenChangesHook.CONSTANT_VIEW_CHANGE_SUMMARY)) {
                    ChangeSummaryView.open(snapshot, changeSets);
                } else {
                    throw new IllegalArgumentException();
                }
            }
        };
    }

    private RepositoryOperation getCompareHistoryOperation(final String viewID, final List<WorkspaceComponentState> selectedOperations, final List<IChangeSetHandle> selectedChangeSets, final List<IComponentHandle> components) {
        return new RepositoryOperation(this.getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                StructuralChangesViewInput input;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                WorkspaceManager manager = (WorkspaceManager)SCMPlatform.getWorkspaceManager((ITeamRepository)OpenChangesHook.this.getRepository());
                SnapshotId snapshot1 = SnapshotId.getSnapshotId((IHistoryReference)((IHistoryReference)selectedOperations.get(0)), (ITeamRepository)OpenChangesHook.this.getRepository());
                SnapshotId snapshot2 = selectedOperations.size() > 1 ? SnapshotId.getSnapshotId((IHistoryReference)((IHistoryReference)selectedOperations.get(1)), (ITeamRepository)OpenChangesHook.this.getRepository()) : SnapshotId.createEmptyId((ITeamRepository)OpenChangesHook.this.getRepository());
                int compareFlags = 128;
                if (selectedOperations.size() == 1 && viewID.equals(OpenChangesHook.CONSTANT_VIEW_CHANGE_EXPLORER)) {
                    compareFlags |= 7;
                }
                HashSet<UUID> changeSetUUIDS = new HashSet<UUID>();
                ArrayList<IChangeSetHandle> changeSets = null;
                if (viewID.equals(OpenChangesHook.CONSTANT_VIEW_CHANGE_SUMMARY) || !selectedChangeSets.isEmpty() || selectedOperations.size() > 1) {
                    changeSets = new ArrayList<IChangeSetHandle>();
                    for (IChangeSetHandle handle : selectedChangeSets) {
                        if (!changeSetUUIDS.add(handle.getItemId())) continue;
                        changeSets.add(handle);
                    }
                }
                IChangeHistorySyncReport report = null;
                int work = 80 / selectedOperations.size();
                for (WorkspaceComponentState state : selectedOperations) {
                    report = manager.compareHistories((IHistoryReference)state, null, compareFlags, components, (IProgressMonitor)progress.newChild(work));
                    if (changeSets == null) continue;
                    for (IChangeSetHandle handle : report.outgoingChangeSets()) {
                        if (!changeSetUUIDS.add(handle.getItemId())) continue;
                        changeSets.add(handle);
                    }
                }
                if (viewID.equals(OpenChangesHook.CONSTANT_VIEW_CHANGE_EXPLORER)) {
                    input = changeSets != null ? new ChangeSetInput(snapshot1, changeSets) : (snapshot2 != null ? new ChangeHistorySyncReportInput(report, snapshot2, snapshot1) : new ChangeHistorySyncReportInput(report, snapshot1));
                } else if (viewID.equals(OpenChangesHook.CONSTANT_VIEW_CHANGE_SUMMARY)) {
                    input = new ChangeSetInput(snapshot1, changeSets);
                } else {
                    throw new IllegalArgumentException();
                }
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display != null && !display.isDisposed()) {
                    Runnable displayRunnable = OpenChangesHook.this.getDisplayRunnable(viewID, snapshot1, input, changeSets);
                    display.asyncExec(displayRunnable);
                }
            }
        };
    }
}

