/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.hooks;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.web.common.AbstractRichClientHook;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.internal.filesystem.ui.web.common.SimpleJSONdeSerializer;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class CreateWorkspaceHook
extends AbstractRichClientHook {
    public static final String NAME = "createWorkspace";
    private static final String FIELD_SELECTED_STATE = "selectedState";
    private static final String FIELD_HISTORY_DATE = "historyDate";

    public CreateWorkspaceHook(ITeamRepository repo, IWorkbenchPartSite site, IOperationRunner operationRunner) {
        super(repo, site, operationRunner);
    }

    @Override
    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs, EmbeddedBrowser.EmbeddedFunctionCallback callback) {
        JSONObject jsonArgs = callArgs.getUntyped(0, null);
        final WorkspaceComponentState selectedState = (WorkspaceComponentState)SimpleJSONdeSerializer.getField(FIELD_SELECTED_STATE, jsonArgs, this.getRepository());
        final Date workspaceHistoryDate = (Date)SimpleJSONdeSerializer.getField(FIELD_HISTORY_DATE, jsonArgs, this.getRepository());
        if (selectedState == null || workspaceHistoryDate == null) {
            throw new IllegalArgumentException();
        }
        this.getOperationRunner().enqueue(Messages.CreateWorkspace_JOBNAME, (Operation)new RepositoryOperation(this.getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                WorkspaceManager manager = (WorkspaceManager)SCMPlatform.getWorkspaceManager((ITeamRepository)CreateWorkspaceHook.this.getRepository());
                IContributor owner = manager.teamRepository().loggedInContributor();
                Display display = PlatformUI.getWorkbench().getDisplay();
                final String[] desiredName = new String[1];
                IItemManager itemManager = CreateWorkspaceHook.this.getRepository().itemManager();
                final Workspace workspace = (Workspace)itemManager.fetchCompleteItem((IItemHandle)selectedState.getWorkspace(), 0, (IProgressMonitor)progress.newChild(25));
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String defaultName = NLS.bind((String)Messages.CreateWorkspace_defaultName, (Object)workspace.getName(), (Object[])new Object[]{workspaceHistoryDate});
                        InputDialog input = new InputDialog(CreateWorkspaceHook.this.getWorkbenchPartSite().getShell(), Messages.CreateWorkspace_title, Messages.CreateWorkspace_label, defaultName, new IInputValidator(){

                            public String isValid(String newText) {
                                if (newText == null || newText.trim().length() == 0) {
                                    return Messages.JoinWorkspaceNamePage_noNameErrorMessage;
                                }
                                return null;
                            }
                        });
                        if (input.open() == 0) {
                            desiredName[0] = input.getValue();
                        }
                    }
                });
                if (desiredName[0] == null) {
                    return;
                }
                try {
                    final IWorkspace newWorkspace = manager.createWorkspace((IContributorHandle)owner, desiredName[0], "", (IHistoryReference)selectedState, (IProgressMonitor)progress.newChild(75)).getResolvedWorkspace();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)newWorkspace);
                            IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
                            if (page != null) {
                                TeamPlaceEditorInput input = TeamPlaceEditorInput.newForEdit(AbstractPlaceWrapper.newWrapper(newWorkspace));
                                TeamPlacePart2.open(page, input);
                            }
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)CreateWorkspaceHook.this.getWorkbenchPartSite().getShell(), (String)Messages.CreateWorkspace_title, (String)e.getMessage());
                        }
                    });
                }
            }
        });
    }
}

