/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.hooks;

import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeHistorySyncReportInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.web.common.AbstractRichClientHook;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.internal.filesystem.ui.web.common.SimpleJSONdeSerializer;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class CompareHook
extends AbstractRichClientHook {
    public static final String NAME = "compareHistories";
    private static final String FIELD_LOCAL_REFERENCE = "localReference";
    private static final String FIELD_REMOTE_REFERENCE = "remoteReference";
    private static final String FIELD_COMPONENT_IDS = "componentIds";

    public CompareHook(ITeamRepository repo, IWorkbenchPartSite site, IOperationRunner operationRunner) {
        super(repo, site, operationRunner);
    }

    @Override
    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs, EmbeddedBrowser.EmbeddedFunctionCallback callback) {
        JSONObject jsonArgs = callArgs.getUntyped(0, null);
        final IHistoryReference localReference = (IHistoryReference)SimpleJSONdeSerializer.getField(FIELD_LOCAL_REFERENCE, jsonArgs, this.getRepository());
        final IHistoryReference remoteReference = (IHistoryReference)SimpleJSONdeSerializer.getField(FIELD_REMOTE_REFERENCE, jsonArgs, this.getRepository());
        if (localReference == null) {
            throw new IllegalArgumentException();
        }
        final List components = (List)SimpleJSONdeSerializer.getField(FIELD_COMPONENT_IDS, jsonArgs, this.getRepository());
        this.getOperationRunner().enqueue(Messages.OpenChangeExplorerHook_JOB_NAME, (Operation)new RepositoryOperation(this.getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                WorkspaceManager manager = (WorkspaceManager)SCMPlatform.getWorkspaceManager((ITeamRepository)CompareHook.this.getRepository());
                int flags = 135;
                IChangeHistorySyncReport report = manager.compareHistories(localReference, remoteReference, flags, components, monitor);
                SnapshotId local = CompareHook.this.getSnapshotId(CompareHook.this.getRepository(), localReference);
                SnapshotId remote = CompareHook.this.getSnapshotId(CompareHook.this.getRepository(), remoteReference);
                final ChangeHistorySyncReportInput input = new ChangeHistorySyncReportInput(report, remote, local);
                Display display = CompareHook.this.getWorkbenchPartSite().getShell().getDisplay();
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            ChangesViewConverter.openChangeExplorer(page, input);
                        }
                    });
                }
            }
        });
    }

    private SnapshotId getSnapshotId(ITeamRepository repo, IHistoryReference reference) {
        return SnapshotId.getSnapshotId((IHistoryReference)reference, (ITeamRepository)repo);
    }
}

