/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.entries;

import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.EraNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IConfigurationWrapper;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.views.history.entries.AbstractHistoryEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class VersionableHistoryEntry
extends AbstractHistoryEntry {
    private ChangeSetWrapper changeSet;
    private int index;
    private IItemContext dynamicContext;
    private EraDescriptor descriptor;
    private boolean writable;
    private Object domainElement;
    private ItemNamespace staticContext;
    private ItemId<IContributor> deliveredBy;
    private Date deliveryDate;
    private boolean isConfiguration;
    private AbstractFileSystemItemWrapper targetItem;
    private String versionId;
    private String versionNumber;
    private static ItemId<IBaseline> nullBaseline = ItemId.getNullItem((IItemType)IBaseline.ITEM_TYPE);

    public VersionableHistoryEntry(EraDescriptor descriptor, IChangeSet changeSet, int index, IItemContext provider, ItemNamespace staticContext, AbstractFileSystemItemWrapper targetItem, ItemId<IContributor> deliveredBy, Date timestamp, boolean isWritable, boolean isConfiguration) {
        if (descriptor == null || provider == null) {
            throw new IllegalArgumentException();
        }
        if (!Repositories.isSharedItem(descriptor.getRepository(), (IItem)changeSet)) {
            throw new IllegalArgumentException();
        }
        this.changeSet = provider.getNamespace() instanceof RepositoryNamespace ? new ChangeSetWrapper(provider.getNamespace().getRepository(), changeSet) : new ChangeSetInContextWrapper(provider.getNamespace(), changeSet);
        this.index = index;
        this.dynamicContext = provider;
        this.descriptor = descriptor;
        this.targetItem = targetItem;
        this.domainElement = this.changeSet;
        this.staticContext = staticContext;
        this.deliveredBy = deliveredBy;
        this.deliveryDate = timestamp;
        this.writable = isWritable;
        this.isConfiguration = isConfiguration;
    }

    @Override
    public boolean hasSnapshot() {
        return this.isConfiguration;
    }

    @Override
    public boolean hasChangeSemantics() {
        return true;
    }

    public static VersionableHistoryEntry constructEntry(EraDescriptor descriptor, int index, IItemContext dynamicContext, AbstractFileSystemItemWrapper targetItem, boolean isWritable, boolean hasSnapshot, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        DeliveryInfo delivery = descriptor.fetchDelivery(0, (IProgressMonitor)progress.newChild(1));
        IChangeSet changeSet = descriptor.fetchChangeSet(0, true, (IProgressMonitor)progress.newChild(1));
        return VersionableHistoryEntry.createEntry(descriptor, index, dynamicContext, targetItem, isWritable, hasSnapshot, delivery, changeSet);
    }

    public static VersionableHistoryEntry createEntry(EraDescriptor descriptor, int index, IItemContext dynamicContext, AbstractFileSystemItemWrapper targetItem, boolean isWritable, boolean hasSnapshot, DeliveryInfo delivery, IChangeSet changeSet) {
        IConfigurationWrapper snapshot = dynamicContext.getVersionableTree();
        if (snapshot != null && targetItem == null) {
            return new VersionableHistoryEntry(descriptor, changeSet, index, dynamicContext, (ItemNamespace)EraNamespace.create((EraDescriptor)descriptor), null, (ItemId<IContributor>)delivery.getDeliveredBy(), delivery.getDeliveryDate(), isWritable, hasSnapshot);
        }
        IChange change = null;
        if (changeSet != null && targetItem != null) {
            change = ChangeSetUtil.getChangeFor((IChangeSet)changeSet, (ItemId)targetItem.getItem());
        }
        if (change != null) {
            StateId afterState = ChangeSetUtil.getAfterState(change);
            Object newWrapper = AbstractFileSystemItemWrapper.newWrapper(afterState, targetItem.getFQName(), dynamicContext.getNamespace());
            return new VersionableHistoryEntry(descriptor, changeSet, index, dynamicContext, (ItemNamespace)EraNamespace.create((EraDescriptor)descriptor), (AbstractFileSystemItemWrapper)((Object)newWrapper), (ItemId<IContributor>)delivery.getDeliveredBy(), delivery.getDeliveryDate(), isWritable, hasSnapshot);
        }
        return new VersionableHistoryEntry(descriptor, changeSet, index, dynamicContext, (ItemNamespace)EraNamespace.create((EraDescriptor)descriptor), null, (ItemId<IContributor>)delivery.getDeliveredBy(), delivery.getDeliveryDate(), isWritable, hasSnapshot);
    }

    @Override
    public ItemId<IContributor> getDeliveredBy() {
        return this.deliveredBy;
    }

    @Override
    public ItemId<IContributor> getCreatedBy() {
        if (this.changeSet == null) {
            return ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
        }
        return ChangeSetUtil.getAuthor((IChangeSet)this.changeSet.getChangeSet());
    }

    @Override
    public ChangeSetWrapper getChangeSet() {
        return this.changeSet;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Date getDeliveryTime() {
        return this.deliveryDate;
    }

    @Override
    public Date getCreationTime() {
        if (this.changeSet == null) {
            return new Date(0L);
        }
        return this.changeSet.getChangeSet().getLastChangeDate();
    }

    @Override
    public IItemContext getDynamicContext() {
        return this.dynamicContext;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.dynamicContext.getNamespace().getRepository();
    }

    public int hashCode() {
        return this.descriptor.hashCode() + this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != VersionableHistoryEntry.class) {
            return false;
        }
        VersionableHistoryEntry other = (VersionableHistoryEntry)o;
        if (other.index != this.index) {
            return false;
        }
        if (!other.descriptor.equals(this.descriptor)) {
            return false;
        }
        if (!NullUtil.equals((Object)((Object)this.targetItem), (Object)((Object)other.targetItem))) {
            return false;
        }
        if (!NullUtil.equals((Object)this.dynamicContext, (Object)other.dynamicContext)) {
            return false;
        }
        return NullUtil.equals((Object)this.versionId, (Object)other.versionId);
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof VersionableHistoryEntry) {
            VersionableHistoryEntry nextEntry = (VersionableHistoryEntry)o;
            return this.index - nextEntry.index;
        }
        return super.compareTo(o);
    }

    @Override
    public IHistoryEntry getPrevious(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        EraDescriptor previousDescriptor = this.descriptor.discardLast((IProgressMonitor)progress.newChild(1));
        if (previousDescriptor == null || previousDescriptor.isEmpty()) {
            return null;
        }
        return VersionableHistoryEntry.constructEntry(previousDescriptor, this.index - 1, this.dynamicContext, this.targetItem, this.writable, this.isConfiguration, (IProgressMonitor)progress.newChild(9));
    }

    @Override
    public AbstractFileSystemItemWrapper getTargetItem() {
        return this.targetItem;
    }

    @Override
    public ItemNamespace getStaticNamespace() {
        return this.staticContext;
    }

    @Override
    public boolean hasTargetItem() {
        return this.targetItem != null;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public boolean hasConnection() {
        return this.getStaticNamespace().hasConnection() || this.getDynamicContext().getNamespace().hasConnection();
    }

    @Override
    public Object getDomainElement() {
        return this.domainElement;
    }

    @Override
    public ItemId<IBaseline> getBaselineHandle() {
        return nullBaseline;
    }

    @Override
    public IBaseline getBaseline() {
        return null;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public Object getAdapter(Class adapter) {
        Object adapted = this.changeSet.getAdapter(adapter);
        if (adapted != null) {
            return adapted;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean isConflictPoint() {
        IChange change;
        ChangeSetWrapper csw;
        if (this.targetItem != null && (csw = this.getChangeSet()) != null && (change = ChangeSetUtil.getChangeFor((IChangeSet)csw.getChangeSet(), (ItemId)this.targetItem.getItem())) != null) {
            return this.descriptor.isConflictPoint(change.afterState());
        }
        return false;
    }

    @Override
    public void setPrevious(IHistoryEntry previous) {
    }
}

