/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.entries;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.views.history.entries.AbstractHistoryEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.ChangeHistoryEntry;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChangeInWorkspaceHistoryEntry
extends AbstractHistoryEntry {
    private IItemContext dynamicContext;
    private ChangeHistoryEntry changeHistoryEntry;
    private ItemId<IContributor> deliveredBy = null;
    private ItemId<IContributor> createdBy = null;
    private IChangeSet changeSet;
    private Date creationTime;
    private Date deliveryTime;
    private ChangeSetWrapper changeSetWrapper;
    private boolean isContextWritable;
    private int index;
    private IHistoryEntry previous;
    private ItemNamespace staticNamepace;

    public ChangeInWorkspaceHistoryEntry(IItemContext dynamicContext, ItemNamespace staticNamespace, ChangeHistoryEntry changeHistoryEntry, IHistoryEntry previous, IChangeSet changeSet, boolean isWritable, int index) {
        if (dynamicContext == null || staticNamespace == null || changeHistoryEntry == null || changeSet == null || index < 0) {
            throw new IllegalArgumentException();
        }
        this.dynamicContext = dynamicContext;
        this.staticNamepace = staticNamespace;
        this.changeHistoryEntry = changeHistoryEntry;
        this.previous = previous;
        this.changeSet = changeSet;
        this.isContextWritable = isWritable;
        this.index = index;
    }

    @Override
    public boolean hasSnapshot() {
        return true;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.dynamicContext.getNamespace().getRepository();
    }

    @Override
    public ItemId<IContributor> getDeliveredBy() {
        if (this.deliveredBy == null) {
            this.deliveredBy = this.changeHistoryEntry.getCreatedBy() == null ? ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE) : new ItemId((IItemHandle)this.changeHistoryEntry.getCreatedBy());
        }
        return this.deliveredBy;
    }

    @Override
    public ItemId<IContributor> getCreatedBy() {
        if (this.createdBy == null) {
            this.createdBy = this.changeHistoryEntry.getChangeSet() == null ? ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE) : ChangeSetUtil.getAuthor((IChangeSet)this.changeSet);
        }
        return this.createdBy;
    }

    @Override
    public Date getDeliveryTime() {
        if (this.deliveryTime == null) {
            this.deliveryTime = this.changeHistoryEntry.getCreationDate() == null ? new Date(0L) : this.changeHistoryEntry.getCreationDate();
        }
        return this.deliveryTime;
    }

    @Override
    public Date getCreationTime() {
        if (this.creationTime == null) {
            this.creationTime = this.changeSet == null ? new Date(0L) : this.changeSet.getLastChangeDate();
        }
        return this.creationTime;
    }

    @Override
    public ChangeSetWrapper getChangeSet() {
        if (this.changeSetWrapper == null) {
            this.changeSetWrapper = this.dynamicContext.getNamespace() instanceof RepositoryNamespace ? new ChangeSetWrapper(this.dynamicContext.getNamespace().getRepository(), this.changeSet) : new ChangeSetInContextWrapper(this.dynamicContext.getNamespace(), this.changeSet);
        }
        return this.changeSetWrapper;
    }

    @Override
    public AbstractFileSystemItemWrapper getTargetItem() {
        return null;
    }

    @Override
    public boolean hasTargetItem() {
        return false;
    }

    @Override
    public boolean hasConnection() {
        return this.dynamicContext.getNamespace().hasConnection();
    }

    @Override
    public boolean isWritable() {
        return this.isContextWritable;
    }

    @Override
    public boolean hasChangeSemantics() {
        return true;
    }

    @Override
    public ItemNamespace getStaticNamespace() {
        return this.staticNamepace;
    }

    @Override
    public IItemContext getDynamicContext() {
        return this.dynamicContext;
    }

    @Override
    public Object getDomainElement() {
        return this.getChangeSet();
    }

    @Override
    public IHistoryEntry getPrevious(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.previous;
    }

    @Override
    public void setPrevious(IHistoryEntry previous) {
        this.previous = previous;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public ItemId<IBaseline> getBaselineHandle() {
        return ItemId.getNullItem((IItemType)IBaseline.ITEM_TYPE);
    }

    @Override
    public IBaseline getBaseline() {
        return null;
    }

    @Override
    public boolean isConflictPoint() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getChangeSet().hashCode();
        result = 31 * result + (this.dynamicContext == null ? 0 : this.dynamicContext.hashCode());
        result = 31 * result + (this.staticNamepace == null ? 0 : this.staticNamepace.hashCode());
        result = 31 * result + this.getCreatedBy().hashCode();
        result = 31 * result + this.getCreationTime().hashCode();
        result = 31 * result + this.getDeliveredBy().hashCode();
        result = 31 * result + this.getDeliveryTime().hashCode();
        result = 31 * result + this.index;
        result = 31 * result + (this.isContextWritable ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ChangeInWorkspaceHistoryEntry.class) {
            return false;
        }
        ChangeInWorkspaceHistoryEntry other = (ChangeInWorkspaceHistoryEntry)obj;
        if (this.index != other.index) {
            return false;
        }
        if (this.isContextWritable != other.isContextWritable) {
            return false;
        }
        if (!NullUtil.equals((Object)this.dynamicContext, (Object)other.getDynamicContext())) {
            return false;
        }
        if (!NullUtil.equals((Object)this.staticNamepace, (Object)other.getStaticNamespace())) {
            return false;
        }
        if (!this.getCreatedBy().equals(other.getCreatedBy())) {
            return false;
        }
        if (!this.getCreationTime().equals(other.getCreationTime())) {
            return false;
        }
        if (!this.getDeliveredBy().equals(other.getDeliveredBy())) {
            return false;
        }
        if (!this.getDeliveryTime().equals(other.getDeliveryTime())) {
            return false;
        }
        return this.getChangeSet().equals((Object)other.getChangeSet());
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof ChangeInWorkspaceHistoryEntry) {
            ChangeInWorkspaceHistoryEntry nextEntry = (ChangeInWorkspaceHistoryEntry)o;
            return this.index - nextEntry.index;
        }
        return super.compareTo(o);
    }
}

