/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.entries;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.EraNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.entries.AbstractHistoryEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineHistoryEntry
extends AbstractHistoryEntry {
    private IBaseline theBaseline;
    private IHistoryEntry previous;
    private ITeamRepository repository;
    private IItemContext dynamicContext;
    private int index;
    private ItemId<IContributor> deliveredBy;
    private ItemId<IContributor> createdBy;
    private int baselineID;
    private Date deliveryDate;
    private ItemId<IComponent> component;

    public BaselineHistoryEntry(IItemContext dynamicContext, IBaseline theBaseline, IHistoryEntry previous, ItemId<IContributor> deliveredBy, Date deliveryTime, ItemId<IComponent> component, int index) {
        this.theBaseline = theBaseline;
        this.previous = previous;
        this.repository = dynamicContext.getNamespace().getRepository();
        this.dynamicContext = dynamicContext;
        this.index = index;
        this.deliveredBy = deliveredBy;
        this.deliveryDate = deliveryTime;
        if (theBaseline != null) {
            this.createdBy = ItemUtil.getCreator((IBaseline)theBaseline);
            this.baselineID = theBaseline.getId();
        } else {
            this.createdBy = deliveredBy;
        }
        this.component = component;
    }

    public BaselineHistoryEntry(IItemContext dynamicContext2, IBaseline baseline, BaselineHistoryEntry prev, int index2) {
        this(dynamicContext2, baseline, prev, (ItemId<IContributor>)ItemUtil.getCreator((IBaseline)baseline), baseline.getCreationDate(), (ItemId<IComponent>)ItemUtil.getComponent((IBaseline)baseline), index2);
    }

    @Override
    public ItemId<IContributor> getDeliveredBy() {
        return this.deliveredBy;
    }

    @Override
    public ItemId<IContributor> getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public ChangeSetWrapper getChangeSet() {
        return null;
    }

    @Override
    public boolean hasChangeSemantics() {
        return false;
    }

    @Override
    public Object getDomainElement() {
        return this.theBaseline;
    }

    @Override
    public IItemContext getDynamicContext() {
        return this.dynamicContext;
    }

    public String getName() {
        if (this.theBaseline != null) {
            return BaselineWrapper.getLabel(this.theBaseline);
        }
        return Messages.BaselineHistoryEntry_0;
    }

    public String getBaselineDescription() {
        if (this.theBaseline != null) {
            return this.theBaseline.getComment();
        }
        return Messages.BaselineHistoryEntry_1;
    }

    public int getBaselineID() {
        return this.baselineID;
    }

    @Override
    public IHistoryEntry getPrevious(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.previous;
    }

    @Override
    public void setPrevious(IHistoryEntry previous) {
        this.previous = previous;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    @Override
    public ItemNamespace getStaticNamespace() {
        if (this.theBaseline == null) {
            return EraNamespace.createEmptyNamespace((ITeamRepository)this.repository, this.component);
        }
        return BaselineNamespace.create((ITeamRepository)this.repository, (ItemId)ItemId.forItem((IItem)this.theBaseline));
    }

    @Override
    public FileItemWrapper getTargetItem() {
        return null;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof BaselineHistoryEntry) {
            BaselineHistoryEntry nextEntry = (BaselineHistoryEntry)o;
            return this.index - nextEntry.index;
        }
        return super.compareTo(o);
    }

    @Override
    public Date getDeliveryTime() {
        return this.deliveryDate;
    }

    @Override
    public Date getCreationTime() {
        if (this.theBaseline == null) {
            return this.deliveryDate;
        }
        Date result = this.theBaseline.getCreationDate();
        return result != null ? result : new Date();
    }

    @Override
    public boolean hasConnection() {
        return true;
    }

    @Override
    public boolean hasSnapshot() {
        return true;
    }

    @Override
    public boolean hasTargetItem() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public ItemId<IBaseline> getBaselineHandle() {
        if (this.theBaseline == null) {
            return ItemId.getNullItem((IItemType)IBaseline.ITEM_TYPE);
        }
        return ItemId.forItem((IItem)this.theBaseline);
    }

    @Override
    public IBaseline getBaseline() {
        return this.theBaseline;
    }

    @Override
    public boolean isConflictPoint() {
        return false;
    }
}

