/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.columns;

import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.columns.IHistoryViewColumn;
import com.ibm.team.internal.filesystem.ui.views.history.entries.VersionableHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import org.eclipse.jface.action.IContributionItem;

public class VersionIdColumn
extends ConvertColumn<IHistoryEntry, String>
implements IHistoryViewColumn {
    public VersionIdColumn(SimpleTableViewer<IHistoryEntry> viewer, String title, int size) {
        super(viewer, title, size, (IConversion)new IConversion<IHistoryEntry, String>(){

            public String createAdapter(IHistoryEntry historyEntry) {
                if (historyEntry instanceof VersionableHistoryEntry) {
                    VersionableHistoryEntry entry = (VersionableHistoryEntry)historyEntry;
                    if (entry.getVersionId() != null) {
                        return entry.getVersionId();
                    }
                    AbstractFileSystemItemWrapper item = entry.getTargetItem();
                    if (item != null && item.getFileItem().isDeleted()) {
                        return Messages.HistoryView_deletedVersionLabel;
                    }
                }
                return Messages.IHistoryViewColumn_NOT_APPLICABLE;
            }
        });
    }

    @Override
    public boolean getDefaultVisible(AbstractHistoryViewInput input) {
        return input.getShowVersionIdColumn();
    }

    public IContributionItem getContextMenu() {
        return null;
    }
}

