/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.columns;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.views.history.GraphPaintListener;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryEntrySorter;
import com.ibm.team.internal.filesystem.ui.views.history.MergeInfo;
import com.ibm.team.internal.filesystem.ui.views.history.columns.IHistoryViewColumn;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class MergesColumn
extends LabelColumn<IHistoryEntry>
implements IHistoryViewColumn {
    private HistoryEntrySorter sorter;
    private ISetWithListeners<IHistoryEntry> knownElements;
    private ISetListener<IHistoryEntry> listener = new ISetListener<IHistoryEntry>(){

        public void changed(SetDiff<IHistoryEntry> diff) {
            MergesColumn.this.refresh();
        }
    };
    private ResourceManager resources;
    private Map<IHistoryEntry, MergeInfo> mergeData = new HashMap<IHistoryEntry, MergeInfo>();
    private Runnable recomputeRunnable = new Runnable(){

        @Override
        public void run() {
            if (MergesColumn.this.viewer.getTable().isDisposed()) {
                return;
            }
            MergesColumn.this.mergeData.clear();
            ArrayList entries = new ArrayList();
            entries.addAll(MergesColumn.this.knownElements.toCollection());
            Collections.sort(entries, MergesColumn.this.sorter);
            int linesOfDescent = 0;
            ArrayList<UUID> contents = new ArrayList<UUID>();
            MergeInfo currentInfo = null;
            boolean hasConflict = false;
            int count = 0;
            for (IHistoryEntry next : entries) {
                IChange nextChange = null;
                ChangeSetWrapper csw = next.getChangeSet();
                if (csw != null) {
                    nextChange = ChangeSetUtil.getChangeFor((IChangeSet)csw.getChangeSet(), (ItemId)MergesColumn.this.targetItem);
                }
                currentInfo = currentInfo == null ? MergeInfo.computeFirstRow(contents, nextChange) : currentInfo.computePredecessorRow(contents, contents, nextChange, ++count == entries.size());
                currentInfo.setConflictPoint(next.isConflictPoint());
                hasConflict |= next.isConflictPoint();
                if (contents.size() > linesOfDescent) {
                    linesOfDescent = contents.size();
                }
                MergesColumn.this.mergeData.put(next, currentInfo);
            }
            MergesColumn.this.paintListener.setTotalLinesOfDescent(linesOfDescent, hasConflict);
        }
    };
    private GraphPaintListener paintListener;
    private ItemId targetItem = ItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE);
    private SimpleTableViewer<IHistoryEntry> viewer;
    private Listener myeraseListener = new Listener(){

        public void handleEvent(Event event) {
        }
    };

    public MergesColumn(SimpleTableViewer<IHistoryEntry> viewer, String name, int size) {
        super(viewer, name, size);
        this.viewer = viewer;
        this.resources = new LocalResourceManager(JFaceResources.getResources());
        this.paintListener = new GraphPaintListener((Control)viewer.getTable(), this.resources){

            @Override
            public void handleEvent(Event event) {
                if (MergesColumn.this.targetItem.isNull()) {
                    return;
                }
                super.handleEvent(event);
            }

            @Override
            protected MergeInfo getMergeInfo(Object data) {
                return (MergeInfo)MergesColumn.this.mergeData.get(data);
            }
        };
        this.sorter = new HistoryEntrySorter();
        this.setLabelProvider((IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                label.setImage(null);
                label.setText("");
            }
        });
        this.setComparator(this.sorter);
        this.setPaintListener(this.paintListener);
        this.setEraseListener(this.myeraseListener);
        this.knownElements = viewer.getKnownElements();
        this.knownElements.addListener(this.listener);
    }

    private void refresh() {
        SWTUtil.runOnce((Display)Display.getCurrent(), (Runnable)this.recomputeRunnable);
    }

    public void setTargetItem(ItemId targetItem) {
        this.targetItem = targetItem;
        this.refresh();
    }

    public void dispose() {
        this.knownElements.removeListener(this.listener);
        super.dispose();
        this.resources.dispose();
    }

    @Override
    public boolean getDefaultVisible(AbstractHistoryViewInput input) {
        return input.getShowMergeGraphColumn();
    }
}

