/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.ui.changes.actions.DiscardChangeSetsAction;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.actions.StandardSuspendDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class SuspendWrapperAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List<ChangeSetInContextWrapper> changeSets = AdapterUtil.adaptList(selection.toList(), ChangeSetInContextWrapper.class);
        SuspendWrapperAction.doSuspend(this.getContext(), changeSets);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        List elements = ((IStructuredSelection)selection).toList();
        for (IComponentSyncContext context : ComponentSyncUtil.getContexts((Collection)elements)) {
            if (!context.getOutgoingTeamPlace().isStream()) continue;
            action.setEnabled(false);
            return;
        }
        action.setEnabled(true);
    }

    public static void doSuspend(final UIContext context, final Collection<ChangeSetInContextWrapper> changeSets) {
        if (changeSets.isEmpty()) {
            return;
        }
        context.getUserOperationRunner().enqueue(Messages.SuspendWrapperAction_suspendingJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                HashSet repositories = NewCollection.hashSet();
                for (ChangeSetInContextWrapper next : changeSets) {
                    repositories.add(next.getRepository());
                }
                SubMonitor loginProgress = progress.newChild(10).setWorkRemaining(repositories.size());
                for (ITeamRepository next : repositories) {
                    next.login((IProgressMonitor)loginProgress.newChild(1));
                }
                DiscardChangeSetsAction.doDiscard(DiscardChangeSetsAction.DiscardType.SUSPEND, new StandardSuspendDilemmaHandler(context), changeSets, (IProgressMonitor)progress.newChild(90));
            }
        });
    }
}

