/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.LocationPicker;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractVersionableHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.VersionableInWorkspaceHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class ShowHistoryAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        if (action.getActionDefinitionId() == null) {
            action.setActionDefinitionId("com.ibm.team.filesystem.ide.ui.command.showHistory");
        }
        if ((ss = this.getStructuredSelection()).size() != 1) {
            action.setEnabled(false);
            return;
        }
        Object element = ss.getFirstElement();
        AbstractHistoryViewInput input = this.adaptInput(element);
        action.setEnabled(input != null);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        final UIContext context = this.getContext();
        final AbstractHistoryViewInput input = this.adaptInput(element);
        if (input != null) {
            final AbstractFileSystemItemWrapper focusItem = input.getFocusItem();
            if (input instanceof VersionableInWorkspaceHistoryViewInput && input.getNamespace().isEmpty() && focusItem != null) {
                this.getOperationRunner().enqueue(Messages.ShowHistoryAction_fetchingComponentProgress, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        final ItemId componentId = input.getNamespace().fetchComponentId(monitor);
                        context.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                LocationPicker.pickLocation(ShowHistoryAction.this.getContext(), Messages.ShowHistoryAction_selectLocationDialogTitle, Messages.ShowHistoryAction_selectLocationDialogDescription, null, (ItemLocator<IComponent>)ItemLocator.create((ITeamRepository)input.getRepository(), (ItemId)componentId), false, new IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult>(){

                                    public void setResult(ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult result) {
                                        if (result != null) {
                                            AbstractFileSystemItemWrapper oldItem = focusItem;
                                            Object newItem = AbstractFileSystemItemWrapper.newWrapper(oldItem.getFileItem(), oldItem.getFQName(), result.getItemNamespace());
                                            AbstractHistoryViewInput newInput = AbstractVersionableHistoryViewInput.newVersionableHistoryViewInput(newItem);
                                            HistoryViewUtil.showHistory(ShowHistoryAction.this.getContext(), newInput);
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
                return;
            }
            HistoryViewUtil.showHistory(this.getContext(), input);
        } else {
            MessageDialogFactory.showMessage((Shell)shell, (int)1, (String)Messages.ShowHistoryAction_noHistoryFoundErrorDialogTitle, (String)Messages.ShowHistoryAction_noHistoryFoundErrorDialogText);
        }
    }

    private AbstractHistoryViewInput adaptInput(Object element) {
        AbstractHistoryViewInput input = null;
        if (element != null) {
            ISubcomponentChange change;
            if (element instanceof ISubcomponentChange && ((change = (ISubcomponentChange)element).isComponentInaccessible() || change.isComponentMissingFromWorkspace())) {
                return null;
            }
            input = (AbstractHistoryViewInput)Adapters.getAdapter((Object)element, AbstractHistoryViewInput.class);
            if (input == null) {
                IResource resource = (IResource)Adapters.getAdapter((Object)element, IResource.class);
                input = (AbstractHistoryViewInput)Adapters.getAdapter((Object)resource, AbstractHistoryViewInput.class);
            }
        }
        return input;
    }

    protected Object adaptEditorInput(IEditorInput input) {
        return this.adaptInput(input);
    }
}

