/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.actions.HistoryEntryUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class ShowChangeSetsAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        if (ss.size() < 1) {
            MessageDialogFactory.showMessage((Shell)shell, (IStatus)StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (int)1, (String)Messages.ShowInChangeExplorerAction_selectConfigurationsText, null));
            return;
        }
        List<IHistoryEntry> entries = AdapterUtil.adaptList(ss.toList(), IHistoryEntry.class);
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
        NamespaceSetId snapshot = null;
        for (IHistoryEntry next : entries) {
            snapshot = NamespaceSetId.create((ItemNamespace)next.getDynamicContext().getNamespace());
            ChangeSetWrapper wrapper = next.getChangeSet();
            if (wrapper == null) continue;
            changeSets.add((IChangeSetHandle)wrapper.getChangeSet());
        }
        if (snapshot != null) {
            this.open(page, (SnapshotId)snapshot, (List<IChangeSetHandle>)changeSets);
        }
    }

    protected abstract void open(IWorkbenchPage var1, SnapshotId var2, List<IChangeSetHandle> var3);

    public static void compareHistoryEntries(Display d, final IWorkbenchPage page, IHistoryEntry e1, IHistoryEntry lastEntry, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final StructuralChangesViewInput input = HistoryEntryUtil.compareEntries(e1, lastEntry, (IProgressMonitor)progress.newChild(100));
        if (input != null) {
            SWTUtil.greedyExec((Display)d, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ChangesViewConverter.openChangeExplorer(page, input);
                }
            });
        }
    }
}

