/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.changes.actions.StandardApplyPatchDilemmaHandler;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ApplyPatchUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class HistoryReverseChangesAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        ArrayList<ChangeSetInContextWrapper> changeSets = new ArrayList<ChangeSetInContextWrapper>();
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IHistoryEntry entry = (IHistoryEntry)object;
            ChangeSetWrapper csw = entry.getChangeSet();
            if (csw == null) {
                MessageDialogFactory.showMessage((Shell)shell, (int)1, (String)Messages.HistoryReverseChangesAction_invalidSelectionErrorMessage, (String)Messages.HistoryReverseChangesAction_noChangeSetFoundErrorMessage);
                return;
            }
            if (csw instanceof ChangeSetInContextWrapper) {
                changeSets.add((ChangeSetInContextWrapper)csw);
            } else {
                changeSets.add(new ChangeSetInContextWrapper(entry.getDynamicContext().getNamespace(), csw.getChangeSet()));
            }
            ++n2;
        }
        HistoryReverseChangesAction.reverseChanges(this.getContext(), changeSets);
    }

    public static void reverseChanges(final UIContext context, final List<? extends ChangeSetWrapper> changeSets) {
        ITeamRepository repository = changeSets.iterator().next().getRepository();
        String name = Messages.HistoryReverseChangesAction_reversingJobName;
        context.getUserOperationRunner().enqueue(name, (Operation)new RepositoryOperation(repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                ApplyPatchUtil.applyAsPatch(new StandardApplyPatchDilemmaHandler(context), changeSets, true, true, monitor);
            }
        });
    }

    public static void reverseActivities(final UIContext context, final List<IRemoteActivity> activities) {
        ITeamRepository repository = Repositories.getRepository(activities.iterator().next());
        String name = Messages.HistoryReverseChangesAction_reversingJobName;
        context.getUserOperationRunner().enqueue(name, (Operation)new RepositoryOperation(repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                ArrayList<IChangeSetHandle> handles = new ArrayList<IChangeSetHandle>();
                ArrayList<ChangeSetInContextWrapper> changeSets = new ArrayList<ChangeSetInContextWrapper>();
                HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
                ITeamRepository repo = null;
                for (IRemoteActivity activity : activities) {
                    IChangeSet changeSet = activity.getChangeSet();
                    if (changeSet == null) {
                        handles.add(activity.getChangeSetHandle());
                        repo = Repositories.getRepository(activity);
                        continue;
                    }
                    IComponentSyncContext syncContext = ComponentSyncUtil.getContext((Object)activity);
                    WorkspaceNamespace namespace = WorkspaceNamespace.create((IWorkspaceConnection)syncContext.getWorkspaceSyncContext().getLocal(), (IComponentHandle)syncContext.getComponent());
                    changeSets.add(new ChangeSetInContextWrapper((ItemNamespace)namespace, changeSet));
                    components.put(syncContext.getComponent().getItemId(), syncContext.getComponent());
                }
                if (repo != null) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                    List items = repo.itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)subMonitor.newChild(1));
                    block1: for (Object item : items) {
                        IChangeSet changeSet = (IChangeSet)item;
                        for (Object o : activities) {
                            IRemoteActivity activity = (IRemoteActivity)o;
                            if (!changeSet.sameItemId((IItemHandle)activity.getChangeSetHandle())) continue;
                            IComponentSyncContext syncContext = ComponentSyncUtil.getContext(o);
                            WorkspaceNamespace namespace = WorkspaceNamespace.create((IWorkspaceConnection)syncContext.getWorkspaceSyncContext().getLocal(), (IComponentHandle)syncContext.getComponent());
                            changeSets.add(new ChangeSetInContextWrapper((ItemNamespace)namespace, changeSet));
                            components.put(syncContext.getComponent().getItemId(), syncContext.getComponent());
                            continue block1;
                        }
                    }
                    monitor = subMonitor.newChild(9);
                }
                for (IComponent component : components.values()) {
                    Collection contexts = ComponentSyncUtil.getTrackedContexts((IComponentHandle)component, (boolean)true, (boolean)true);
                    if (contexts.size() <= 1) continue;
                    throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (String)Messages.HistoryReverseChangesAction_multipleWorkspacesMessage));
                }
                ApplyPatchUtil.applyAsPatch(new StandardApplyPatchDilemmaHandler(context), changeSets, true, true, monitor);
            }
        });
    }

    protected boolean hasActiveChanges(IWorkspaceConnection connection, IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        List activeChangeSets = connection.activeChangeSets(component);
        Collection changeSets = RepoFetcher.fetchCurrents((ITeamRepository)connection.teamRepository(), (Collection)ItemLists.handlesToIds((Collection)activeChangeSets), (IProgressMonitor)monitor).values();
        for (IChangeSet next : changeSets) {
            if (next.changes().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

