/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.era.EraSyncReport;
import com.ibm.team.filesystem.client.internal.namespace.EmptyNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotCompareInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;

public class HistoryEntryUtil {
    public static IHistoryEntry[] getTwoHistoryEntries(IStructuredSelection ss) {
        IHistoryEntry entry2;
        IHistoryEntry entry1;
        IHistoryEntry[] entries = new IHistoryEntry[2];
        if (ss.size() == 1) {
            entry2 = entry1 = (IHistoryEntry)ss.getFirstElement();
        } else if (ss.size() == 2) {
            Object[] sel = ss.toArray();
            entry1 = (IHistoryEntry)sel[0];
            entry2 = (IHistoryEntry)sel[1];
        } else {
            IItemContext snapshotProvider = null;
            IHistoryEntry earliest = null;
            IHistoryEntry latest = null;
            for (Object next : ss) {
                if (!(next instanceof IHistoryEntry)) continue;
                IHistoryEntry entry = (IHistoryEntry)next;
                if (snapshotProvider == null) {
                    snapshotProvider = entry.getDynamicContext();
                    earliest = entry;
                    latest = entry;
                    continue;
                }
                if (entry.compareTo(earliest) < 0) {
                    earliest = entry;
                }
                if (entry.compareTo(earliest) <= 0) continue;
                latest = entry;
            }
            entry1 = earliest;
            entry2 = latest;
        }
        if (entry1.compareTo(entry2) > 0) {
            entries[0] = entry1;
            entries[1] = entry2;
        } else {
            entries[0] = entry2;
            entries[1] = entry1;
        }
        return entries;
    }

    public static StructuralChangesViewInput compareWithPrevious(IHistoryEntry entry, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IHistoryEntry previous = entry.getPrevious((IProgressMonitor)progress.newChild(30));
        return HistoryEntryUtil.compareEntries(entry, previous, (IProgressMonitor)progress.newChild(70));
    }

    public static StructuralChangesViewInput compareEntries(IHistoryEntry later, IHistoryEntry earlier, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ItemNamespace namespace1 = HistoryEntryUtil.getNamespace(later, earlier, (IProgressMonitor)progress.newChild(50));
        ItemNamespace namespace2 = HistoryEntryUtil.getNamespace(earlier, later, (IProgressMonitor)progress.newChild(50));
        if (namespace1 != null && namespace2 != null) {
            return SnapshotCompareInput.create(namespace1, namespace2);
        }
        return null;
    }

    private static ItemNamespace getNamespace(IHistoryEntry entry, IHistoryEntry otherEntry, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemNamespace namespace = null;
        if (entry != null && (!(entry.getDynamicContext().getNamespace() instanceof RepositoryNamespace) || entry.hasSnapshot())) {
            namespace = entry.getStaticNamespace();
        } else {
            ItemNamespace earlierNamespace;
            ITeamRepository repo = null;
            ItemId component = null;
            ItemNamespace itemNamespace = earlierNamespace = otherEntry == null || otherEntry.getDynamicContext().getNamespace() instanceof RepositoryNamespace ? null : otherEntry.getDynamicContext().getNamespace();
            if (earlierNamespace != null) {
                repo = earlierNamespace.getRepository();
                component = earlierNamespace.fetchComponentId(monitor);
            } else if (entry != null && entry.getChangeSet() != null) {
                repo = entry.getChangeSet().getRepository();
                IComponentHandle componentHandle = entry.getChangeSet().getChangeSet().getComponent();
                component = ItemId.create((IItemHandle)componentHandle);
            } else if (otherEntry != null && otherEntry.getChangeSet() != null) {
                repo = otherEntry.getChangeSet().getRepository();
                IComponentHandle componentHandle = otherEntry.getChangeSet().getChangeSet().getComponent();
                component = ItemId.create((IItemHandle)componentHandle);
            }
            if (repo != null && component != null) {
                namespace = EmptyNamespace.create((ITeamRepository)repo, (ItemId)component);
            }
        }
        return namespace;
    }

    public static EraSyncReport syncEntries(IHistoryEntry entry1, IHistoryEntry entry2, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        EraDescriptor descriptor1 = null;
        if (entry1 != null) {
            IItemContext item1Context = entry1.getStaticNamespace().getContext((IProgressMonitor)progress.newChild(10));
            descriptor1 = item1Context.getChangeSets((IProgressMonitor)progress.newChild(10));
        }
        progress.setWorkRemaining(60);
        EraDescriptor descriptor2 = null;
        if (entry2 != null) {
            IItemContext item2Context = entry2.getStaticNamespace().getContext((IProgressMonitor)progress.newChild(10));
            descriptor2 = item2Context.getChangeSets((IProgressMonitor)progress.newChild(10));
        }
        progress.setWorkRemaining(20);
        return EraDescriptor.compare((EraDescriptor)descriptor1, descriptor2, (IProgressMonitor)progress.newChild(10));
    }
}

