/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.ui.changes.actions.AcceptChangeSetFromWildAction;
import com.ibm.team.filesystem.ui.changes.actions.StandardAcceptDilemmaHandler;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class HistoryAcceptAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean isEnabled = false;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            boolean allValidObjects = true;
            for (Object object : ss.toList()) {
                if (object instanceof IHistoryEntry && ((IHistoryEntry)object).hasChangeSemantics()) continue;
                allValidObjects = false;
                break;
            }
            isEnabled = allValidObjects;
        }
        action.setEnabled(isEnabled);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        final HashMap<ITeamRepository, ArrayList<IChangeSet>> repoToChangeSets = new HashMap<ITeamRepository, ArrayList<IChangeSet>>();
        for (Object object : ss.toList()) {
            IHistoryEntry historicEntry;
            ChangeSetWrapper changeSet;
            if (!(object instanceof IHistoryEntry) || (changeSet = (historicEntry = (IHistoryEntry)object).getChangeSet()) == null) continue;
            ITeamRepository repo = historicEntry.getStaticNamespace().getRepository();
            ArrayList<IChangeSet> changeSets = (ArrayList<IChangeSet>)repoToChangeSets.get(repo);
            if (changeSets == null) {
                changeSets = new ArrayList<IChangeSet>();
            }
            changeSets.add(changeSet.getChangeSet());
            repoToChangeSets.put(repo, changeSets);
        }
        if (repoToChangeSets.size() > 0) {
            final String name = Messages.HistoryAcceptAction_acceptingJobName;
            this.getOperationRunner().enqueue(name, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    for (Map.Entry entry : repoToChangeSets.entrySet()) {
                        ITeamRepository repo = (ITeamRepository)entry.getKey();
                        List changeSets = (List)entry.getValue();
                        List changeSetItemIds = ItemLists.handlesToIds((Collection)changeSets);
                        WarnWorkspaceUpdate warnWorkspaceUpdate = new WarnWorkspaceUpdate(HistoryAcceptAction.this.getContext(), name);
                        StandardAcceptDilemmaHandler dilemmaHandler = new StandardAcceptDilemmaHandler(HistoryAcceptAction.this.getContext());
                        AcceptChangeSetFromWildAction.acceptChanges(warnWorkspaceUpdate, dilemmaHandler, ItemLocator.idsToLocators((ItemNamespace)RepositoryNamespace.create((ITeamRepository)repo), (Collection)changeSetItemIds), monitor);
                    }
                }
            });
        }
    }
}

