/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.content.IVersionedContentManager;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IVersionedContentClaimerData;
import com.ibm.team.scm.common.VersionedContentClaimedByMultipleItems;
import com.ibm.team.scm.common.internal.dto2.VersionedContentClaimedInMultipleItemsData;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DeleteContentAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (!(element instanceof ChangeNode)) {
            return;
        }
        int confirmDelete = JFaceUtils.showMessageButtonsBlocking((String)Messages.DeleteContentAction_confirmDeleteTitle, (String)Messages.DeleteContentAction_confirmDeleteMessage, (String[])new String[]{Messages.DeleteContentAction_deleteButtonText, Messages.DeleteContentAction_cancelDeleteButtonText}, (int)4, (int)1, (String)"com.ibm.team.filesystem.ide.ui.dialog_confirmcontentdelete");
        if (confirmDelete != 0) {
            return;
        }
        ChangeNode node = (ChangeNode)element;
        final IVersionableHandle state = node.getState();
        ITeamRepository repo = node.getNamespace().getRepository();
        final IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager();
        IVersionedContentManager cm = SCMPlatform.getContentManager((ITeamRepository)repo);
        PartSiteJobRunner runner = page != null ? new PartSiteJobRunner(page.getActivePart().getSite(), true) : new JobRunner(true);
        runner.enqueue(Messages.DeleteContentAction_deleteContentJob, (Operation)new RepositoryOperation(repo, (IOperationRunner)runner, repo, cm){
            private final /* synthetic */ IOperationRunner val$runner;
            private final /* synthetic */ ITeamRepository val$repo;
            private final /* synthetic */ IVersionedContentManager val$cm;
            {
                this.val$runner = iOperationRunner;
                this.val$repo = iTeamRepository;
                this.val$cm = iVersionedContentManager;
                super($anonymous0);
            }

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                IFileItem fileItem;
                IFileContent content;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                IVersionable fetchedVersionable = versionableManager.fetchCompleteState(state, (IProgressMonitor)progress.newChild(1));
                if (fetchedVersionable instanceof IFileItem && (content = (fileItem = (IFileItem)fetchedVersionable).getContent()) != null) {
                    ContentHash hash = content.getHash();
                    DeleteContentAction.this.deleteContent(this.val$runner, this.val$repo, this.val$cm, hash, false, progress.newChild(1));
                }
            }
        });
    }

    private void deleteContent(final IOperationRunner runner, final ITeamRepository repo, final IVersionedContentManager cm, final ContentHash hash, boolean force, SubMonitor progress) throws TeamRepositoryException {
        try {
            cm.deleteContent(hash, force, (IProgressMonitor)progress.newChild(1));
        }
        catch (PermissionDeniedException e) {
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    JFaceUtils.showError((String)Messages.DeleteContentAction_deleteContentTitle, (String)Messages.DeleteContentAction_insufficientPermissionMsg, (Throwable)e);
                }
            });
        }
        catch (VersionedContentClaimedByMultipleItems e) {
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    String title = Messages.DeleteContentAction_ContentClaimedDialogTitle;
                    StringBuffer message = new StringBuffer();
                    int MAX_PATHS_TO_SHOW = 5;
                    VersionedContentClaimedInMultipleItemsData allClaimData = e.getData();
                    int totalClaimers = allClaimData.getTotalClaimers();
                    if (totalClaimers > 0) {
                        StringBuffer claimedPaths = new StringBuffer();
                        claimedPaths = totalClaimers == 1 ? new StringBuffer(Messages.DeleteContentAction_ContentClaimedDialogMessage1) : (totalClaimers > 1 && totalClaimers <= 5 ? new StringBuffer(Messages.DeleteContentAction_ContentClaimedDialogMessage2) : new StringBuffer(NLS.bind((String)Messages.DeleteContentAction_ContentClaimedDialogMessage3, (Object)totalClaimers, (Object)5)));
                        int numPathsShown = 0;
                        List claimerData = e.getClaimerData();
                        for (IVersionedContentClaimerData data : claimerData) {
                            if (numPathsShown >= 5) break;
                            String component = data.getComponentName();
                            String path = data.getApproximatePath();
                            if ("UNKNOWN".equals(path)) continue;
                            String fullPath = component == null || component.isEmpty() ? path : String.valueOf(component) + path;
                            claimedPaths.append("\n   " + fullPath);
                            ++numPathsShown;
                        }
                        if (numPathsShown > 0) {
                            message.append(claimedPaths);
                            message.append("\n\n");
                        }
                    }
                    message.append(Messages.DeleteContentAction_ContentClaimedDialogMessage4);
                    int confirmDelete = JFaceUtils.showMessageButtonsBlocking((String)title, (String)message.toString(), (String[])new String[]{Messages.DeleteContentAction_deleteButtonText, Messages.DeleteContentAction_cancelDeleteButtonText}, (int)4, (int)1, (String)"com.ibm.team.filesystem.ide.ui.dialog_confirmforcecontentdelete");
                    if (confirmDelete == 0) {
                        runner.enqueue(Messages.DeleteContentAction_deleteContentJob, (Operation)new RepositoryOperation(repo){

                            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                                DeleteContentAction.this.deleteContent(runner, repo, cm, hash, true, progress.newChild(1));
                            }
                        });
                    }
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            if (ss.size() > 1) {
                action.setEnabled(false);
                return;
            }
            Object element = ss.getFirstElement();
            if (element instanceof ChangeNode) {
                ChangeNode node = (ChangeNode)element;
                action.setEnabled(node.getState() != null && node.hasContent());
            }
        }
    }
}

