/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenShareableInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateRemoteFunction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareWithLocalFileAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        Object first;
        IStructuredSelection ss;
        boolean isEnabled = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (first = ss.getFirstElement()) != null && first instanceof AbstractFileSystemItemWrapper) {
            isEnabled = true;
        }
        action.setEnabled(isEnabled);
        super.selectionChanged(action, selection);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        AbstractFileSystemItemWrapper wrapper = (AbstractFileSystemItemWrapper)((Object)selection.getFirstElement());
        CompareWithLocalFileAction.compareFile(this.getContext(), wrapper);
    }

    public static void compareFile(final UIContext context, final AbstractFileSystemItemWrapper wrapper) {
        final Display display = Display.getCurrent();
        final Shell shell = context.getShell();
        context.getUserOperationRunner().enqueue(Messages.CompareWithLocalFileAction_comparingFilesJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector collector) throws OperationFailedException, TeamRepositoryException {
                ResourceType resourceType;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IShareable shareable = null;
                final Set shareables = CoreShareablesUtil.findShareables((ItemId)wrapper.getFileItem().getItemId(), (ItemNamespace)wrapper.getWorkspace(), (IProgressMonitor)progress.newChild(60));
                if (shareables.size() != 1) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String dialogTitle = Messages.CompareWithLocalFileAction_ErrorDialogTitle;
                            String dialogMessage = shareables.size() == 0 ? NLS.bind((String)Messages.CompareWithLocalFileAction_fileNotLoadedErrorMessage, (Object)wrapper.getName()) : NLS.bind((String)Messages.CompareWithLocalFileAction_fileLoadedMoreThanOnceErrorMessage, (Object)wrapper.getName());
                            MessageDialog.openInformation((Shell)shell, (String)dialogTitle, (String)dialogMessage);
                        }
                    });
                    return;
                }
                if (shareables.size() == 1) {
                    shareable = (IShareable)shareables.iterator().next();
                }
                if (shareable != null && ((resourceType = shareable.getResourceType((IProgressMonitor)progress.newChild(1))) == ResourceType.FILE || resourceType == ResourceType.SYMBOLIC_LINK)) {
                    ISharingDescriptor desc = shareable.getShare((IProgressMonitor)progress.newChild(29)).getSharingDescriptor();
                    final ITeamRepository repository = RepositoryUtils.getTeamRepository((ISharingDescriptor)desc);
                    final IShareable finalShareable = shareable;
                    boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(shareable);
                    if (useExternalCompareTool) {
                        final OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = OpenInExternalCompareAction.get2WayLocalCompareCommandLine();
                        String commandLine = externalCommandLinePreference.getCommandLine();
                        if (commandLine == null) {
                            SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (!shell.isDisposed()) {
                                        externalCommandLinePreference.openPreferenceDialog(shell, null);
                                    }
                                }
                            });
                            return;
                        }
                        FileStateRemoteFunction remoteStateComputer = new FileStateRemoteFunction(repository, wrapper.getFileItem());
                        FileState remoteFileState = (FileState)remoteStateComputer.compute((IProgressMonitor)progress.newChild(5));
                        OpenShareableInExternalCompareOperation externalCompareOperation = new OpenShareableInExternalCompareOperation(commandLine, finalShareable, remoteFileState, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context));
                        externalCompareOperation.run((IProgressMonitor)progress.newChild(5));
                    } else {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                OpenInCompareAction.openCompareEditor(DelegatingSaveableCompareEditorInput.createInput(context.getPage(), finalShareable, (IRemoteFunction<FileState>)new FileStateRemoteFunction(repository, wrapper.getFileItem()), false), context.getPage());
                            }
                        });
                    }
                }
            }
        });
    }
}

