/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenFileItemInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateRemoteFunction;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.internal.filesystem.ui.views.history.actions.CompareFilesAction;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.text.DateFormat;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareStatesAction
extends AbstractActionDelegate {
    public void run(Shell shell, final IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.size() != 2) {
            MessageDialog.openInformation((Shell)shell, null, (String)Messages.CompareHistoryFilesAction_selectStates);
            return;
        }
        final UIContext context = UIContext.createPageContext((Shell)shell, (IWorkbenchPage)page);
        Object[] sel = selection.toArray();
        final ChangeNode node1 = (ChangeNode)sel[0];
        final ITeamRepository repo1 = node1.getNamespace().getRepository();
        final ChangeNode node2 = (ChangeNode)sel[1];
        final ITeamRepository repo2 = node1.getNamespace().getRepository();
        context.getUserOperationRunner().enqueue(Messages.CompareStatesAction_operationMessage, (Operation)new RepositoryOperation(Arrays.asList(repo1, repo2)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                FileStateRemoteFunction leftStateComputer = new FileStateRemoteFunction(repo1, CompareStatesAction.this.createStateId(node1.getState()));
                FileStateRemoteFunction rightStateComputer = new FileStateRemoteFunction(repo2, CompareStatesAction.this.createStateId(node2.getState()));
                String name1 = "";
                String name2 = "";
                FileState leftFileState = null;
                FileState rightFileState = null;
                try {
                    leftFileState = (FileState)leftStateComputer.compute((IProgressMonitor)progress.newChild(40));
                    rightFileState = (FileState)rightStateComputer.compute((IProgressMonitor)progress.newChild(40));
                    name1 = leftFileState.getPath().getName();
                    name2 = rightFileState.getPath().getName();
                }
                catch (TeamRepositoryException e) {
                    Status status = new Status(2, "com.ibm.team.filesystem.ide.ui", Messages.CompareStatesAction_failedToRetrieveFileDescriptionMessage, (Throwable)e);
                    UiPlugin.getDefault().getLog().log((IStatus)status);
                }
                final FileItemWrapper fiw1 = CompareStatesAction.this.createFileItemWrapper(node1, name1);
                final FileItemWrapper fiw2 = CompareStatesAction.this.createFileItemWrapper(node2, name2);
                DateFormat formatter = DateFormat.getDateTimeInstance(2, 2);
                final String label1 = NLS.bind((String)Messages.CompareStatesAction_comparisonLabel, (Object)HistoryViewUtil.getChangeTypeText(node1.getType()), (Object)formatter.format(node1.getDate()));
                final String label2 = NLS.bind((String)Messages.CompareStatesAction_comparisonLabel, (Object)HistoryViewUtil.getChangeTypeText(node2.getType()), (Object)formatter.format(node2.getDate()));
                boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(fiw1.getName());
                if (useExternalCompareTool) {
                    final OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = OpenInExternalCompareAction.get2WayRemoteCompareCommandLine();
                    String commandLine = externalCommandLinePreference.getCommandLine();
                    if (commandLine == null) {
                        SWTUtil.greedyExec((Display)context.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = context.getShell();
                                if (!shell.isDisposed()) {
                                    externalCommandLinePreference.openPreferenceDialog(shell);
                                }
                            }
                        });
                        return;
                    }
                    String leftLabel = " " + label1;
                    String rightLabel = " " + label2;
                    OpenFileItemInExternalCompareOperation externalCompareOperation = new OpenFileItemInExternalCompareOperation(commandLine, leftFileState, leftLabel, rightFileState, rightLabel, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context));
                    externalCompareOperation.run((IProgressMonitor)progress.newChild(20));
                } else {
                    progress.done();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CompareFilesAction.openCompareEditor(page, fiw2, fiw1, label1, label2);
                        }
                    });
                }
            }
        });
    }

    private FileItemWrapper createFileItemWrapper(ChangeNode node, String fqName) {
        StateId<IFileItem> stateId = this.createStateId(node.getState());
        FileItemWrapper fiw = new FileItemWrapper(stateId, fqName, node.getNamespace());
        return fiw;
    }

    private StateId<IFileItem> createStateId(IVersionableHandle state) {
        StateId stateId = state == null ? new StateId(ItemId.getNullItem((IItemType)ItemId.getNullItemType()), StateId.STATE_DELETED) : new StateId((IItemHandle)state);
        return stateId;
    }
}

