/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotCompareInput;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareHistoryWithLocalWorkspaceAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        CompareHistoryWithLocalWorkspaceAction.compareHistory(this.getOperationRunner(), shell, page, (IHistoryEntry)selection.getFirstElement());
    }

    public static void compareHistory(IOperationRunner runner, final Shell shell, final IWorkbenchPage page, final IHistoryEntry historyEntry) {
        final Display display = Display.getCurrent();
        runner.enqueue(Messages.CompareHistoryWithLocalWorkspaceAction_compareConfigurationsJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                final ItemNamespace staticNamespace = historyEntry.getStaticNamespace();
                final ItemId component = staticNamespace.fetchComponentId((IProgressMonitor)progress.newChild(100));
                SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String workspacePickerMessage = Messages.CompareHistoryWithLocalWorkspaceAction_pickWorkspaceDialogMessage;
                        WorkspaceNamespace whereToCollaborate = PendingChangesUtil.getTrackedWorkspaceForComponent(shell, (ItemId<IComponent>)component, true, false, workspacePickerMessage);
                        if (whereToCollaborate == null) {
                            return;
                        }
                        ChangesViewConverter.openChangeExplorer(page, SnapshotCompareInput.create(staticNamespace, (ItemNamespace)whereToCollaborate));
                    }
                });
            }
        });
    }
}

