/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.actions.CompareWithLocalFileAction;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareHistoryWithLocalFileAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        if (!this.hasWrappersSelected(ss)) {
            MessageDialog.openInformation((Shell)shell, null, (String)Messages.CompareHistoryWithLocalFileAction_selectStateDialogText);
            return;
        }
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selection = objectArray[n2];
            IHistoryEntry entry = (IHistoryEntry)selection;
            AbstractFileSystemItemWrapper target = entry.getTargetItem();
            if (target instanceof FileItemWrapper || target instanceof SymbolicLinkItemWrapper) {
                CompareWithLocalFileAction.compareFile(this.getContext(), target);
            }
            ++n2;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean enabled = false;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            enabled = this.hasWrappersSelected(ss);
        }
        action.setEnabled(enabled);
    }

    private boolean hasWrappersSelected(IStructuredSelection ss) {
        if (ss.size() > 0) {
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selection = objectArray[n2];
                IHistoryEntry entry = (IHistoryEntry)selection;
                AbstractFileSystemItemWrapper target = entry.getTargetItem();
                if (!(target instanceof FileItemWrapper) && !(target instanceof SymbolicLinkItemWrapper)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

