/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.ClientConfigurationChangeFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.DescriptionRecord;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenFileItemInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateRemoteFunction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.history.actions.CompareFilesAction;
import com.ibm.team.internal.filesystem.ui.views.history.actions.HistoryEntryUtil;
import com.ibm.team.internal.filesystem.ui.views.history.actions.ShowInChangeExplorerAction;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CompareHistoryFilesAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        if (ss.size() < 1) {
            MessageDialog.openInformation((Shell)shell, null, (String)Messages.CompareHistoryFilesAction_selectStates);
            return;
        }
        if (ss.size() == 2) {
            IHistoryEntry[] entries = HistoryEntryUtil.getTwoHistoryEntries(ss);
            IHistoryEntry entry1 = entries[0];
            IHistoryEntry entry2 = entries[1];
            CompareHistoryFilesAction.compareHistoryEntries(this.getContext(), entry1, entry2);
        } else {
            IHistoryEntry entry = (IHistoryEntry)ss.getFirstElement();
            CompareHistoryFilesAction.compareWithPrevious(this.getContext(), entry);
        }
    }

    public static void compareHistoryEntries(final UIContext context, final IHistoryEntry entry1, final IHistoryEntry entry2) {
        final AbstractFileSystemItemWrapper wrapper1 = entry1.getTargetItem();
        final AbstractFileSystemItemWrapper wrapper2 = entry2.getTargetItem();
        IOperationRunner runner = context.getUserOperationRunner();
        if (wrapper1 != null && wrapper2 != null) {
            final Display d = Display.getCurrent();
            runner.enqueue(Messages.CompareHistoryFilesAction_comparingFilesJobName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException {
                    ChangeSetWrapper cs1 = entry1.getChangeSet();
                    ChangeSetWrapper cs2 = entry2.getChangeSet();
                    if (cs1 != null && cs2 != null) {
                        ArrayList<IChangeSet> changeSets = new ArrayList<IChangeSet>();
                        changeSets.add(cs1.getChangeSet());
                        changeSets.add(cs2.getChangeSet());
                        ITeamRepository repo = entry1.getRepository();
                        Map descriptions = EraCache.fetchDescriptions((ITeamRepository)repo, changeSets, (IRepositoryResolver)IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)monitor);
                        final DescriptionRecord d1 = (DescriptionRecord)descriptions.get(ItemId.forItem((IItem)cs1.getChangeSet()));
                        final DescriptionRecord d2 = (DescriptionRecord)descriptions.get(ItemId.forItem((IItem)cs2.getChangeSet()));
                        boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(wrapper1.getName());
                        if (useExternalCompareTool) {
                            final OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = OpenInExternalCompareAction.get2WayRemoteCompareCommandLine();
                            String commandLine = externalCommandLinePreference.getCommandLine();
                            if (commandLine == null) {
                                final Shell shell = context.getShell();
                                SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!shell.isDisposed()) {
                                            externalCommandLinePreference.openPreferenceDialog(shell, null);
                                        }
                                    }
                                });
                                return;
                            }
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            FileStateRemoteFunction leftStateComputer = new FileStateRemoteFunction(wrapper1.getRepository(), wrapper1.getFileItem());
                            FileState leftFileState = (FileState)leftStateComputer.compute((IProgressMonitor)progress.newChild(10));
                            FileStateRemoteFunction rightStateComputer = new FileStateRemoteFunction(wrapper2.getRepository(), wrapper2.getFileItem());
                            FileState rightFileState = (FileState)rightStateComputer.compute((IProgressMonitor)progress.newChild(10));
                            String leftDescription = d1.getDescription();
                            String rightDescription = d2.getDescription();
                            String leftLabel = " " + leftDescription;
                            String rightLabel = " " + rightDescription;
                            OpenFileItemInExternalCompareOperation externalCompareOperation = new OpenFileItemInExternalCompareOperation(commandLine, leftFileState, leftLabel, rightFileState, rightLabel, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context));
                            externalCompareOperation.run(monitor);
                        } else if (d1 != null && d2 != null) {
                            d.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CompareFilesAction.openCompareEditor(context.getPage(), wrapper2, wrapper1, d1.getDescription(), d2.getDescription());
                                }
                            });
                        }
                    }
                }
            });
        } else if (wrapper1 == null && wrapper2 == null) {
            final Display d = Display.getCurrent();
            runner.enqueue(Messages.CompareHistoryFilesAction_comparingConfigurationsJobName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                    ShowInChangeExplorerAction.compareHistoryEntries(d, context.getPage(), entry1, entry2, monitor);
                }
            });
        } else {
            context.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)context.getShell(), (String)Messages.CompareHistoryFilesAction_CannotCompareFilesDialogTitle, (String)Messages.CompareHistoryFilesAction_CannotCompareFilesDialogMessage);
                }
            });
        }
    }

    public static void compareWithPrevious(final UIContext context, final IHistoryEntry entry) {
        final Display d = context.getDisplay();
        final AbstractFileSystemItemWrapper targetItem = entry.getTargetItem();
        if (targetItem != null) {
            context.getUserOperationRunner().enqueue(Messages.CompareHistoryFilesAction_fetchingJobName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    IChangeSet changeSet = entry.getChangeSet().getChangeSet();
                    SiloedItemId target = SiloedItemId.create((ItemId)targetItem.getItem(), (ItemId)ChangeSetUtil.getComponent((IChangeSet)changeSet));
                    boolean getVersionIds = OpenInCompareAction.showVersionIdForCompare();
                    List changes = ClientConfigurationChangeFactory.getChangeForTarget((ITeamRepository)entry.getRepository(), Collections.singletonList(changeSet), (boolean)getVersionIds, (SubMonitor)progress.newChild(25), (SiloedItemId)target);
                    if (changes.isEmpty()) {
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)context.getShell(), null, (String)Messages.CompareHistoryFilesAction_noChangesDialogText);
                            }
                        });
                        return;
                    }
                    final FileChange change = (FileChange)changes.iterator().next();
                    boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(change.getFinal().getPath().getName());
                    if (useExternalCompareTool) {
                        final OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = OpenInExternalCompareAction.get2WayRemoteCompareCommandLine();
                        String commandLine = externalCommandLinePreference.getCommandLine();
                        if (commandLine == null) {
                            final Shell shell = context.getShell();
                            SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (!shell.isDisposed()) {
                                        externalCommandLinePreference.openPreferenceDialog(shell, null);
                                    }
                                }
                            });
                            return;
                        }
                        FileState leftFileState = change.getFinal();
                        FileState rightFileState = change.getInitial();
                        String leftLabel = " " + Messages.OpenAction_0;
                        String rightLabel = " " + Messages.OpenAction_1;
                        progress.setTaskName(Messages.OpenInExternalCompareAction_2);
                        OpenFileItemInExternalCompareOperation externalCompareOperation = new OpenFileItemInExternalCompareOperation(commandLine, leftFileState, leftLabel, rightFileState, rightLabel, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context));
                        externalCompareOperation.run((IProgressMonitor)progress.newChild(75));
                    } else {
                        progress.setWorkRemaining(0);
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                FileChangeEditorInput input = FileChangeEditorInput.createFrom((FileChange)change);
                                input.setLabels(Messages.OpenAction_0, Messages.OpenAction_1);
                                OpenInCompareAction.openCompareEditor((CompareEditorInput)input, context.getPage());
                            }
                        });
                    }
                }
            });
        } else {
            context.getUserOperationRunner().enqueue(Messages.CompareHistoryFilesAction_fetchingChangeSetsJobName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    final StructuralChangesViewInput input = entry.hasChangeSemantics() ? new ChangeSetInput((SnapshotId)NamespaceSetId.create((ItemNamespace)entry.getDynamicContext().getNamespace()), (IChangeSetHandle)entry.getChangeSet().getChangeSet()) : HistoryEntryUtil.compareWithPrevious(entry, monitor);
                    if (input != null) {
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (input instanceof ChangeSetInput) {
                                    ChangeSummaryView.open(input.getOutgoing(), Collections.singletonList(entry.getChangeSet().getChangeSet()));
                                } else {
                                    ChangesViewConverter.openChangeExplorer(context.getPage(), input);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        String actionName = Messages.CompareHistoryFilesAction_compareAction;
        action.setImageDescriptor(ImagePool.CHANGES_VIEW_ICON);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() == 1) {
                actionName = Messages.CompareHistoryFilesAction_compareWithPreviousAction;
            }
            action.setEnabled(ss.size() == 1 || ss.size() == 2);
        }
        if (!NullUtil.equals((Object)action.getText(), (Object)actionName)) {
            action.setText(actionName);
        }
    }
}

