/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.hooks.AddStreamsHook;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryPageSite;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryPreferencesPart;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryView;
import com.ibm.team.internal.filesystem.ui.views.history.WorkspaceHistoryPreferencesPart;
import com.ibm.team.internal.filesystem.ui.views.history.hooks.CompareHook;
import com.ibm.team.internal.filesystem.ui.views.history.hooks.CreateWorkspaceHook;
import com.ibm.team.internal.filesystem.ui.views.history.hooks.OpenChangesHook;
import com.ibm.team.internal.filesystem.ui.views.history.hooks.ReplaceInWorkspaceHook;
import com.ibm.team.internal.filesystem.ui.views.history.hooks.SelectUserHook;
import com.ibm.team.internal.filesystem.ui.views.history.hooks.ShowOperationHistoryHook;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.WorkspaceHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.preferences.RecursivePreferenceListener;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.parts.PreferencesInputFactory;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IMenuProvider;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.IReusablePart;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopyFactory;
import com.ibm.team.repository.rcp.ui.workingcopy.WorkingCopies;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class WorkspaceHistoryView
extends AbstractPart
implements IRefreshable,
IReusablePart,
IMenuProvider {
    private static final String WIDGET_ID = "com_ibm_team_scm_web_ui_internal_view_browse_WorkspaceHistoryView_0";
    public static final String DEBUG_PROPERTY = "com.ibm.team.filesystem.WorkspaceHistoryView.debug";
    public static final String COPY_URL_PROPERTY = "com.ibm.team.filesystem.WorkspaceHistoryView.debug.copyURL";
    private static final Set<String> EVENTS = new HashSet<String>(){
        {
            this.add("com.ibm.team.scm.ChangeHistoryEvent.Deliver");
            this.add("com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets");
            this.add("com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined");
            this.add("com.ibm.team.scm.ChangeHistoryEvent.CloseChangeSets");
            this.add("com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet");
            this.add("com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet");
            this.add("com.ibm.team.scm.HistoryRestructure");
            this.add("com.ibm.team.scm.Commit");
            this.add("bases");
            this.add("components");
            this.add("com.ibm.team.scm.ComponentHierarchyUpdate");
            this.add("com.ibm.team.scm.ConfigurationUpdate");
        }
    };
    private EmbeddedBrowser fBrowser;
    private WorkspaceHistoryViewInput input;
    private IWorkspaceConnection workspaceConnection;
    private UpdateListener updateListener;
    private IEclipsePreferences preferences = this.getPreferences();
    private RecursivePreferenceListener preferenceListener;
    private MenuExt menu;

    public WorkspaceHistoryView(HistoryPageSite viewSite, Object initialInput) {
        super((IControlSite)viewSite, initialInput);
        this.setInput(initialInput);
        Composite editorBody = viewSite.getParent();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editorBody);
        WidgetToolkit fToolkit = viewSite.getToolkit();
        Composite browserParent = fToolkit.createComposite(editorBody);
        GridLayoutFactory.fillDefaults().applyTo(browserParent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)browserParent);
        this.fBrowser = new EmbeddedBrowser(browserParent, viewSite.getOperationRunner());
        this.fBrowser.setNoUrlApology(Messages.WorkspaceHistoryView_FetchingOperationHistory);
        this.hookJavaScriptCallbacks();
        Control browserWidget = this.fBrowser.createWidget(0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(browserWidget);
        if (this.fBrowser.getBrowser() != null) {
            this.fBrowser.setRepository(this.input.getRepository());
            this.fBrowser.addLocationListener(this.createLocationListener());
            this.fBrowser.setupNetworking();
        }
        this.initializePreferencePage();
        this.update();
    }

    private void initializePreferencePage() {
        this.preferenceListener = new RecursivePreferenceListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display != null && !display.isDisposed()) {
                    SWTUtil.runOnce((Display)display, (Control)WorkspaceHistoryView.this.getControlSite().getParent(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (WorkspaceHistoryView.this.input != null && WorkspaceHistoryView.this.fBrowser.getBrowser() != null && !WorkspaceHistoryView.this.fBrowser.getBrowser().isDisposed()) {
                                WorkspaceHistoryView.this.input.setMaxResults(WorkspaceHistoryView.this.preferences.getInt("count", 100));
                                WorkspaceHistoryView.this.update();
                            }
                        }
                    });
                }
            }
        });
        try {
            this.preferenceListener.attachTo(this.preferences);
        }
        catch (BackingStoreException e1) {
            throw new RuntimeException(e1);
        }
    }

    private void openPreferences() {
        PartFactory partFactory = new PartFactory(WorkspaceHistoryPreferencesPart.class);
        IWorkingCopyFactory prefFactory = PreferencesInputFactory.getPreferencesWorkingCopy((String)"configuration", (String)this.getPreferences().absolutePath(), (String)Messages.HistoryView_historyPreferencesWorkingCopyName);
        final IWizardPage wizardPage = Parts.createWizardPage((Object)prefFactory, (IPartFactory)partFactory, (String)"prefs", null);
        final Shell shell = this.getControlSite().getShell();
        WizardUtil.open((Shell)shell, (String)Messages.HistoryView_preferencesDialogTitle, (IWizardPage)wizardPage, (IRunnableWithResult)new IRunnableWithResult<Boolean>(){

            public Boolean run() {
                HistoryPreferencesPart part = (HistoryPreferencesPart)((Object)Adapters.getAdapter((Object)wizardPage, HistoryPreferencesPart.class));
                IWorkingCopy wc = part.getWorkingCopy();
                WorkingCopies.performSave((Shell)shell, (IWorkingCopy)wc, null);
                return true;
            }
        }, (String)"com.ibm.team.filesystem.ide.ui.preference_page_history_view");
    }

    protected IEclipsePreferences getPreferences() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + HistoryView.class.getName());
        return result;
    }

    private void hookJavaScriptCallbacks() {
        HistoryPageSite pageSite = (HistoryPageSite)this.getControlSite();
        IWorkbenchPartSite partSite = pageSite.getWorkbenchPart().getSite();
        this.fBrowser.addCallback("openChanges", new OpenChangesHook(this.input.getRepository(), partSite, this.getControlSite().getOperationRunner()));
        this.fBrowser.addCallback("createWorkspace", new CreateWorkspaceHook(this.input.getRepository(), partSite, this.getControlSite().getOperationRunner()));
        this.fBrowser.addCallback("showOperationHistory", new ShowOperationHistoryHook(this.input.getRepository(), partSite, this.getControlSite().getOperationRunner()));
        this.fBrowser.addCallback("compareHistories", new CompareHook(this.input.getRepository(), partSite, this.getControlSite().getOperationRunner()));
        this.fBrowser.addCallback("addStreams", new AddStreamsHook(this.input.getRepository(), partSite, false, true));
        this.fBrowser.addCallback("replaceInWorkspace", new ReplaceInWorkspaceHook(this.input.getRepository(), partSite, this.getControlSite().getOperationRunner()));
        this.fBrowser.addCallback("selectUser", new SelectUserHook(this.input.getRepository(), partSite, this.getControlSite().getOperationRunner()));
    }

    private LocationListener createLocationListener() {
        return new LocationListener(){

            public void changing(LocationEvent event) {
                String location = event.location;
                if (location == null) {
                    return;
                }
                WorkspaceHistoryView.this.trace(NLS.bind((String)"WorkspaceHistoryView asked to change to URL {0}", (Object)location, (Object[])new Object[0]));
                if (location.contains("jsa?error=login_required") || !WorkspaceHistoryView.this.fBrowser.isOidcEnabled() && (location.contains("authenticated") || location.contains("authrequired"))) {
                    event.doit = false;
                    WorkspaceHistoryView.this.input.getRepository().logout();
                    WorkspaceHistoryView.this.fBrowser.getBrowser().setText(Messages.WorkspaceHistoryView_ProblemContactingServer);
                    WorkspaceHistoryView.this.getControlSite().getOperationRunner().enqueue(Messages.WorkspaceHistoryView_FetchingOperationHistory, new Operation(){

                        public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                            Status status = new Status(4, "com.ibm.team.filesystem.ide.ui", Messages.WorkspaceHistoryView_ProblemContactingServer);
                            throw new OperationFailedException((IStatus)status);
                        }
                    });
                    return;
                }
                if (WorkspaceHistoryView.this.fBrowser.shouldAllowLocationChange(event)) {
                    return;
                }
                if (!location.startsWith(String.valueOf(WorkspaceHistoryView.this.input.getBaseUri().toLowerCase()) + "/scm/ShowWorkspaceHistory")) {
                    event.doit = false;
                    WorkspaceHistoryView.this.trace(NLS.bind((String)"WorkspaceHistoryView opening as hyperlink {0}", (Object)location, (Object[])new Object[0]));
                    Hyperlinks.open((URI)URI.create(location), null);
                }
            }

            public void changed(LocationEvent event) {
                String location = event.location;
                if (location == null || location.length() == 0 || location.startsWith("about:")) {
                    if (WorkspaceHistoryView.this.fBrowser.getBrowser().isForwardEnabled()) {
                        WorkspaceHistoryView.this.fBrowser.getBrowser().forward();
                    }
                } else {
                    WorkspaceHistoryView.this.input.locationChanged(location);
                }
            }
        };
    }

    public IMenuExt getToolbarContributions() {
        return new MenuExt();
    }

    public IMenuExt getMenuContributions() {
        if (this.menu == null) {
            this.menu = new MenuExt();
            this.menu.add((IActionExt)new PushAction(Messages.HistoryView_preferencesAction, new Runnable(){

                @Override
                public void run() {
                    WorkspaceHistoryView.this.openPreferences();
                }
            }));
            if (Boolean.getBoolean(DEBUG_PROPERTY) || Boolean.getBoolean(COPY_URL_PROPERTY)) {
                this.menu.add((IActionExt)new PushAction(Messages.HistoryView_copyWebUrlAction, new Runnable(){

                    @Override
                    public void run() {
                        String location;
                        String string = location = WorkspaceHistoryView.this.input == null ? null : WorkspaceHistoryView.this.input.getUri();
                        if (location == null) {
                            return;
                        }
                        Clipboard clipboard = new Clipboard(WorkspaceHistoryView.this.getControlSite().getShell().getDisplay());
                        clipboard.setContents((Object[])new String[]{location}, new Transfer[]{TextTransfer.getInstance()});
                        clipboard.dispose();
                    }
                }));
            }
        }
        return this.menu;
    }

    public void setInput(Object newInput) {
        Object adaptedObject = Adapters.getAdapter((Object)newInput, WorkspaceHistoryViewInput.class);
        if (adaptedObject != null) {
            this.input = (WorkspaceHistoryViewInput)adaptedObject;
            this.getControlSite().getNameable().setContentDescription(this.getContentDescription());
            if (this.fBrowser != null) {
                this.fBrowser.setRepository(this.input.getRepository());
            }
            this.registerWorkspaceConnection();
            this.input.setMaxResults(this.preferences.getInt("count", 100));
            this.update();
        }
    }

    private String getContentDescription() {
        String contextName = this.getContextName(this.input.getWorkspace(), this.input.getComponent());
        if (this.input.getRepository() != null && TeamPlatform.getTeamRepositoryService().getTeamRepositories().length > 1) {
            return NLS.bind((String)Messages.VersionableHistoryInput_1, (Object)contextName, (Object[])new Object[]{RepositoryUtils.getLabel(this.input.getRepository())});
        }
        return contextName;
    }

    private String getContextName(IWorkspace workspace, IComponent component) {
        String componentName;
        String string = componentName = component != null ? component.getName() : null;
        if (componentName != null) {
            if (workspace.isStream()) {
                return NLS.bind((String)Messages.WorkspaceHistoryView_streamComponentName, (Object)workspace.getName(), (Object[])new Object[]{component.getName()});
            }
            return NLS.bind((String)Messages.WorkspaceHistoryView_workspaceComponentName, (Object)workspace.getName(), (Object[])new Object[]{component.getName()});
        }
        if (workspace.isStream()) {
            return NLS.bind((String)Messages.WorkspaceHistoryView_streamName, (Object)workspace.getName(), (Object[])new Object[0]);
        }
        return NLS.bind((String)Messages.WorkspaceHistoryView_workspaceName, (Object)workspace.getName(), (Object[])new Object[0]);
    }

    private synchronized void setWorkspaceConnection(IWorkspaceConnection connection) {
        if (this.workspaceConnection != null) {
            if (connection != null && connection.equals((Object)this.workspaceConnection)) {
                return;
            }
            this.workspaceConnection.purgeGenericListener((IListener)this.updateListener);
            this.updateListener = null;
        }
        this.workspaceConnection = connection;
        if (this.workspaceConnection != null) {
            this.updateListener = new UpdateListener();
            for (String category : EVENTS) {
                this.workspaceConnection.addGenericListener((Object)category, (IListener)this.updateListener);
            }
        }
    }

    private void registerWorkspaceConnection() {
        IWorkspaceConnection connection = WorkspaceUtil.getKnownConnection(this.input.getRepository(), (IWorkspaceHandle)this.input.getWorkspace());
        if (connection != null) {
            this.setWorkspaceConnection(connection);
        } else {
            this.getControlSite().getOperationRunner().enqueue(Messages.WorkspaceHistoryView_WorkspaceConnectionJob, new Operation(){

                public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                    try {
                        IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)WorkspaceHistoryView.this.input.getRepository()).getWorkspaceConnection((IWorkspaceHandle)WorkspaceHistoryView.this.input.getWorkspace(), monitor);
                        WorkspaceHistoryView.this.setWorkspaceConnection(connection);
                    }
                    catch (TeamRepositoryException e) {
                        problems.reportException((Throwable)e);
                        return;
                    }
                }
            });
        }
    }

    private void update() {
        if (this.fBrowser != null && this.input != null) {
            this.fBrowser.setUrl(this.input.getUri(), Messages.WorkspaceHistoryView_FetchingOperationHistory);
        }
        if (this.updateListener != null) {
            this.updateListener.requestUpdate();
        }
    }

    public void refresh() {
        if (this.fBrowser != null) {
            this.fBrowser.refresh(this.input.getUri(), Messages.WorkspaceHistoryView_Refresh);
        }
    }

    public boolean canRefresh() {
        return true;
    }

    public void dispose() {
        this.setWorkspaceConnection(null);
        if (this.fBrowser != null) {
            this.fBrowser.dispose();
        }
        if (this.preferenceListener != null && this.preferences != null) {
            try {
                this.preferenceListener.detachFrom(this.preferences);
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        super.dispose();
    }

    private Log getLog() {
        return LoggingHelper.getLog(((Object)((Object)this)).getClass());
    }

    private void trace(String text) {
        Log log = this.getLog();
        if (log != null) {
            log.trace((Object)text);
        }
    }

    private class UpdateListener
    implements Runnable,
    IListener {
        private boolean pendingUpdate = false;

        private UpdateListener() {
        }

        public synchronized void requestUpdate() {
            if (!this.pendingUpdate) {
                this.pendingUpdate = true;
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display != null && !display.isDisposed()) {
                    display.asyncExec((Runnable)this);
                }
            }
        }

        public synchronized void handleEvents(List events) {
            this.requestUpdate();
        }

        @Override
        public synchronized void run() {
            if (WorkspaceHistoryView.this.fBrowser != null && WorkspaceHistoryView.this.fBrowser.getBrowser() != null) {
                StringBuilder script = new StringBuilder();
                script.append("var view = require('dojo/main').dijit.byId('com_ibm_team_scm_web_ui_internal_view_browse_WorkspaceHistoryView_0');");
                script.append("if (view != null) { view.update(); }");
                WorkspaceHistoryView.this.fBrowser.getBrowser().execute(script.toString());
            }
            this.pendingUpdate = false;
        }
    }
}

