/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeNode;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.scm.common.changenodes.IChangeNode;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class StateMergesColumn
extends LabelColumn<ChangeNode> {
    private LocalResourceManager resourceManager;

    public StateMergesColumn(SimpleTableViewer<ChangeNode> parent, String name, String tooltipText, int size) {
        super(parent, name, tooltipText, size);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent.getTable().getParent());
        this.setLabelProvider((IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                label.setImage(null);
                label.setText("");
            }
        });
        this.setPaintListener(new StateMergesPaintListener());
    }

    private class StateMergesPaintListener
    implements Listener {
        private static final int NODE_SIZE = 7;
        private static final int DEFAULT_SEPARATION = 8;
        private Color[] allocatedColors = null;
        private boolean antiAliasPermitted = true;

        StateMergesPaintListener() {
        }

        public void handleEvent(Event event) {
            GC gc = event.gc;
            Widget item = event.item;
            if (item.getData() instanceof ChangeNode) {
                TableItem ti = (TableItem)item;
                IChangeNode node = (IChangeNode)item.getData();
                Table table = ti.getParent();
                TableColumn tc = table.getColumn(event.index);
                Rectangle rect = new Rectangle(event.x, event.y, tc.getWidth(), event.height);
                int xStart = rect.x + 8;
                Color oldBackground = gc.getBackground();
                if (this.allocatedColors == null) {
                    RGB[] contrastingColors = SWTUtil.chooseContrastingColors((RGB)table.getBackground().getRGB(), (int)2);
                    this.allocatedColors = new Color[2];
                    int i = 0;
                    while (i < contrastingColors.length) {
                        this.allocatedColors[i] = StateMergesColumn.this.resourceManager.createColor(contrastingColors[i]);
                        ++i;
                    }
                }
                Color currentColor = this.allocatedColors[0];
                int tableItemTopHidden = ti.getBounds().y < 0 ? ti.getBounds().y : 0;
                gc.setClipping(rect.x, rect.y - tableItemTopHidden, rect.width, rect.height);
                if (this.antiAliasPermitted) {
                    try {
                        gc.setAntialias(1);
                    }
                    catch (SWTException e) {
                        if (e.code == 16) {
                            this.antiAliasPermitted = false;
                        }
                        throw e;
                    }
                }
                gc.setLineWidth(2);
                gc.setLineStyle(1);
                gc.setForeground(currentColor);
                gc.setBackground(currentColor);
                int yMid = rect.y + rect.height / 2;
                int yEnd = rect.y + rect.height;
                if (node.getType() == IChangeNode.NodeType.MERGE) {
                    gc.setForeground(this.allocatedColors[1]);
                    gc.drawLine(xStart + 8, yMid, xStart + 8, rect.y);
                    gc.setForeground(currentColor);
                    gc.drawLine(xStart, yEnd, xStart, rect.y);
                }
                if (node.getPredecessors().size() > 0) {
                    for (IChangeNode pred : node.getPredecessors()) {
                        if (pred.getType() != IChangeNode.NodeType.MERGE) continue;
                        gc.setForeground(this.allocatedColors[1]);
                        gc.drawLine(xStart, yMid, xStart + 8, yEnd);
                        gc.setForeground(currentColor);
                    }
                    gc.drawLine(xStart, yMid, xStart, yEnd);
                }
                if (!node.getSuccessors().isEmpty()) {
                    gc.drawLine(xStart, yMid, xStart, rect.y);
                }
                if (node.getType() == IChangeNode.NodeType.DELETE) {
                    gc.drawLine(xStart - 4, yMid, xStart + 4, yMid);
                }
                if (node.getType() != IChangeNode.NodeType.DELETE) {
                    int separation = 0;
                    if (node.getType() == IChangeNode.NodeType.MERGE) {
                        separation = 8;
                        gc.setBackground(this.allocatedColors[1]);
                    }
                    gc.fillRectangle(xStart - 3 + separation, yMid - 3, 7, 7);
                }
                gc.setBackground(oldBackground);
            }
        }
    }
}

