/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.WorkspaceHistoryViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ShowWorkspaceHistoryAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        boolean shouldEnable = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            ISubcomponentChange node;
            Object o = ss.getFirstElement();
            if (o instanceof AbstractPlaceWrapper || o instanceof WorkspaceComponentWrapper || o instanceof IComponentSyncContext || o instanceof IWorkspaceSyncContext || o instanceof ISubcomponentChange) {
                shouldEnable = true;
            }
            if (o instanceof ISubcomponentChange && ((node = (ISubcomponentChange)o).isComponentInaccessible() || node.isComponentMissingFromWorkspace())) {
                shouldEnable = false;
            }
        }
        action.setEnabled(shouldEnable);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        AbstractWrapper wrapper;
        ITeamRepository repo = null;
        IWorkspace workspace = null;
        IComponent component = null;
        if (selection.size() != 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (o instanceof AbstractPlaceWrapper) {
            wrapper = (AbstractPlaceWrapper)((Object)o);
            repo = ((ContextWrapper)wrapper).getRepository();
            workspace = ((AbstractPlaceWrapper)wrapper).getWorkspace();
        } else if (o instanceof WorkspaceComponentWrapper) {
            wrapper = (WorkspaceComponentWrapper)o;
            repo = ((WorkspaceComponentWrapper)wrapper).getRepository();
            workspace = ((WorkspaceComponentWrapper)wrapper).getWorkspace();
            component = ((WorkspaceComponentWrapper)wrapper).getComponent();
        } else if (o instanceof IComponentSyncContext) {
            wrapper = (IComponentSyncContext)o;
            repo = wrapper.localTeamRepository();
            workspace = wrapper.getWorkspaceSyncContext().getLocal().getResolvedWorkspace();
            component = wrapper.getComponent();
        } else if (o instanceof ISubcomponentChange) {
            ISubcomponentChange changeNode = (ISubcomponentChange)o;
            repo = (ITeamRepository)changeNode.getComponentHandle().getOrigin();
            IWorkspaceConnection wc = changeNode.getContainingWorkspaceConnection();
            if (wc != null) {
                workspace = wc.getResolvedWorkspace();
            }
            component = changeNode.getComponent();
        } else if (o instanceof IWorkspaceSyncContext) {
            wrapper = (IWorkspaceSyncContext)o;
            repo = wrapper.teamRepository();
            workspace = wrapper.getLocal().getResolvedWorkspace();
        } else {
            return;
        }
        if (repo != null && workspace != null) {
            WorkspaceHistoryViewInput input = new WorkspaceHistoryViewInput(repo, workspace, component);
            HistoryViewUtil.showHistory(UIContext.createPageContext((Shell)shell, (IWorkbenchPage)page), input);
        }
    }
}

