/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.filesystem.ui.queries.WorkspaceFlowTargetQuery;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeSetFlowReport;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SearchInFlowsResultsDialog
extends TrayDialog {
    public static final int SHOW_HISTORY_ID = 100;
    public static final int SEARCH_AGAIN_ID = 101;
    private final IWorkspaceConnection workspace;
    private final Collection<IChangeSetFlowReport> searchResults;
    private Button showHistoryButton;

    protected SearchInFlowsResultsDialog(IShellProvider parentShell, IWorkspaceConnection workspace, IChangeSet changeSet, Collection<IChangeSetFlowReport> searchResults) {
        super(parentShell);
        this.workspace = workspace;
        this.searchResults = searchResults;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (!this.hasSearchResults()) {
            Label icon = new Label(composite, 0);
            icon.setImage(parent.getDisplay().getSystemImage(2));
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)icon);
            Label label = new Label(composite, 64);
            label.setText(Messages.SearchInFlowsResultsDialog_changeSetNotFoundLabel);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)label);
            GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).numColumns(2).generateLayout(composite);
        } else {
            Label label = new Label(composite, 64);
            label.setText(Messages.SearchInFlowsResultsDialog_changeSetFoundLabel);
            Table flowTable = new Table(composite, 68352);
            flowTable.setHeaderVisible(false);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            final SimpleTableViewer viewer = new SimpleTableViewer(flowTable, null, null);
            new LabelColumn(viewer, Messages.SearchInFlowsResultsDialog_workspacesColumn, -1);
            JobRunner runner = new JobRunner(true);
            viewer.setInput((ISetWithListeners)new WorkspaceFlowTargetQuery(this.workspace.teamRepository(), (IWorkspaceHandle)this.workspace.getResolvedWorkspace(), this.getWorkspaces(), (IOperationRunner)runner));
            viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AbstractPlaceWrapper selection = (AbstractPlaceWrapper)((Object)viewer.getSelection().getFirstElement());
                    SearchInFlowsResultsDialog.this.showHistoryButton.setEnabled(selection != null);
                }
            });
            GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
        }
        return composite;
    }

    private Collection<IWorkspaceHandle> getWorkspaces() {
        Iterator<IChangeSetFlowReport> iterator = this.searchResults.iterator();
        if (iterator.hasNext()) {
            IChangeSetFlowReport report = iterator.next();
            return report.getWorkspaces();
        }
        return null;
    }

    private boolean hasSearchResults() {
        for (IChangeSetFlowReport report : this.searchResults) {
            if (report.getWorkspaces() == null || report.getWorkspaces().size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 101, Messages.SearchInFlowsResultsDialog_searchAgainButton, false);
        if (this.hasSearchResults()) {
            this.showHistoryButton = this.createButton(parent, 100, Messages.SearchInFlowsResultsDialog_showHistoryButton, false);
            this.showHistoryButton.setToolTipText(Messages.SearchInFlowsResultsDialog_showHistoryButtonTooltip);
            this.showHistoryButton.setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.hasSearchResults() ? Messages.SearchInFlowsResultsDialog_found : Messages.SearchInFlowsResultsDialog_notFound);
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }
}

