/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemReviewEntry;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MergeInfo {
    private static final int[] emptyIntArray = new int[0];
    private static final UUID EMPTY_COLUMN = UUID.generate();
    private int[] merges;
    private int[] branches;
    private int currentBranch;
    private boolean conflictPoint;
    private int unchangedMerge;
    private MergeInfo next;

    private MergeInfo(MergeInfo next, int currentBranch, int[] merges, int[] branches, int unchangedMerge) {
        this.currentBranch = currentBranch;
        this.merges = merges;
        this.branches = branches;
        this.next = next;
        this.unchangedMerge = unchangedMerge;
    }

    public int getUnchangedMerge() {
        return this.unchangedMerge;
    }

    public MergeInfo getNextInHistory() {
        return this.next;
    }

    public int[] getMerges() {
        return this.merges;
    }

    public int[] getBranches() {
        return this.branches;
    }

    public int getCurrentBranch() {
        return this.currentBranch;
    }

    public static MergeInfo computeFirstRow(List<UUID> outputStates, Object change) {
        if (change == null) {
            return new MergeInfo(null, 0, emptyIntArray, new int[1], -1);
        }
        UUID afterState = MergeInfo.getAfterState(change);
        List<UUID> beforeStates = MergeInfo.getBeforeStates(change);
        outputStates.clear();
        outputStates.addAll(beforeStates);
        int[] merges = new int[beforeStates.size()];
        int sameState = -1;
        int idx = 0;
        for (UUID beforeState : beforeStates) {
            merges[idx] = idx;
            if (beforeState.equals((Object)afterState)) {
                sameState = idx;
            }
            ++idx;
        }
        return new MergeInfo(null, 0, merges, emptyIntArray, sameState);
    }

    /*
     * WARNING - void declaration
     */
    public MergeInfo computePredecessorRow(List<UUID> beforeStatesList, List<UUID> afterStatesList, Object change, boolean isLast) {
        void var19_31;
        if (change == null) {
            ArrayList<Integer> unaffectedList = new ArrayList<Integer>();
            int idx = 0;
            for (UUID next : afterStatesList) {
                if (!next.equals((Object)EMPTY_COLUMN)) {
                    unaffectedList.add(idx);
                }
                ++idx;
            }
            return new MergeInfo(this, -1, emptyIntArray, MergeInfo.toIntArray(unaffectedList), -1);
        }
        HashMap<UUID, Integer> initialIndices = new HashMap<UUID, Integer>();
        LinkedList<Integer> freeIndices = new LinkedList<Integer>();
        int idx = 0;
        for (UUID nextId : afterStatesList) {
            if (nextId.equals((Object)EMPTY_COLUMN)) {
                freeIndices.add(idx);
            } else {
                initialIndices.put(nextId, idx);
            }
            ++idx;
        }
        UUID nullItem = ItemId.getNullItemUUID();
        List<UUID> changeBeforeStates = MergeInfo.getBeforeStates(change);
        if (isLast) {
            while (changeBeforeStates.remove(nullItem)) {
            }
        }
        UUID changeAfterState = MergeInfo.getAfterState(change);
        HashSet<UUID> unsortedBeforeUuids = new HashSet<UUID>();
        unsortedBeforeUuids.addAll(afterStatesList);
        unsortedBeforeUuids.remove(changeAfterState);
        unsortedBeforeUuids.addAll(changeBeforeStates);
        unsortedBeforeUuids.remove(EMPTY_COLUMN);
        if (isLast) {
            unsortedBeforeUuids.remove(nullItem);
        }
        int currentIndex = -1;
        int beforeSize = afterStatesList.size();
        if (initialIndices.containsKey(changeAfterState)) {
            currentIndex = (Integer)initialIndices.get(changeAfterState);
        } else {
            currentIndex = freeIndices.isEmpty() ? beforeSize++ : (Integer)freeIndices.removeFirst();
            initialIndices.put(changeAfterState, currentIndex);
        }
        int sameAfterState = -1;
        if (unsortedBeforeUuids.contains(changeAfterState)) {
            sameAfterState = currentIndex;
        } else {
            freeIndices.addFirst(currentIndex);
        }
        HashMap<UUID, Object> beforeIndices = new HashMap<UUID, Object>();
        for (UUID nextBeforeState : unsortedBeforeUuids) {
            Object index = (Integer)initialIndices.get(nextBeforeState);
            if (index == null) {
                if (freeIndices.isEmpty()) {
                    index = beforeSize;
                    ++beforeSize;
                } else {
                    index = (Integer)freeIndices.removeFirst();
                }
            }
            beforeIndices.put(nextBeforeState, index);
        }
        ArrayList<Integer> mergeIndices = new ArrayList<Integer>();
        for (UUID nextMerge : changeBeforeStates) {
            mergeIndices.add((Integer)beforeIndices.get(nextMerge));
        }
        int[] branches = new int[beforeSize];
        int i = 0;
        while (i < branches.length) {
            branches[i] = -1;
            ++i;
        }
        idx = 0;
        for (UUID nextId : afterStatesList) {
            int ni;
            Integer nextIdx = (Integer)beforeIndices.get(nextId);
            if (nextIdx != null && (ni = nextIdx.intValue()) != -1) {
                branches[ni] = idx;
            }
            ++idx;
        }
        UUID[] newBeforeStatesArray = new UUID[beforeSize];
        idx = 0;
        while (idx < newBeforeStatesArray.length) {
            newBeforeStatesArray[idx] = EMPTY_COLUMN;
            ++idx;
        }
        for (Map.Entry entry : beforeIndices.entrySet()) {
            idx = (Integer)entry.getValue();
            if (idx == -1) continue;
            newBeforeStatesArray[idx] = (UUID)entry.getKey();
        }
        beforeStatesList.clear();
        boolean bl = false;
        while (var19_31 < newBeforeStatesArray.length) {
            UUID next = newBeforeStatesArray[var19_31];
            beforeStatesList.add(next);
            ++var19_31;
        }
        MergeInfo mergeInfo = new MergeInfo(this, currentIndex, MergeInfo.toIntArray(mergeIndices), branches, sameAfterState);
        return mergeInfo;
    }

    private static UUID getAfterState(Object change) {
        if (change instanceof CombinedChangeSetsItemReviewEntry) {
            return MergeInfo.getAfterState((CombinedChangeSetsItemReviewEntry)change);
        }
        return MergeInfo.getAfterState((IChange)change);
    }

    private static List<UUID> getBeforeStates(Object change) {
        if (change instanceof CombinedChangeSetsItemReviewEntry) {
            return MergeInfo.getBeforeStates((CombinedChangeSetsItemReviewEntry)change);
        }
        return MergeInfo.getBeforeStates((IChange)change);
    }

    private static UUID getAfterState(CombinedChangeSetsItemReviewEntry change) {
        UUID afterState = change.getAfter();
        return afterState == null ? ItemId.getNullItemUUID() : afterState;
    }

    private static List<UUID> getBeforeStates(CombinedChangeSetsItemReviewEntry change) {
        ArrayList<UUID> changeBeforeStates = new ArrayList<UUID>();
        IVersionableHandle[] iVersionableHandleArray = change.getMerges();
        int n = iVersionableHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            UUID stateId;
            IVersionableHandle mergeState = iVersionableHandleArray[n2];
            if (mergeState != null && (stateId = mergeState.getStateId()) != null) {
                changeBeforeStates.add(stateId);
            }
            ++n2;
        }
        UUID before = change.getBefore();
        if (before != null) {
            changeBeforeStates.add(before);
        }
        return changeBeforeStates;
    }

    private static UUID getAfterState(IChange change) {
        UUID changeAfterState = change.afterState() == null ? ItemId.getNullItemUUID() : change.afterState().getStateId();
        return changeAfterState;
    }

    private static List<UUID> getBeforeStates(IChange change) {
        ArrayList<UUID> changeBeforeStates = new ArrayList<UUID>();
        boolean includedNull = change.beforeState() == null;
        for (IVersionableHandle mergeState : change.mergeStates()) {
            if (mergeState == null) {
                if (includedNull) continue;
                changeBeforeStates.add(ItemId.getNullItemUUID());
                includedNull = true;
                continue;
            }
            changeBeforeStates.add(mergeState.getStateId());
        }
        if (change.beforeState() == null) {
            changeBeforeStates.add(ItemId.getNullItemUUID());
        } else {
            changeBeforeStates.add(change.beforeState().getStateId());
        }
        return changeBeforeStates;
    }

    private static int[] toIntArray(List<Integer> unaffectedList) {
        int[] result = new int[unaffectedList.size()];
        int idx = 0;
        for (Integer next : unaffectedList) {
            result[idx++] = next;
        }
        return result;
    }

    public boolean isConflictPoint() {
        return this.conflictPoint;
    }

    public void setConflictPoint(boolean isConflictPoint) {
        this.conflictPoint = isConflictPoint;
    }
}

