/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.queries.IQuery;
import com.ibm.team.filesystem.client.internal.queries.QueryCache;
import com.ibm.team.filesystem.client.internal.queries.QueryPool;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenShareableInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateRemoteFunction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.filesystem.ui.inputs.RepositoryFilesViewInput;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.ChangeSetSelectionTester;
import com.ibm.team.internal.filesystem.ui.picker.LocationPicker;
import com.ibm.team.internal.filesystem.ui.util.WarnOpenInExternalCompare;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryView;
import com.ibm.team.internal.filesystem.ui.views.history.SearchInFlowsResultsDialog;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractConfigurationHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractFolderHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractVersionableHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.BaselinesInWorkspaceHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.WorkspaceConfigurationHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.WorkspaceHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.OperationManager;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.changenodes.IChangeNode;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class HistoryViewUtil {
    public static FileItemWrapper getFileItemWrapper(IShareable shareable, IProgressMonitor monitor) throws TeamRepositoryException {
        AbstractFileSystemItemWrapper itemWrapper = HistoryViewUtil.getItemWrapper(shareable, monitor);
        if (itemWrapper instanceof FileItemWrapper) {
            return (FileItemWrapper)itemWrapper;
        }
        return null;
    }

    public static AbstractFileSystemItemWrapper getItemWrapper(IShareable shareable, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionableHandle versionable = shareable.getRemote((IProgressMonitor)progress.newChild(50));
        if (versionable == null) {
            return null;
        }
        ISharingDescriptor descr = shareable.getShare((IProgressMonitor)progress.newChild(50)).getSharingDescriptor();
        try {
            repository = RepositoryUtils.getTeamRepository((ISharingDescriptor)descr);
        }
        catch (TeamRepositoryException e) {
            return null;
        }
        StateId state = new StateId((IItemHandle)versionable);
        if (versionable instanceof IFolderHandle) {
            return new FolderItemWrapper(state, shareable.getFullPath().toOSString(), CoreShareablesUtil.getNamespace((ITeamRepository)repository, (IContextHandle)descr.getConnectionHandle(), (IComponentHandle)descr.getComponent()));
        }
        return new FileItemWrapper(state, shareable.getFullPath().toOSString(), CoreShareablesUtil.getNamespace((ITeamRepository)repository, (IContextHandle)descr.getConnectionHandle(), (IComponentHandle)descr.getComponent()));
    }

    public static AbstractHistoryViewInput getInputFor(IShareable shareable) {
        if (shareable == null) {
            return null;
        }
        try {
            AbstractFileSystemItemWrapper itemWrapper = HistoryViewUtil.getItemWrapper(shareable, (IProgressMonitor)TempHelper.MONITOR);
            if (itemWrapper instanceof FileItemWrapper) {
                FileItemWrapper fileWrapper = (FileItemWrapper)itemWrapper;
                return AbstractVersionableHistoryViewInput.newVersionableHistoryViewInput(fileWrapper);
            }
            if (itemWrapper instanceof FolderItemWrapper) {
                FolderItemWrapper folderWrapper = (FolderItemWrapper)itemWrapper;
                return AbstractFolderHistoryViewInput.createHistoryViewInputFor(folderWrapper);
            }
            return null;
        }
        catch (TeamRepositoryException e) {
            throw TempHelper.throwEx((TeamRepositoryException)e);
        }
    }

    public static void showFileSystem(IWorkbenchPage page, IItemContext context) {
        Parts.openView((IWorkbenchPage)page, (Object)new RepositoryFilesViewInput(context.getNamespace()), (String)"com.ibm.team.filesystem.history.FileSystemView");
    }

    public static void showFileSystem(IWorkbenchPage page, WorkspaceComponentWrapper component) {
        Parts.openView((IWorkbenchPage)page, (Object)new RepositoryFilesViewInput((ItemNamespace)component.getNamespace()), (String)"com.ibm.team.filesystem.history.FileSystemView");
    }

    private static Runnable getOpenHistoryViewRunnable(final Object viewInput, final IFilter selectionFilter) {
        return new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.isWorkbenchRunning()) {
                    HistoryView theView;
                    IHistoryPage page = TeamUI.getHistoryView().showHistoryFor(viewInput);
                    if (selectionFilter != null && (theView = (HistoryView)((Object)Adapters.getAdapter((Object)page, HistoryView.class))) != null) {
                        theView.setSelection(selectionFilter);
                    }
                }
            }
        };
    }

    public static void showHistory(UIContext context, AbstractHistoryViewInput timeline) {
        com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.loggedInDo(context, timeline.getRepository(), HistoryViewUtil.getOpenHistoryViewRunnable(timeline, timeline.getSelectionTester()));
    }

    public static void showHistory(UIContext context, WorkspaceHistoryViewInput input) {
        com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.loggedInDo(context, input.getRepository(), HistoryViewUtil.getOpenHistoryViewRunnable(input, null));
    }

    public static String computeComment(ITeamRepository repo, IChangeSet toDescribe, IProgressMonitor progress) throws TeamRepositoryException {
        return toDescribe.getComment();
    }

    public static String computeDescription(ITeamRepository repo, StateId state, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IQuery originChangeSets = QueryPool.getChangeSetsContainingAfterState((ITeamRepository)repo, (StateId)state);
        List changeSets = QueryCache.execute((IQuery)originChangeSets, (IProgressMonitor)mon.newChild(1));
        IChangeSet oldest = null;
        for (IChangeSet next : changeSets) {
            Date oldestDate = oldest == null ? null : oldest.getLastChangeDate();
            Date nextDate = next.getLastChangeDate();
            if (oldest != null && oldestDate != null && (nextDate == null || oldestDate.compareTo(nextDate) <= 0)) continue;
            oldest = next;
        }
        if (oldest == null) {
            return Messages.HistoryViewUtil_initialStateLabel;
        }
        return HistoryViewUtil.computeComment(repo, oldest, (IProgressMonitor)mon.newChild(1));
    }

    public static Object getSelected(Class type, ITreeSelection sel) {
        Collection coll = HistoryViewUtil.findSelected(type, sel);
        if (coll.size() != 1) {
            return null;
        }
        return coll.iterator().next();
    }

    public static Collection findSelected(Class type, ITreeSelection sel) {
        HashSet<Object> found = new HashSet<Object>();
        TreePath[] paths = sel.getPaths();
        int i = 0;
        while (i < paths.length) {
            TreePath next = paths[i];
            int seg = next.getSegmentCount() - 1;
            while (seg >= 0) {
                Object element = next.getSegment(seg);
                Object selected = Adapters.getAdapter((Object)element, (Class)type);
                if (selected != null) {
                    found.add(selected);
                }
                --seg;
            }
            ++i;
        }
        return found;
    }

    public static void compareWithChangeSetPredecessor(final UIContext context, final IAdaptable adaptable) {
        final Display d = Display.getCurrent();
        OperationManager.runOperation((String)Messages.HistoryViewUtil_locatingStreamJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.HistoryViewUtil_locatingWorkspaceJobName, (int)100);
                final IShareable shareable = (IShareable)adaptable.getAdapter(IShareable.class);
                try {
                    IVersionableHandle versionable = shareable != null ? shareable.getRemote((IProgressMonitor)progress.newChild(5)) : null;
                    if (versionable == null) {
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell s = context.getShell();
                                if (s.isDisposed()) {
                                    s = d.getActiveShell();
                                }
                                MessageDialogFactory.showMessage((Shell)s, (IStatus)StatusUtil.newStatus(HistoryViewUtil.class, (String)NLS.bind((String)Messages.HistoryViewUtil_notSharedErrorMessage, (Object)shareable.getFullPath().toOSString())));
                            }
                        });
                        return;
                    }
                    ISharingDescriptor descr = shareable.getShare((IProgressMonitor)progress.newChild(5)).getSharingDescriptor();
                    final ITeamRepository repository = RepositoryUtils.getTeamRepository((ISharingDescriptor)descr);
                    ItemNamespace namespace = CoreShareablesUtil.getContributorPlace((IShareable)shareable, (IProgressMonitor)progress.newChild(10));
                    if (namespace == null) {
                        return;
                    }
                    IConnection nextConnection = namespace.getConnection((IProgressMonitor)progress.newChild(10));
                    ItemId component = namespace.fetchComponentId((IProgressMonitor)progress.newChild(10));
                    ItemId targetItem = new ItemId((IItemHandle)versionable);
                    if (nextConnection instanceof IWorkspaceConnection) {
                        IWorkspaceConnection wc = (IWorkspaceConnection)nextConnection;
                        List activeChanges = ConnectionUtil.getActiveChangeSets((IWorkspaceConnection)wc, (ItemId)component);
                        Collection activeChangeSets = RepoFetcher.fetchCurrents((ITeamRepository)wc.teamRepository(), (Collection)activeChanges, (IProgressMonitor)progress.newChild(10)).values();
                        StateId beforeState = new StateId((IItemHandle)versionable);
                        for (IChangeSet next : activeChangeSets) {
                            IChange chg = ChangeSetUtil.getChangeFor((IChangeSet)next, (ItemId)targetItem);
                            if (chg == null) continue;
                            beforeState = ChangeSetUtil.getLastMergeState((IChange)chg);
                        }
                        final StateId finalBeforeState = beforeState;
                        boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(shareable);
                        if (useExternalCompareTool) {
                            final OpenInExternalCompareAction.ExternalCommandLinePreference externalCommandLinePreference = OpenInExternalCompareAction.get2WayLocalCompareCommandLine();
                            String commandLine = externalCommandLinePreference.getCommandLine();
                            if (commandLine == null) {
                                final Shell shell = context.getShell();
                                SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!shell.isDisposed()) {
                                            externalCommandLinePreference.openPreferenceDialog(shell, null);
                                        }
                                    }
                                });
                                return;
                            }
                            FileItemWrapper wrapper = new FileItemWrapper(finalBeforeState, shareable.getFullPath().toOSString(), namespace);
                            FileStateRemoteFunction remoteStateComputer = new FileStateRemoteFunction(repository, wrapper.getFileItem());
                            FileState remoteFileState = (FileState)remoteStateComputer.compute((IProgressMonitor)progress.newChild(10));
                            OpenShareableInExternalCompareOperation externalCompareOperation = new OpenShareableInExternalCompareOperation(commandLine, shareable, remoteFileState, (OpenInExternalCompareDilemmaHandler)new WarnOpenInExternalCompare(context));
                            externalCompareOperation.run(monitor);
                        } else {
                            d.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    OpenInCompareAction.openCompareEditor(DelegatingSaveableCompareEditorInput.createInput(context.getPage(), shareable, (IRemoteFunction<FileState>)new FileStateRemoteFunction(repository, finalBeforeState), false), context.getPage());
                                }
                            });
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    problems.reportProblem(FileSystemStatusUtil.getStatusFor((Throwable)e));
                    return;
                }
            }
        }, (boolean)true);
    }

    public static void findChangeSet(final UIContext context, final ItemLocator<IChangeSet> changeSetHandle, final ItemNamespace defaultWorkspace) {
        context.getUserOperationRunner().enqueue(Messages.HistoryViewUtil_fetchingComponentJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                IWorkspaceConnection connection;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (defaultWorkspace instanceof WorkspaceNamespace) {
                    WorkspaceNamespace wn = (WorkspaceNamespace)defaultWorkspace;
                    connection = wn.getWorkspaceConnection((IProgressMonitor)progress.newChild(10));
                } else {
                    connection = null;
                }
                try {
                    final IChangeSet changeSet = (IChangeSet)ItemFetcher.fetchCurrent((ItemLocator)changeSetHandle, (IProgressMonitor)progress.newChild(30));
                    ITeamRepository repo = changeSetHandle.getRepository();
                    ItemId componentId = ChangeSetUtil.getComponent((IChangeSet)changeSet);
                    LocationPicker.pickLocation(context, Messages.HistoryViewUtil_locatingChangeSetTitle, Messages.HistoryViewUtil_locatingChangeSetText, defaultWorkspace, (ItemLocator<IComponent>)ItemLocator.create((ITeamRepository)repo, (ItemId)componentId), connection != null, new IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult>(){

                        public void setResult(ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult result) {
                            if (result == null) {
                                HistoryViewUtil.locateChangeSetInFlows(context, connection, changeSet);
                            } else {
                                HistoryViewUtil.locateChangeSet(context, result.getItemNamespace(), (ItemId<IChangeSet>)changeSetHandle.getItemId());
                            }
                        }
                    }, (IProgressMonitor)progress);
                }
                catch (ItemNotFoundException e) {
                    throw new ItemNotFoundException(Messages.AbstractDeliveryHyperlinkHandler_ERROR_CHANGESET_NOTACCESSIBLE, (Throwable)e);
                }
            }
        });
    }

    private static void locateChangeSetInFlows(final UIContext context, final IWorkspaceConnection connection, final IChangeSet changeSet) {
        context.getUserOperationRunner().enqueue(Messages.HistoryViewUtil_openingHistoryViewJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                final Collection report = connection.findChangeSetsInFlows(Collections.singletonList(changeSet), 3, (IProgressMonitor)progress.newChild(50));
                context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchInFlowsResultsDialog d = new SearchInFlowsResultsDialog((IShellProvider)context, connection, changeSet, report);
                        int result = d.open();
                        if (result == 101) {
                            HistoryViewUtil.findChangeSet(context, (ItemLocator<IChangeSet>)ItemLocator.create((ITeamRepository)connection.teamRepository(), (IAuditableHandle)changeSet), ItemNamespace.getNamespace((IConnection)connection, (IComponentHandle)changeSet.getComponent()));
                        } else if (result == 100) {
                            WorkspaceConfigurationHistoryViewInput input = new WorkspaceConfigurationHistoryViewInput(WorkspaceNamespace.create((IWorkspaceConnection)connection, (IComponentHandle)changeSet.getComponent()), (IFilter)new ChangeSetSelectionTester((ItemId<IChangeSet>)ItemId.forItem((IItem)changeSet)));
                            HistoryViewUtil.showHistory(context, input);
                        }
                    }
                });
            }
        });
    }

    private static void locateChangeSet(final UIContext context, final ItemNamespace toSearch, final ItemId<IChangeSet> changeSet) {
        context.getUserOperationRunner().enqueue(Messages.HistoryViewUtil_openingHistoryViewJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                final IItemContext itemContext = toSearch.getContext((IProgressMonitor)progress.newChild(50));
                Collection changeSetsInHistory = itemContext.changeSetsInHistory(Collections.singleton(changeSet), (IProgressMonitor)progress.newChild(50));
                final boolean hasChangeSets = !changeSetsInHistory.isEmpty();
                final AbstractConfigurationHistoryViewInput input = hasChangeSets ? AbstractConfigurationHistoryViewInput.newConfigurationHistoryViewInput(toSearch, (ItemId<IChangeSet>)changeSet) : null;
                context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (hasChangeSets) {
                            if (MessageDialog.openQuestion((Shell)context.getShell(), (String)Messages.HistoryViewUtil_foundTitle, (String)NLS.bind((String)Messages.HistoryViewUtil_foundText, (Object)itemContext.getName()))) {
                                HistoryViewUtil.showHistory(context, input);
                            }
                        } else {
                            MessageDialog.openInformation((Shell)context.getShell(), (String)Messages.HistoryViewUtil_notFoundTitle, (String)NLS.bind((String)Messages.HistoryViewUtil_targetDoesNotContainChangeSetMessage, (Object)itemContext.getName()));
                        }
                    }
                });
            }
        });
    }

    public static void showBaselinesInWorkspace(UIContext context, WorkspaceComponentWrapper wrapper) {
        WorkspaceNamespace workspaceNamespace = WorkspaceNamespace.create((ITeamRepository)wrapper.getNamespace().getRepository(), (ItemId)new ItemId((IItemHandle)wrapper.getWorkspace()), (ItemId)new ItemId((IItemHandle)wrapper.getComponent()));
        HistoryViewUtil.showHistory(context, new BaselinesInWorkspaceHistoryViewInput(workspaceNamespace));
    }

    public static String getChangeTypeText(IChangeNode.NodeType type) {
        String text = Messages.HistoryView_stateInitial;
        if (type == IChangeNode.NodeType.AFTER) {
            text = Messages.HistoryView_stateModified;
        } else if (type == IChangeNode.NodeType.RENAME) {
            text = Messages.HistoryView_stateRenamed;
        } else if (type == IChangeNode.NodeType.MOVE) {
            text = Messages.HistoryView_stateMoved;
        } else if (type == IChangeNode.NodeType.MERGE) {
            text = Messages.HistoryView_stateProposed;
        } else if (type == IChangeNode.NodeType.DELETE) {
            text = Messages.HistoryView_stateDeleted;
        } else if (type == IChangeNode.NodeType.ADDITION) {
            text = Messages.HistoryView_stateAdded;
        } else if (type == IChangeNode.NodeType.UNDO) {
            text = Messages.HistoryView_stateUndo;
        }
        return text;
    }
}

