/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class HistoryViewRowDecorator
extends TypeLabelProvider {
    private StateId selectedItemState = null;
    private Font boldFont;
    private Color conflictPointColor;

    public HistoryViewRowDecorator() {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        FontRegistry fontRegistry = theme.getFontRegistry();
        this.boldFont = (Font)this.getResources().get((DeviceResourceDescriptor)fontRegistry.getDescriptor("org.eclipse.jface.defaultfont").withStyle(1));
        this.conflictPointColor = this.getResources().createColor(new RGB(178, 34, 34));
    }

    public void setSelectedRow(StateId itemState) {
        if (!NullUtil.equals((Object)this.selectedItemState, (Object)itemState)) {
            this.selectedItemState = itemState;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void updateLabel(ViewerLabel label, Object element) {
        IHistoryEntry entry = (IHistoryEntry)element;
        if (this.selectedItemState == null) {
            return;
        }
        AbstractFileSystemItemWrapper targetItem = entry.getTargetItem();
        if (targetItem != null && targetItem.getFileItem().equals((Object)this.selectedItemState)) {
            label.setFont(this.boldFont);
        } else if (entry.isConflictPoint()) {
            label.setForeground(this.conflictPointColor);
            label.setFont(this.boldFont);
        }
    }
}

