/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.AbstractSearchAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.SearchForBaselinesAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.SearchForChangeSetsAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNodeUtil;
import com.ibm.team.filesystem.rcp.ui.internal.RcpUiPlugin;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.CopyChangeSetWebURLAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenRemoteFileAction;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.editor.PartUtil;
import com.ibm.team.filesystem.ui.inputs.RepositoryFilesViewInput;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.operations.LiveAnnotateUtil;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.adapters.ChangeSetSelectionTester;
import com.ibm.team.internal.filesystem.ui.adapters.IChangeSetSelector;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditorInput;
import com.ibm.team.internal.filesystem.ui.labelproviders.DateLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.internal.filesystem.ui.views.history.AbstractPartTracker;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryEntryLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryEntrySorter;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryPreferencesPart;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewRowDecorator;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.internal.filesystem.ui.views.history.StateMergesColumn;
import com.ibm.team.internal.filesystem.ui.views.history.actions.CompareHistoryFilesAction;
import com.ibm.team.internal.filesystem.ui.views.history.actions.CompareHistoryWithLocalWorkspaceAction;
import com.ibm.team.internal.filesystem.ui.views.history.actions.CompareWithLocalFileAction;
import com.ibm.team.internal.filesystem.ui.views.history.actions.SwitchHistoryInputAction;
import com.ibm.team.internal.filesystem.ui.views.history.columns.AddedByColumn;
import com.ibm.team.internal.filesystem.ui.views.history.columns.BaselineDescriptionColumn;
import com.ibm.team.internal.filesystem.ui.views.history.columns.CommentColumn;
import com.ibm.team.internal.filesystem.ui.views.history.columns.CreatorColumn;
import com.ibm.team.internal.filesystem.ui.views.history.columns.DateAddedColumn;
import com.ibm.team.internal.filesystem.ui.views.history.columns.DateModifiedColumn;
import com.ibm.team.internal.filesystem.ui.views.history.columns.IHistoryViewColumn;
import com.ibm.team.internal.filesystem.ui.views.history.columns.MergesColumn;
import com.ibm.team.internal.filesystem.ui.views.history.columns.PlannedForColumn;
import com.ibm.team.internal.filesystem.ui.views.history.columns.VersionIdColumn;
import com.ibm.team.internal.filesystem.ui.views.history.entries.BaselineHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.entries.VersionableHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.BaselineConfigurationHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.BaselinesInRepositoryHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.BaselinesInWorkspaceHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.VersionableInBaselineHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.VersionableInRepositoryHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.VersionableInWorkspaceHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.WorkspaceConfigurationHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.queries.ConfigurationHistoryViewQuery;
import com.ibm.team.internal.filesystem.ui.views.history.queries.VersionableHistoryViewQuery;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.SimpleLocalSelectionTargetAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.preferences.RecursivePreferenceListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.AbstractActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.CheckAction;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.menus.SeparatorExt;
import com.ibm.team.repository.rcp.ui.internal.parts.PreferencesInputFactory;
import com.ibm.team.repository.rcp.ui.internal.query.PagedTable;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.DelegatingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.TableViewerColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IContextMenuHandler;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IMenuProvider;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.IPartSiteServices;
import com.ibm.team.repository.rcp.ui.parts.IReusablePart;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopyFactory;
import com.ibm.team.repository.rcp.ui.workingcopy.WorkingCopies;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.events.ICommitEvent;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.changenodes.IChangeNode;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class HistoryView
extends AbstractPart
implements IRefreshable,
IReusablePart,
IMenuProvider {
    private static final String HISTORY_MENU_STATES_ID = "com.ibm.team.filesystem.history.states";
    public static final String HISTORY_MENU_ID = "com.ibm.team.filesystem.history";
    public static final String COUNT = "count";
    public static final int DEFAULT_COUNT = 100;
    public static final int HISTORY_ACTION_COMPARE_WITH_LOCAL = 2;
    public static final int HISTORY_ACTION_COMPARE = 1;
    public static final int HISTORY_ACTION_OPEN = 0;
    public static final String DOUBLECLICKACTION = "doubleclickaction";
    public static final String FILE_HISTORY_ALGORITHM = "filehistoryalgorithm";
    public static final int ALGORITHM_NEW_SERVER_SIDE_HISTORY = 0;
    public static final int ALGORITHM_SERVER_SIDE_HISTORY = 1;
    public static final int DEFAULT_HISTORY_ALGORITHM = 1;
    public static final String STATES = "states";
    public static final boolean HISTORY_STATES_DEFAULT = false;
    public static final String IS_HIDING_BASELINES = "showBaselines";
    public static final boolean IS_HIDING_BASELINES_DEFAULT = false;
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    public static final String SEARCH_INTERMEDIATE = "searchIntermediateChangeSet";
    public static final boolean HISTORY_SEARCH_INTERMEDIATE_DEFAULT = false;
    private SimpleTableViewer<IHistoryEntry> viewer;
    private ITeamRepository server;
    private IAction copyAction;
    private IAction copyWebURLAction;
    private IRunnableWithSelection openHandler = new IRunnableWithSelection(){

        public void run(Object selection, Shell targetShell) {
            IHistoryEntry entry = (IHistoryEntry)selection;
            switch (HistoryView.this.prefs.getInt(HistoryView.DOUBLECLICKACTION, 1)) {
                case 0: {
                    HistoryView.this.doOpen(entry);
                    break;
                }
                case 1: {
                    HistoryView.this.doCompare(entry);
                    break;
                }
                case 2: {
                    HistoryView.this.doCompareWithLocal(entry);
                }
            }
        }
    };
    private IRunnableWithSelection doubleClickStateHandler = new IRunnableWithSelection(){

        public void run(Object selectedObject, Shell targetShell) {
            IChangeNode node = (IChangeNode)selectedObject;
            HistoryView.this.doOpenState(node, targetShell);
        }
    };
    private PushAction preferencesAction;
    private SwitchHistoryInputAction showAllStatesAction;
    private SwitchHistoryInputAction showBiggerInputAction;
    private CheckAction toggleBaselinesAction;
    private SwitchHistoryInputAction showIncomingCollaboratorStreamHistory;
    private SwitchHistoryInputAction showOutgoingCollaboratorStreamHistory;
    private SwitchHistoryInputAction showBaselineDiagramAction;
    private CheckAction showItemStatesAction;
    private RecursivePreferenceListener preferenceListener;
    private IEclipsePreferences prefs;
    private Operation highlightJob = new Operation(){

        public void run(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)100);
            try {
                StateId highlightedEntry = null;
                AbstractFileSystemItemWrapper focusItem = HistoryView.this.input.getFocusItem();
                if (focusItem != null) {
                    IShareable shareable = null;
                    ISharingManager mgr = FileSystemCore.getSharingManager();
                    ItemId item = focusItem.getFileItem().getItemId();
                    if (item.isNull()) {
                        return;
                    }
                    Collection shareables = mgr.findShareables((IVersionableHandle)item.toHandle(), (IProgressMonitor)progress.newChild(60));
                    if (shareables.size() > 0) {
                        SubMonitor progressShareables = SubMonitor.convert((IProgressMonitor)progress.newChild(10), (int)shareables.size());
                        for (IShareable shareableItem : shareables) {
                            IShare share = shareableItem.getShare((IProgressMonitor)progressShareables.newChild(1));
                            IContextHandle context = focusItem.getWorkspace().getContextHandle();
                            if (!share.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)context)) continue;
                            shareable = shareableItem;
                            break;
                        }
                        if (shareable == null) {
                            shareable = (IShareable)shareables.iterator().next();
                        }
                    }
                    if (shareable != null) {
                        HistoryView.this.attachShareListener(shareable);
                        IVersionableHandle handle = shareable.getRemote((IProgressMonitor)progress.newChild(30));
                        if (handle != null) {
                            highlightedEntry = new StateId((IItemHandle)handle);
                        }
                    }
                    if (highlightedEntry != null) {
                        final StateId finalState = highlightedEntry;
                        SWTUtil.greedyExec((Display)HistoryView.this.display, (Control)HistoryView.this.viewer.getTable(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                HistoryView.this.setHighlight(finalState);
                            }
                        });
                    }
                }
            }
            catch (FileSystemException e) {
                StatusUtil.log((Object)this, (Throwable)e);
            }
        }
    };
    private HistoryViewRowDecorator rowDecorator = new HistoryViewRowDecorator();
    private IShareable shareListenerAttached;
    private ICopyFileAreaListener copyFileAreaListener;
    private ISelectionProvider revisionSelectionProvider;
    private ISelectionChangedListener revisionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = event.getSelection();
            this.highlightRevision(sel);
        }

        private void highlightRevision(ISelection sel) {
            Object first;
            IStructuredSelection ss;
            if (sel instanceof IStructuredSelection && !(ss = (IStructuredSelection)sel).isEmpty() && (first = ss.getFirstElement()) instanceof Revision) {
                Revision rev = (Revision)first;
                HistoryView.this.showRevision(rev);
            }
        }
    };
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            HistoryView.this.listenToActiveEditor();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            HistoryView.this.listenToActiveEditor();
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private AbstractHistoryViewInput input;
    private ISetWithListeners currentQuery;
    private IPartSiteServices partServices;
    private MenuExt menu;
    private MenuExt toolbar;
    private IContextMenuHandler contextMenuHandler;
    private Display display;
    private IListener collaborationListener = new IListener(){

        public void handleEvents(List events) {
            if (HistoryView.this.input == null) {
                return;
            }
            for (Object next : events) {
                IComponentSyncContext context;
                ItemNamespace localNamespace;
                IEvent event = (IEvent)next;
                if (!(event.getEventSource() instanceof IComponentSyncContext) || !(localNamespace = PendingChangesUtil.getLocalNamespace(context = (IComponentSyncContext)event.getEventSource())).equals((Object)HistoryView.this.input.getNamespace())) continue;
                SWTUtil.greedyExec((Display)HistoryView.this.display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (HistoryView.this.pagedTable != null && !HistoryView.this.pagedTable.getControl().isDisposed()) {
                            ItemNamespace remoteIncomingNamespace = PendingChangesUtil.getRemoteIncomingNamespace(context);
                            ItemNamespace remoteOutgoingNamespace = PendingChangesUtil.getRemoteOutgoingNamespace(context);
                            HistoryView.this.updateActions(remoteIncomingNamespace, remoteOutgoingNamespace);
                        }
                    }
                });
            }
            HistoryView.this.recomputeHighlightedRow();
        }
    };
    private IListener repositoryListener = new IListener(){

        public void handleEvents(List events) {
            SWTUtil.greedyExec((Display)HistoryView.this.display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    HistoryView.this.updateCollaboratorStream();
                }
            });
        }
    };
    private IListener contentDeletedListener = new IListener(){

        public void handleEvents(List events) {
            if (HistoryView.this.sashForm.getMaximizedControl() == null) {
                UpdateStatesJob updateStatesJob = new UpdateStatesJob(HistoryView.this.stateEntryInput.getRealm(), HistoryView.this.currentStateInput);
                HistoryView.this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_fetchingItemStatesOpName, (Operation)updateStatesJob);
            }
        }
    };
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("pref_show_version_identifiers_repository_id".equals(event.getProperty())) {
                HistoryView.this.refresh();
                if (HistoryView.this.currentStateInput != null) {
                    Realm realm = HistoryView.this.stateEntryInput.getRealm();
                    HistoryView.this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_fetchingItemStatesOpName, (Operation)new UpdateStatesJob(realm, HistoryView.this.currentStateInput));
                }
            }
        }
    };
    private IListener commitListener = new IListener(){

        public void handleEvents(final List events) {
            if (HistoryView.this.stateEntryInput == null) {
                return;
            }
            HistoryView.this.stateEntryInput.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (HistoryView.this.stateEntryInput == null || HistoryView.this.currentStateInput == null) {
                        return;
                    }
                    if (HistoryView.this.sashForm.getMaximizedControl() != null) {
                        return;
                    }
                    ChangeSetWrapper wrapper = HistoryView.this.currentStateInput.getChangeSet();
                    if (wrapper == null) {
                        return;
                    }
                    if (!wrapper.getChangeSet().isActive()) {
                        return;
                    }
                    boolean shouldRefresh = false;
                    for (Object event : events) {
                        if (!(event instanceof ICommitEvent)) continue;
                        ICommitEvent commitEvent = (ICommitEvent)event;
                        if (!wrapper.getChangeSet().sameItemId((IItemHandle)commitEvent.getChangeSet())) continue;
                        shouldRefresh = true;
                        break;
                    }
                    if (shouldRefresh) {
                        UpdateStatesJob updateStatesJob = new UpdateStatesJob(HistoryView.this.stateEntryInput.getRealm(), HistoryView.this.currentStateInput);
                        HistoryView.this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_fetchingItemStatesOpName, (Operation)updateStatesJob);
                    }
                }
            });
        }
    };
    private IConnection commitListenerConnection;
    private AbstractPartTracker tracker;
    private MergesColumn orderColumn;
    private CommentColumn commentColumn;
    private BaselineDescriptionColumn baselineDescriptionColumn;
    private CreatorColumn creatorColumn;
    private DateModifiedColumn dateModifiedColumn;
    private DateAddedColumn dateAddedColumn;
    private AddedByColumn addedByColumn;
    private VersionIdColumn versionColumn;
    private PlannedForColumn plannedForColumn;
    private PagedTable<IHistoryEntry> pagedTable;
    private SimpleTableViewer<ChangeNode> stateViewer;
    boolean showStates;
    private boolean isHidingBaselines;
    private SashForm sashForm;
    private int orientation;
    private ToggleOrientationAction[] toggleOrientationActions;
    private LayoutAction layoutAction;
    private Composite changeHistorySection;
    private WritableSetWithListeners<ChangeNode> stateEntryInput;
    private VersionableHistoryEntry currentStateInput;
    private LocalResourceManager resourceManager;

    public HistoryView(IControlSite viewSite, Object initialInput) {
        super(viewSite, initialInput);
        this.display = Display.getCurrent();
        this.partServices = (IPartSiteServices)Adapters.getAdapter((Object)viewSite, IPartSiteServices.class);
        this.contextMenuHandler = (IContextMenuHandler)Adapters.getAdapter((Object)viewSite, IContextMenuHandler.class);
        this.stateEntryInput = new WritableSetWithListeners();
        Composite parent = viewSite.getParent();
        this.sashForm = new SashForm(parent, 512){

            public void setMaximizedControl(Control control) {
                super.setMaximizedControl(control);
                LayoutAction action = HistoryView.this.getLayoutAction();
                if (action != null) {
                    action.setVisible(control == null);
                }
            }
        };
        IPreferenceStore preferences = UiPlugin.getDefault().getPreferenceStore();
        this.setOrientation(preferences.getInt("prefs_history_view_orientation"));
        this.changeHistorySection = new Composite((Composite)this.sashForm, 0);
        Composite stateSection = new Composite((Composite)this.sashForm, 0);
        this.prefs = this.getConfigPrefs();
        this.showStates = this.prefs.getBoolean(STATES, false);
        this.isHidingBaselines = this.prefs.getBoolean(IS_HIDING_BASELINES, false);
        this.createStateSection(viewSite, stateSection);
        this.sashForm.setMaximizedControl((Control)(this.showStates ? null : this.changeHistorySection));
        this.preferenceListener = new RecursivePreferenceListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                HistoryView.this.showStates = HistoryView.this.prefs.getBoolean(HistoryView.STATES, false);
                HistoryView.this.isHidingBaselines = HistoryView.this.prefs.getBoolean(HistoryView.IS_HIDING_BASELINES, false);
                if (event.getKey().equals(HistoryView.STATES)) {
                    HistoryView.this.updateStateInput((VersionableHistoryEntry)HistoryView.this.viewer.getSelection().getFirstElement());
                    return;
                }
                SWTUtil.runOnce((Display)HistoryView.this.display, (Control)HistoryView.this.getControlSite().getParent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        HistoryView.this.updateInput();
                    }
                });
            }
        });
        try {
            this.preferenceListener.attachTo(this.prefs);
        }
        catch (BackingStoreException e1) {
            throw new RuntimeException(e1);
        }
        this.pagedTable = new PagedTable(this.changeHistorySection, viewSite.getContext(), 82690, this.prefs.node("table_v2"), this.contextMenuHandler);
        this.viewer = this.pagedTable.getViewer();
        this.viewer.setProgressService((IBusyHandler)viewSite);
        IOperationRunner runner = viewSite.getOperationRunner();
        this.viewer.setRowDecorator((IViewerLabelProvider)this.rowDecorator);
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof VersionableHistoryEntry) {
                    HistoryView.this.updateStateInput((VersionableHistoryEntry)element);
                }
            }
        });
        this.toggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(0), new ToggleOrientationAction(1)};
        this.orderColumn = new MergesColumn(this.viewer, Messages.HistoryView_mergesColumn, 75);
        this.commentColumn = new CommentColumn(this.viewer, Messages.HistoryView_commentColumn, 350);
        this.commentColumn.setLabelProvider((IViewerLabelProvider)new HistoryEntryLabelProvider((ISetWithListeners<IHistoryEntry>)this.viewer.getKnownElements(), !this.isHidingBaselines, this.getControlSite().getOperationRunner()));
        this.baselineDescriptionColumn = new BaselineDescriptionColumn(this.viewer, Messages.HistoryView_descriptionColumnName, 300);
        this.creatorColumn = new CreatorColumn(this.viewer, Messages.HistoryView_creatorColumn, 150, runner);
        this.dateModifiedColumn = new DateModifiedColumn(this.viewer, Messages.HistoryView_dateColumn, 150);
        this.addedByColumn = new AddedByColumn(this.viewer, Messages.HistoryView_AddedByColumn, 150, runner);
        this.dateAddedColumn = new DateAddedColumn(this.viewer, Messages.HistoryView_DateAddedColumn, 150);
        this.versionColumn = new VersionIdColumn(this.viewer, Messages.HistoryView_versionIdColumn, 110);
        this.plannedForColumn = new PlannedForColumn(this.viewer, Messages.HistoryView_plannedForColumn, 150, runner);
        this.viewer.setDoubleClickHandler(this.openHandler);
        this.viewer.setSorter((Comparator)new HistoryEntrySorter());
        viewSite.setSelectionProvider(this.viewer.getSelectionProvider());
        this.showAllStatesAction = new SwitchHistoryInputAction(ImagePool.ALL_FILE_STATES, ImagePool.ALL_FILE_STATES_DISABLED, Messages.HistoryView_showAllAction, this);
        this.showBaselineDiagramAction = new SwitchHistoryInputAction(ImagePool.GRAPHICAL_BASELINES, ImagePool.GRAPHICAL_BASELINES_DISABLED, Messages.HistoryView_showBaselineDiagramAction, this){

            @Override
            public void run() {
                AbstractHistoryViewInput input = this.getInput();
                if (HistoryView.this.partServices != null && input instanceof BaselinesInWorkspaceHistoryViewInput && input.getNamespace() instanceof WorkspaceNamespace) {
                    final Display display = Display.getCurrent();
                    Composite c = HistoryView.this.getControlSite().getParent();
                    final BaselinesInWorkspaceHistoryViewInput baselinesHistoryInput = (BaselinesInWorkspaceHistoryViewInput)input;
                    ITeamRepository repo = baselinesHistoryInput.getRepository();
                    final WorkspaceNamespace workspaceContext = (WorkspaceNamespace)input.getNamespace();
                    HistoryView.this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_OpenBaselineDiagramJobName, (Operation)new RepositoryOperation(baselinesHistoryInput.getRepository(), (Control)c, repo){
                        private final /* synthetic */ Control val$c;
                        private final /* synthetic */ ITeamRepository val$repo;
                        {
                            this.val$c = control;
                            this.val$repo = iTeamRepository;
                            super($anonymous0);
                        }

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            ItemId workspaceID = workspaceContext.getWorkspaceId();
                            final IWorkspace workspace = (IWorkspace)RepoFetcher.fetchCurrent((ITeamRepository)baselinesHistoryInput.getRepository(), (ItemId)workspaceID, (IProgressMonitor)progress.newChild(40));
                            ItemId componentId = workspaceContext.fetchComponentId((IProgressMonitor)progress.newChild(20));
                            final IComponent component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)baselinesHistoryInput.getRepository(), (ItemId)componentId, (IProgressMonitor)progress.newChild(40));
                            if (workspace != null && component != null) {
                                SWTUtil.greedyExec((Display)display, (Control)this.val$c, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        GraphicalBaselinesEditorInput input = new GraphicalBaselinesEditorInput();
                                        input.setRepository(val$repo);
                                        input.setWorkspaces(Collections.singletonList(workspace));
                                        input.setComponent(component);
                                        GraphicalBaselinesEditor.open(HistoryView.this.partServices.getPage(), input);
                                    }
                                });
                            }
                        }
                    });
                }
            }
        };
        this.preferencesAction = new PushAction(Messages.HistoryView_preferencesAction, new Runnable(){

            @Override
            public void run() {
                HistoryView.this.openPreferences();
            }
        });
        this.showBiggerInputAction = new SwitchHistoryInputAction(ImagePool.HISTORY_OF_STREAM, ImagePool.HISTORY_OF_STREAM_DISABLED, Messages.HistoryView_showComponentHistoryAction, this);
        this.toggleBaselinesAction = new CheckAction(ImagePool.BASELINE, Messages.ToggleBaselinesAction_Show_Baselines);
        this.toggleBaselinesAction.setSelected(!this.isHidingBaselines);
        this.toggleBaselinesAction.addChangeListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                if (property != AbstractActionExt.PROP_SELECTED) {
                    return;
                }
                HistoryView.this.isHidingBaselines = !HistoryView.this.toggleBaselinesAction.getSelection();
                HistoryView.this.prefs.putBoolean(HistoryView.IS_HIDING_BASELINES, HistoryView.this.isHidingBaselines);
            }
        });
        this.toggleBaselinesAction.setEnabled(true);
        this.showIncomingCollaboratorStreamHistory = new SwitchHistoryInputAction(ImagePool.OPEN_INCOMING_COLLABORATOR_STREAM, ImagePool.OPEN_INCOMING_COLLABORATOR_STREAM_DISABLED, Messages.HistoryView_showIncomingCollaborationHistoryAction, this);
        this.showOutgoingCollaboratorStreamHistory = new SwitchHistoryInputAction(ImagePool.OPEN_OUTGOING_COLLABORATOR_STREAM, ImagePool.OPEN_OUTGOING_COLLABORATOR_STREAM_DISABLED, Messages.HistoryView_showOutgoingCollaborationHistoryAction, this);
        if (this.contextMenuHandler != null) {
            this.contextMenuHandler.registerContextMenu(HISTORY_MENU_ID, this.viewer.getContextMenu(), this.viewer.getSelectionProvider());
        }
        if (this.partServices != null) {
            this.partServices.getPage().addPartListener(this.partListener);
        }
        RcpUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        this.setInput(initialInput);
        FileSystemResourcesPlugin.getComponentSyncModel().addGenericListener((Object)"refreshedRemoteCompleted", this.collaborationListener);
        final IControlSite site = this.getControlSite();
        this.copyWebURLAction = new Action(Messages.HistoryView_copyWebUrlAction){

            public void run() {
                IStructuredSelection selection = HistoryView.this.viewer.getSelection();
                List<ChangeSetWrapper> csWrappers = AdapterUtil.adaptList(selection.toList(), ChangeSetWrapper.class);
                if (csWrappers.size() > 0) {
                    CopyChangeSetWebURLAction.copyToClipboard(HistoryView.this.getActionContext(), csWrappers);
                    return;
                }
                List<BaselineHistoryEntry> blWrappers = AdapterUtil.adaptList(selection.toList(), BaselineHistoryEntry.class);
                if (blWrappers.size() > 0) {
                    HistoryView.this.copyToClipboard(HistoryView.this.getActionContext(), blWrappers);
                    return;
                }
            }
        };
        this.copyAction = new Action(Messages.HistoryView_copyTextAction){

            private void append(StringBuffer sb, String string) {
                int QUOTE = 34;
                sb.append('\"');
                char[] cArray = string.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (c == '\"') {
                        sb.append('\"');
                    }
                    sb.append(c);
                    ++n2;
                }
                sb.append('\"');
            }

            public void run() {
                Table table = HistoryView.this.viewer.getTable();
                int columnCount = table.getColumnCount();
                TableItem[] items = table.getSelection();
                int itemCount = items.length;
                String lineSeparator = System.getProperty("line.separator");
                StringBuffer sb = new StringBuffer();
                int columnVisibleCount = 0;
                boolean mergesColumnVisible = false;
                boolean mergeColumnFound = false;
                int mergeColumnIndex = -1;
                int i = 0;
                while (i < columnCount) {
                    String columnText = table.getColumn(i).getText();
                    if (columnText.equals(Messages.HistoryView_mergesColumn) && table.getColumn(i).getWidth() > 0) {
                        mergesColumnVisible = true;
                    }
                    if (table.getColumn(i).getWidth() > 0) {
                        ++columnVisibleCount;
                    }
                    ++i;
                }
                boolean columnTitleEntered = false;
                int i2 = 0;
                while (i2 < columnCount) {
                    String columnText = table.getColumn(i2).getText();
                    if (columnText.equals(Messages.HistoryView_mergesColumn)) {
                        mergeColumnFound = true;
                        mergeColumnIndex = i2;
                    } else if (table.getColumn(i2).getWidth() > 0) {
                        this.append(sb, columnText);
                        columnTitleEntered = true;
                    }
                    if (columnTitleEntered && i2 < columnCount - 1 && i2 < columnVisibleCount && table.getColumn(i2).getWidth() > 0 && (columnVisibleCount != 2 || !mergesColumnVisible)) {
                        sb.append(", ");
                    }
                    ++i2;
                }
                if (sb.length() > 1) {
                    sb.insert(1, '<');
                    sb.insert(sb.length() - 1, '>');
                    sb.append(lineSeparator);
                }
                i2 = 0;
                while (i2 < itemCount) {
                    boolean itemColumnEntered = false;
                    int j = 0;
                    while (j < columnCount) {
                        if (mergeColumnFound && j != mergeColumnIndex && table.getColumn(j).getWidth() > 0) {
                            this.append(sb, items[i2].getText(j));
                            itemColumnEntered = true;
                        }
                        if (itemColumnEntered && j < columnCount - 1 && j < columnVisibleCount && table.getColumn(j).getWidth() > 0 && (columnVisibleCount != 2 || !mergesColumnVisible)) {
                            sb.append(", ");
                        }
                        ++j;
                    }
                    if (i2 < itemCount - 1) {
                        sb.append(lineSeparator);
                    }
                    ++i2;
                }
                if (sb.length() > 0) {
                    HistoryView.this.copyStringToClipboard(site.getShell().getDisplay(), sb.toString());
                }
            }
        };
        Action copyVersionIdAction = new Action(Messages.HistoryView_copyVersionIdAction){

            public void run() {
                String lineSeparator = System.getProperty("line.separator");
                IStructuredSelection selection = (IStructuredSelection)HistoryView.this.viewer.getSelectionProvider().getSelection();
                StringBuilder builder = new StringBuilder();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof VersionableHistoryEntry) {
                        VersionableHistoryEntry entry = (VersionableHistoryEntry)o;
                        String versionId = entry.getVersionId();
                        if (versionId == null) {
                            AbstractFileSystemItemWrapper item = entry.getTargetItem();
                            if (item != null && item.getFileItem().isDeleted()) {
                                builder.append(Messages.HistoryView_deletedVersionLabel);
                            }
                        } else {
                            builder.append(versionId);
                        }
                    }
                    builder.append(lineSeparator);
                    ++n2;
                }
                builder.deleteCharAt(builder.length() - 1);
                HistoryView.this.copyStringToClipboard(site.getShell().getDisplay(), builder.toString());
            }
        };
        ActionContributionItem copyVersionIdItem = new ActionContributionItem((IAction)copyVersionIdAction);
        this.viewer.getContextMenu().appendToGroup("jazz.refactoring.group", (IContributionItem)new Separator());
        this.viewer.getContextMenu().appendToGroup("jazz.refactoring.group", this.copyWebURLAction);
        this.viewer.getContextMenu().appendToGroup("jazz.refactoring.group", this.copyAction);
        this.viewer.addHeaderListener((IPartResult)new IPartResult<TableViewerColumn<IHistoryEntry>>(){

            public void setResult(TableViewerColumn<IHistoryEntry> result) {
                HistoryView.this.headerClicked();
            }
        });
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener((IContributionItem)copyVersionIdItem, (IAction)copyVersionIdAction){
            private final /* synthetic */ IContributionItem val$copyVersionIdItem;
            private final /* synthetic */ IAction val$copyVersionIdAction;
            {
                this.val$copyVersionIdItem = iContributionItem;
                this.val$copyVersionIdAction = iAction;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                HistoryView.this.copyWebURLAction.setEnabled(this.checkEnabled(event));
                HistoryView.this.copyAction.setEnabled(!event.getSelection().isEmpty());
                MenuManager manager = HistoryView.this.viewer.getContextMenu();
                manager.remove(this.val$copyVersionIdItem);
                if (HistoryView.this.input.getFocusItem() != null) {
                    this.val$copyVersionIdAction.setEnabled(!event.getSelection().isEmpty());
                    manager.appendToGroup("jazz.refactoring.group", this.val$copyVersionIdItem);
                }
            }

            private boolean checkEnabled(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return false;
                }
                List<ChangeSetWrapper> changeSetWrappers = AdapterUtil.adaptList(((IStructuredSelection)event.getSelection()).toList(), ChangeSetWrapper.class);
                if (changeSetWrappers.size() > 0) {
                    return CopyChangeSetWebURLAction.shouldEnable(changeSetWrappers);
                }
                List<BaselineHistoryEntry> baselineWrappers = AdapterUtil.adaptList(((IStructuredSelection)event.getSelection()).toList(), BaselineHistoryEntry.class);
                return baselineWrappers.size() > 0;
            }
        });
        this.viewer.addDragSupport(21, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SimpleLocalSelectionTargetAdapter(this.viewer));
        if (this.partServices != null) {
            this.tracker = new AbstractPartTracker(this.partServices.getPage(), this.partServices.getPart().getSite().getId()){

                @Override
                protected void visibilityChanged(boolean visible) {
                    HistoryView.this.deferUpdates(!visible);
                }
            };
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.sashForm, "com.ibm.team.filesystem.ide.ui.view_history");
        this.changeHistorySection.setLayout((Layout)new FillLayout());
    }

    protected void copyToClipboard(UIContext context, List<BaselineHistoryEntry> blWrappers) {
        StringBuilder buf = new StringBuilder();
        String sep = System.getProperty("line.separator");
        for (BaselineHistoryEntry bl : blWrappers) {
            String repoURI;
            if (buf.length() > 0) {
                buf.append(sep);
            }
            if ((repoURI = bl.getRepository().publicUriRoot()) == null) {
                repoURI = bl.getRepository().getRepositoryURI();
            }
            Location loc = Location.itemLocation((IItemHandle)bl.getBaseline(), (String)repoURI);
            buf.append(loc.toAbsoluteUri().toString());
        }
        this.copyStringToClipboard(context.getDisplay(), buf.toString());
    }

    private void copyStringToClipboard(Display display, String toCopy) {
        Clipboard clipBoard = new Clipboard(display);
        TextTransfer textTransfer = TextTransfer.getInstance();
        clipBoard.setContents(new Object[]{toCopy}, new Transfer[]{textTransfer});
        clipBoard.dispose();
    }

    private void createStateSection(IControlSite viewSite, Composite pane) {
        this.currentStateInput = null;
        this.stateViewer = new SimpleTableViewer(pane);
        this.stateViewer.setInput(this.stateEntryInput);
        this.showItemStatesAction = new CheckAction(Messages.HistoryView_showCheckInHistoryAction);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.stateViewer.getTable());
        this.showItemStatesAction.setSelected(this.showStates);
        this.showItemStatesAction.addChangeListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                if (property != AbstractActionExt.PROP_SELECTED) {
                    return;
                }
                HistoryView.this.showStates = HistoryView.this.showItemStatesAction.getSelection();
                HistoryView.this.prefs.putBoolean(HistoryView.STATES, HistoryView.this.showItemStatesAction.getSelection());
            }
        });
        new StateMergesColumn(this.stateViewer, Messages.HistoryView_checkinHistoryColumnName, Messages.HistoryView_stateMergeColumnTooltip, SWTUtil.getTextWidth((Drawable)pane, (String)Messages.HistoryView_stateMergeColumnTooltip));
        LabelColumn typeColumn = new LabelColumn(this.stateViewer, Messages.HistoryView_typeColumnName, Messages.HistoryView_typeColumnTooltip, 300);
        LabelColumn dateColumn = new LabelColumn(this.stateViewer, Messages.HistoryView_dateColumnName, Messages.HistoryView_dateColumnTooltip, 210);
        LabelColumn versionsColumn = new LabelColumn(this.stateViewer, Messages.HistoryView_versionIdColumn, Messages.HistoryView_versionIdColumnTooltip, 150);
        versionsColumn.setLabelProvider((IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof ChangeNode) {
                    ChangeNode node = (ChangeNode)element;
                    if (node.getType() == IChangeNode.NodeType.DELETE) {
                        label.setText(Messages.HistoryView_deletedVersionLabel);
                    } else {
                        IVersionableIdentifier identifier = node.getIdentifier();
                        if (identifier != null) {
                            boolean showRepo = RcpUiPlugin.getDefault().getPreferenceStore().getBoolean("pref_show_version_identifiers_repository_id");
                            label.setText(showRepo ? identifier.getLongVersionId() : identifier.getShortVersionId());
                        }
                    }
                }
            }
        });
        dateColumn.setLabelProvider((IViewerLabelProvider)new DelegatingLabelProvider((IViewerLabelProvider)new DateLabelProvider()){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof ChangeNode) {
                    IChangeNode node = (IChangeNode)element;
                    super.updateLabel(label, (Object)node.getDate());
                }
            }
        });
        typeColumn.setLabelProvider((IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                String text = Messages.HistoryView_stateInitial;
                if (element instanceof ChangeNode) {
                    ChangeNode node = (ChangeNode)element;
                    if (node.getType() == IChangeNode.NodeType.AFTER) {
                        label.setImage(HistoryView.this.resourceManager.createImage(ImagePool.HISTORY_VIEW_STATE_MODIFY));
                        text = Messages.HistoryView_stateModified;
                    } else if (node.getType() == IChangeNode.NodeType.RENAME) {
                        label.setImage(HistoryView.this.resourceManager.createImage(ImagePool.HISTORY_VIEW_STATE_RENAME));
                        text = Messages.HistoryView_stateRenamed;
                    } else if (node.getType() == IChangeNode.NodeType.MOVE) {
                        label.setImage(HistoryView.this.resourceManager.createImage(ImagePool.HISTORY_VIEW_STATE_MOVE));
                        text = Messages.HistoryView_stateMoved;
                    } else if (node.getType() == IChangeNode.NodeType.BEFORE) {
                        label.setImage(HistoryView.this.resourceManager.createImage(ImagePool.HISTORY_VIEW_STATE_INITIAL));
                    } else if (node.getType() == IChangeNode.NodeType.MERGE) {
                        if (node.getState() == null) {
                            label.setImage(HistoryView.this.resourceManager.createImage(ImagePool.HISTORY_VIEW_STATE_MERGE_DELETE));
                        } else {
                            label.setImage(HistoryView.this.resourceManager.createImage(ImagePool.HISTORY_VIEW_STATE_MERGE));
                        }
                        text = Messages.HistoryView_stateProposed;
                    } else if (node.getType() == IChangeNode.NodeType.DELETE) {
                        label.setImage(HistoryView.this.resourceManager.createImage(ImagePool.HISTORY_VIEW_STATE_DELETE));
                        text = Messages.HistoryView_stateDeleted;
                    } else if (node.getType() == IChangeNode.NodeType.ADDITION) {
                        label.setImage(HistoryView.this.resourceManager.createImage(ImagePool.HISTORY_VIEW_STATE_ADD));
                        text = Messages.HistoryView_stateAdded;
                    } else if (node.getType() == IChangeNode.NodeType.UNDO) {
                        label.setImage(HistoryView.this.resourceManager.createImage(ImagePool.HISTORY_VIEW_STATE_UNDO));
                        text = Messages.HistoryView_stateUndo;
                    }
                    if (node.isLast()) {
                        String csStatus = "";
                        csStatus = node.isActive() ? Messages.HistoryView_changeSetStatusActive : Messages.HistoryView_changeSetStatusComplete;
                        text = NLS.bind((String)Messages.HistoryView_changeSetTypeAndStatus, (Object)csStatus, (Object[])new Object[]{text});
                    }
                    if (!node.hasContent()) {
                        DateFormat shortDateFormat = DateFormat.getDateTimeInstance(2, 3);
                        String decorator = NLS.bind((String)Messages.HistoryView_contentDeletedDecorator, (Object)(node.getDeletedBy() == null ? Messages.HistoryView_contentDeletedUnknownContributor : node.getDeletedBy().getName()), (Object[])new Object[]{node.getDeletedByDate() == null ? Messages.HistoryView_contentDeletedUnknownDate : shortDateFormat.format(node.getDeletedByDate())});
                        text = NLS.bind((String)Messages.HistoryView_changeSetTextAndDeletedDecorator, (Object)text, (Object[])new Object[]{decorator});
                    }
                }
                label.setText(text);
            }
        });
        this.stateViewer.setRowDecorator(new IViewerLabelProvider(){
            private ColorDescriptor deletedColor;

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
                HistoryView.this.resourceManager.destroyColor(this.deletedColor);
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void updateLabel(ViewerLabel label, Object element) {
                ChangeNode node = (ChangeNode)element;
                if (!node.hasContent()) {
                    if (this.deletedColor == null) {
                        this.deletedColor = ColorDescriptor.createFrom((RGB)new RGB(160, 160, 160));
                    }
                    Color color = HistoryView.this.resourceManager.createColor(this.deletedColor);
                    label.setForeground(color);
                }
            }
        });
        this.stateViewer.setSorter((Comparator)new Comparator<ChangeNode>(){

            @Override
            public int compare(ChangeNode o1, ChangeNode o2) {
                return o2.getIndex() - o1.getIndex();
            }
        });
        this.stateViewer.setDoubleClickHandler(this.doubleClickStateHandler);
        this.contextMenuHandler.registerContextMenu(HISTORY_MENU_STATES_ID, this.stateViewer.getContextMenu(), this.stateViewer.getSelectionProvider());
        GridLayoutFactory.fillDefaults().spacing(0, 0).generateLayout(pane);
    }

    private UIContext getActionContext() {
        if (this.partServices != null) {
            return UIContext.createPartContext((IWorkbenchPart)this.partServices.getPart());
        }
        return UIContext.createShellContext((Shell)this.getControlSite().getShell());
    }

    protected void headerClicked() {
        if (this.input instanceof BaselinesInRepositoryHistoryViewInput || this.input instanceof BaselinesInWorkspaceHistoryViewInput) {
            MessageDialogWithToggle dialog;
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            boolean prompt = store.getBoolean("prompt_sort_history");
            boolean proceed = false;
            if (prompt && (dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getControlSite().getShell(), (String)Messages.HistoryView_sortBaselineDialogTitle, (String)Messages.HistoryView_sortBaselinesDialogText, (String)Messages.HistoryView_dontAskAgainText, (boolean)false, null, null)).getReturnCode() == 0) {
                proceed = true;
                store.setValue("prompt_sort_history", !dialog.getToggleState());
            }
            if (proceed) {
                final UIContext context = this.getActionContext();
                context.getUserOperationRunner().enqueue(Messages.BaselineSearchCriteriaPart_searchForBaselinesPartName, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        final BaselineSearchCriteria baselineCriteria = HistoryView.this.getBaselineSearchCriteria(monitor);
                        context.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                AbstractSearchAction.promptAndSearch(context, SearchForBaselinesAction.ARGS, baselineCriteria);
                            }
                        });
                    }
                });
            }
            return;
        }
        if (this.isChangeSetBasedInput(this.input)) {
            MessageDialogWithToggle dialog;
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            boolean prompt = store.getBoolean("prompt_sort_history");
            boolean proceed = false;
            if (prompt && (dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getControlSite().getShell(), (String)Messages.HistoryView_sortChangeSetsDialogTitle, (String)Messages.HistoryView_sortChangeSetsDialogText, (String)Messages.HistoryView_dontAskAgainText, (boolean)false, null, null)).getReturnCode() == 0) {
                proceed = true;
                store.setValue("prompt_sort_history", !dialog.getToggleState());
            }
            if (proceed) {
                final UIContext context = this.getActionContext();
                context.getUserOperationRunner().enqueue(Messages.HistoryView_computingCriteriaJobName, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        final ChangeSetSearchCriteriaPart.Input input = HistoryView.this.getEquivalentSearchCriteria(monitor);
                        context.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                AbstractSearchAction.promptAndSearch(context, SearchForChangeSetsAction.ARGS, input);
                            }
                        });
                    }
                });
            }
        }
    }

    private BaselineSearchCriteria getBaselineSearchCriteria(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = this.input.getRepository();
        ItemNamespace namespace = this.input.getNamespace();
        return HistoryView.getBaselineSearchCriteria(repository, namespace, monitor);
    }

    public static BaselineSearchCriteria getBaselineSearchCriteria(ITeamRepository repository, ItemNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ItemId component = namespace.fetchComponentId((IProgressMonitor)progress.newChild(100));
        BaselineSearchCriteria result = BaselineSearchCriteria.create(repository, (IComponentHandle)component.toHandle(), null, null, null, null, 100);
        return result;
    }

    private ChangeSetSearchCriteriaPart.Input getEquivalentSearchCriteria(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = this.input.getRepository();
        ItemNamespace namespace = this.input.getNamespace();
        AbstractFileSystemItemWrapper focusItem = this.input.getFocusItem();
        return HistoryView.getEquivalentSearchCriteria(repository, namespace, focusItem, monitor);
    }

    public static ChangeSetSearchCriteriaPart.Input getEquivalentSearchCriteria(ITeamRepository repository, ItemNamespace namespace, AbstractFileSystemItemWrapper focusItem, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ChangeSetSearchCriteriaPart.Input result = new ChangeSetSearchCriteriaPart.Input();
        result.setRepository(repository);
        ItemId component = namespace.fetchComponentId((IProgressMonitor)progress.newChild(100));
        result.getSearchCriteria().setComponent((IComponentHandle)component.toHandle());
        IContextHandle handle = namespace.getContextHandle();
        result.getSearchCriteria().setContext(handle);
        if (focusItem != null) {
            result.getSearchCriteria().setItem((IVersionableHandle)focusItem.getFileItem().toHandle());
        }
        return result;
    }

    protected void deferUpdates(boolean b) {
        this.viewer.deferUpdates(b);
        this.getControlSite().getParent().setRedraw(!b);
    }

    protected void showRevision(Revision rev) {
        LiveAnnotateUtil.TeamRevision teamRevision;
        if (rev instanceof LiveAnnotateUtil.TeamRevision && (teamRevision = (LiveAnnotateUtil.TeamRevision)rev).getChangeSet() != null) {
            this.setSelection(new ChangeSetSelectionTester((ItemId<IChangeSet>)new ItemId((IItemHandle)teamRevision.getChangeSet())));
        }
    }

    protected void attachShareListener(final IShareable shareable) {
        if (this.shareListenerAttached != shareable) {
            this.detachShareListener();
            this.shareListenerAttached = shareable;
            ISharingManager mgr = FileSystemCore.getSharingManager();
            this.copyFileAreaListener = new ICopyFileAreaListener(){

                public void change(ICopyFileAreaEvent[] events) {
                    int i = 0;
                    while (i < events.length) {
                        ICopyFileAreaEvent event = events[i];
                        if (shareable.getLocalPath().equals((Object)event.getPath())) {
                            HistoryView.this.detachShareListener();
                            HistoryView.this.recomputeHighlightedRow();
                            break;
                        }
                        ++i;
                    }
                }
            };
            mgr.addListener(this.copyFileAreaListener);
        }
    }

    private void detachShareListener() {
        if (this.copyFileAreaListener != null) {
            ISharingManager mgr = FileSystemCore.getSharingManager();
            mgr.removeListener(this.copyFileAreaListener);
            this.copyFileAreaListener = null;
        }
    }

    protected void setHighlight(StateId highlight) {
        this.rowDecorator.setSelectedRow(highlight);
    }

    protected AbstractHistoryViewInput adaptInput(Object input) {
        AbstractHistoryViewInput result;
        IResource resource;
        if (input == null) {
            return null;
        }
        if (input instanceof IAdaptable && (resource = (IResource)((IAdaptable)input).getAdapter(IResource.class)) != null) {
            input = resource;
        }
        if ((result = (AbstractHistoryViewInput)Adapters.getAdapter((Object)input, AbstractHistoryViewInput.class)) != null) {
            return result;
        }
        return null;
    }

    protected void doCompare(IHistoryEntry entry) {
        if (this.partServices == null) {
            return;
        }
        CompareHistoryFilesAction.compareWithPrevious(UIContext.createPartContext((IWorkbenchPart)this.partServices.getPart()), entry);
    }

    protected void doCompareWithLocal(IHistoryEntry entry) {
        AbstractFileSystemItemWrapper targetItem = entry.getTargetItem();
        if (targetItem != null) {
            if (targetItem instanceof FileItemWrapper || targetItem instanceof SymbolicLinkItemWrapper) {
                UIContext context = UIContext.createPartContext((IWorkbenchPart)this.partServices.getPart());
                CompareWithLocalFileAction.compareFile(context, targetItem);
            }
        } else if (entry.hasSnapshot()) {
            CompareHistoryWithLocalWorkspaceAction.compareHistory(this.getControlSite().getOperationRunner(), this.getControlSite().getShell(), this.partServices.getPage(), entry);
        }
    }

    private void doOpen(IHistoryEntry entry) {
        if (this.partServices == null) {
            return;
        }
        AbstractFileSystemItemWrapper target = entry.getTargetItem();
        if (target != null) {
            if (target instanceof FileItemWrapper) {
                FileItemWrapper fileItemWrapper = (FileItemWrapper)target;
                PartUtil.openEditor(UIContext.createPageContext((Shell)this.viewer.getTable().getShell(), (IWorkbenchPage)this.partServices.getPage()), fileItemWrapper);
            }
        } else {
            Parts.openView((IWorkbenchPage)this.partServices.getPage(), (Object)new RepositoryFilesViewInput(entry), (String)"com.ibm.team.filesystem.history.FileSystemView");
        }
    }

    protected void inputChanged(AbstractHistoryViewInput newInput) {
        boolean hasVersionable = newInput.getFocusItem() != null;
        ItemId id = hasVersionable ? newInput.getFocusItem().getItem() : ItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE);
        this.orderColumn.setTargetItem(id);
        this.showItemStatesAction.setEnabled(hasVersionable);
        this.toggleBaselinesAction.setEnabled(newInput instanceof WorkspaceConfigurationHistoryViewInput);
        this.commentColumn.setLabelProvider((IViewerLabelProvider)new HistoryEntryLabelProvider((ISetWithListeners<IHistoryEntry>)this.viewer.getKnownElements(), !this.isHidingBaselines, this.getControlSite().getOperationRunner()));
        this.registerCommitListener(newInput, hasVersionable);
        this.setVisible(this.viewer, (TableViewerColumn<IHistoryEntry>)this.orderColumn, newInput, this.input);
        this.setVisible(this.viewer, (TableViewerColumn<IHistoryEntry>)this.commentColumn, newInput, this.input);
        this.setVisible(this.viewer, (TableViewerColumn<IHistoryEntry>)this.baselineDescriptionColumn, newInput, this.input);
        this.setVisible(this.viewer, (TableViewerColumn<IHistoryEntry>)this.creatorColumn, newInput, this.input);
        this.setVisible(this.viewer, (TableViewerColumn<IHistoryEntry>)this.dateModifiedColumn, newInput, this.input);
        this.setVisible(this.viewer, (TableViewerColumn<IHistoryEntry>)this.addedByColumn, newInput, this.input);
        this.setVisible(this.viewer, (TableViewerColumn<IHistoryEntry>)this.dateAddedColumn, newInput, this.input);
        this.setVisible(this.viewer, (TableViewerColumn<IHistoryEntry>)this.versionColumn, newInput, this.input);
        this.setVisible(this.viewer, (TableViewerColumn<IHistoryEntry>)this.plannedForColumn, newInput, this.input);
        this.input = newInput;
        if (this.server != null) {
            this.server.removeGenericListener((Object)"state", this.repositoryListener);
            this.server.removeGenericListener((Object)"content_deleted", this.contentDeletedListener);
        }
        this.server = this.input.getRepository();
        if (this.server != null) {
            this.server.addGenericListener((Object)"state", this.repositoryListener);
            this.server.addGenericListener((Object)"content_deleted", this.contentDeletedListener);
        }
        this.recomputeHighlightedRow();
        this.updateInput();
        IFilter entry = this.input.getSelectionTester();
        if (entry != null) {
            this.setSelection(entry);
        }
    }

    private void registerCommitListener(final AbstractHistoryViewInput input, boolean hasVersionable) {
        if (this.commitListenerConnection != null) {
            this.commitListenerConnection.removeGenericListener((Object)"com.ibm.team.scm.Commit", this.commitListener);
            this.commitListenerConnection = null;
        }
        if (!hasVersionable) {
            return;
        }
        this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_RegisterCheckInListenerJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    final IConnection newConnection = input.getNamespace().getConnection((IProgressMonitor)progress.newChild(100));
                    if (newConnection != null) {
                        HistoryView.this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (HistoryView.this.viewer != null && !HistoryView.this.viewer.getTable().isDisposed()) {
                                    if (HistoryView.this.commitListenerConnection != null) {
                                        HistoryView.this.commitListenerConnection.removeGenericListener((Object)"com.ibm.team.scm.Commit", HistoryView.this.commitListener);
                                    }
                                    newConnection.addGenericListener((Object)"com.ibm.team.scm.Commit", HistoryView.this.commitListener);
                                    HistoryView.this.commitListenerConnection = newConnection;
                                }
                            }
                        });
                    }
                }
                catch (TeamRepositoryException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                }
            }
        });
    }

    private void setVisible(SimpleTableViewer<IHistoryEntry> viewer, TableViewerColumn<IHistoryEntry> column, AbstractHistoryViewInput newInput, AbstractHistoryViewInput oldInput) {
        IHistoryViewColumn historyViewColumn = (IHistoryViewColumn)column;
        if (oldInput == null || historyViewColumn.getDefaultVisible(newInput) != historyViewColumn.getDefaultVisible(oldInput)) {
            viewer.setVisible(column, historyViewColumn.getDefaultVisible(newInput));
        }
    }

    private void updateCollaboratorStream() {
        final AbstractHistoryViewInput input = this.input;
        if (input == null) {
            return;
        }
        final Display display = Display.getCurrent();
        Composite control = this.getControlSite().getParent();
        this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_fetchingFlowTargetJobName, (Operation)new RepositoryOperation((Control)control){
            private final /* synthetic */ Control val$control;
            {
                this.val$control = control;
            }

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                HistoryView.this.updateActionsBasedOnFlows(input, display, this.val$control, monitor);
            }
        });
    }

    private void updateActionsBasedOnFlows(AbstractHistoryViewInput input, Display display, final Control control, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IComponentHandle component = (IComponentHandle)input.getNamespace().fetchComponentId((IProgressMonitor)progress.newChild(50)).toHandle();
            IConnection connection = input.getNamespace().getConnection((IProgressMonitor)progress.newChild(50));
            WorkspaceNamespace incomingFlow = null;
            WorkspaceNamespace outgoingFlow = null;
            if (connection != null && connection instanceof IWorkspaceConnection) {
                IWorkspaceConnection wc = (IWorkspaceConnection)connection;
                IWorkspaceConnection incomingFlowConnection = PendingChangesUtil.getIncomingCollaboratorStream(wc, component);
                if (incomingFlowConnection != null) {
                    incomingFlow = WorkspaceNamespace.create((IWorkspaceConnection)incomingFlowConnection, (IComponentHandle)component);
                } else {
                    IFlowEntry incomingComponentFlowEntry = wc.getFlowTable().getCurrentAcceptFlow();
                    if (incomingComponentFlowEntry != null && incomingComponentFlowEntry.getFlowNode() instanceof IWorkspaceHandle) {
                        incomingFlow = WorkspaceNamespace.create((IWorkspaceHandle)((IWorkspaceHandle)incomingComponentFlowEntry.getFlowNode()), (IComponentHandle)component);
                    }
                }
                IWorkspaceConnection outgoingFlowConnection = PendingChangesUtil.getOutgoingCollaboratorStream(wc, component);
                if (outgoingFlowConnection != null) {
                    outgoingFlow = WorkspaceNamespace.create((IWorkspaceConnection)outgoingFlowConnection, (IComponentHandle)component);
                } else {
                    IFlowEntry outgoingFlowEntry = wc.getFlowTable().getCurrentDeliverFlow();
                    if (outgoingFlowEntry != null && outgoingFlowEntry.getFlowNode() instanceof IWorkspaceHandle) {
                        outgoingFlow = WorkspaceNamespace.create((IWorkspaceHandle)((IWorkspaceHandle)outgoingFlowEntry.getFlowNode()), (IComponentHandle)component);
                    }
                }
            }
            WorkspaceNamespace finalIncomingFlow = incomingFlow;
            WorkspaceNamespace finalOutgoingFlow = outgoingFlow;
            SWTUtil.greedyExec((Display)display, (Control)control, (Runnable)new Runnable((ItemNamespace)finalIncomingFlow, (ItemNamespace)finalOutgoingFlow){
                private final /* synthetic */ ItemNamespace val$finalIncomingFlow;
                private final /* synthetic */ ItemNamespace val$finalOutgoingFlow;
                {
                    this.val$finalIncomingFlow = itemNamespace;
                    this.val$finalOutgoingFlow = itemNamespace2;
                }

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        HistoryView.this.updateActions(this.val$finalIncomingFlow, this.val$finalOutgoingFlow);
                    }
                }
            });
        }
        catch (NotLoggedInException notLoggedInException) {
            // empty catch block
        }
    }

    private void updateActions(ItemNamespace currentIncomingCollaboration, ItemNamespace currentOutgoingCollaboration) {
        AbstractHistoryViewInput outgoingCollaboratingInput;
        String biggerInputDescription = this.input.getBiggerInputDescription();
        AbstractHistoryViewInput biggerInput = this.input.getBiggerInput();
        AbstractHistoryViewInput allStatesInput = this.input.getAllStatesInput();
        AbstractHistoryViewInput incomingCollaboratingInput = this.input.getNamespace().equals((Object)currentIncomingCollaboration) ? null : this.input.getHistoryInputForCurrentFlowTarget(currentIncomingCollaboration);
        AbstractHistoryViewInput abstractHistoryViewInput = outgoingCollaboratingInput = this.input.getNamespace().equals((Object)currentOutgoingCollaboration) ? null : this.input.getHistoryInputForCurrentFlowTarget(currentOutgoingCollaboration);
        if (biggerInputDescription != null) {
            this.showBiggerInputAction.setDescription(biggerInputDescription);
        }
        this.showBiggerInputAction.setInput(biggerInput);
        this.showAllStatesAction.setInput(allStatesInput);
        this.showIncomingCollaboratorStreamHistory.setInput(incomingCollaboratingInput);
        this.showOutgoingCollaboratorStreamHistory.setInput(outgoingCollaboratingInput);
        this.showBaselineDiagramAction.setInput(this.input instanceof BaselinesInWorkspaceHistoryViewInput && this.input.getNamespace() instanceof WorkspaceNamespace ? this.input : null);
    }

    private void recomputeHighlightedRow() {
        this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_computingHighlightJobName, this.highlightJob);
    }

    private void updateInput() {
        final AbstractHistoryViewInput input = this.input;
        if (input != null) {
            int entryCount = this.prefs.getInt(COUNT, 100);
            IFilter newSelection = input.getSelectionTester();
            if (newSelection == null) {
                List<IHistoryEntry> entries = this.getSelection();
                HashSet changeSets = NewCollection.hashSet();
                for (IHistoryEntry next : entries) {
                    ChangeSetWrapper changeSet = next.getChangeSet();
                    if (changeSet == null) continue;
                    changeSets.add(ChangeSetUtil.getChangeSet((IChangeSetHandle)changeSet.getChangeSet()));
                }
                this.setSelection(new ChangeSetSelectionTester(changeSets));
            }
            final Display display = Display.getCurrent();
            Composite control = this.getControlSite().getParent();
            this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_computingInputNameJobName, (Operation)new RepositoryOperation((Control)control){
                private final /* synthetic */ Control val$control;
                {
                    this.val$control = control;
                }

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    HistoryView.this.updateActionsBasedOnFlows(input, display, this.val$control, (IProgressMonitor)progress.newChild(50));
                    final String inputName = input.computeInputName((IProgressMonitor)progress.newChild(50));
                    SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!val$control.isDisposed()) {
                                HistoryView.this.getControlSite().getNameable().setContentDescription(inputName);
                            }
                        }
                    });
                }
            });
            if (input instanceof WorkspaceConfigurationHistoryViewInput) {
                ((WorkspaceConfigurationHistoryViewInput)input).setHideBaselines(this.isHidingBaselines);
                this.commentColumn.setLabelProvider((IViewerLabelProvider)new HistoryEntryLabelProvider((ISetWithListeners<IHistoryEntry>)this.viewer.getKnownElements(), !this.isHidingBaselines, this.getControlSite().getOperationRunner()));
            }
            this.currentQuery = input.createQuery(this.getControlSite().getOperationRunner(), entryCount);
            if (this.currentQuery instanceof VersionableHistoryViewQuery) {
                VersionableHistoryViewQuery historyViewQuery = (VersionableHistoryViewQuery)this.currentQuery;
                historyViewQuery.setSearchIntermediates(this.prefs.getBoolean(SEARCH_INTERMEDIATE, false));
            }
            this.pagedTable.setInput(this.currentQuery);
        } else {
            this.currentQuery = new WritableSetWithListeners();
            this.pagedTable.setInput(this.currentQuery);
        }
        this.updateStateInput(null);
        this.listenToActiveEditor();
    }

    private void listenToActiveEditor() {
        IRevisionRulerColumn column;
        if (this.partServices == null) {
            return;
        }
        IEditorPart editor = this.partServices.getPage().getActiveEditor();
        ISelectionProvider newProvider = null;
        if (editor != null && (column = (IRevisionRulerColumn)editor.getAdapter(IRevisionRulerColumn.class)) instanceof IRevisionRulerColumnExtension) {
            newProvider = ((IRevisionRulerColumnExtension)column).getRevisionSelectionProvider();
        }
        this.setRevisionSelectionProvider(newProvider);
    }

    private void setRevisionSelectionProvider(ISelectionProvider newProvider) {
        if (newProvider != this.revisionSelectionProvider) {
            if (this.revisionSelectionProvider != null) {
                this.revisionSelectionProvider.removeSelectionChangedListener(this.revisionListener);
            }
            this.revisionSelectionProvider = newProvider;
            if (this.revisionSelectionProvider != null) {
                this.revisionSelectionProvider.addSelectionChangedListener(this.revisionListener);
            }
        }
    }

    public List<IHistoryEntry> getSelection() {
        return CollectionUtil.filterByType((Collection)this.viewer.getSelection().toList(), IHistoryEntry.class);
    }

    public void dispose() {
        if (this.tracker != null) {
            this.tracker.dispose();
        }
        this.viewer.storePrefs();
        IEclipsePreferences cp = this.getConfigPrefs();
        FileSystemResourcesPlugin.getComponentSyncModel().removeGenericListener((Object)"refreshedRemoteCompleted", this.collaborationListener);
        if (this.partServices != null) {
            this.partServices.getPage().removePartListener(this.partListener);
        }
        if (this.server != null) {
            this.server.removeGenericListener((Object)"state", this.repositoryListener);
            this.server.removeGenericListener((Object)"content_deleted", this.contentDeletedListener);
        }
        if (this.commitListenerConnection != null) {
            this.commitListenerConnection.removeGenericListener((Object)"com.ibm.team.scm.Commit", this.commitListener);
            this.commitListenerConnection = null;
        }
        RcpUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        this.repositoryListener = null;
        this.contentDeletedListener = null;
        this.setRevisionSelectionProvider(null);
        this.detachShareListener();
        try {
            this.preferenceListener.detachFrom(this.prefs);
            this.prefs.flush();
            cp.flush();
        }
        catch (BackingStoreException e) {
            StatusUtil.log(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        super.dispose();
    }

    public void setSelection(IFilter newSelection) {
        this.viewer.setSelectionCriteria(newSelection);
        if (this.currentQuery instanceof ConfigurationHistoryViewQuery) {
            ConfigurationHistoryViewQuery q = (ConfigurationHistoryViewQuery)this.currentQuery;
            if (newSelection instanceof IChangeSetSelector) {
                IChangeSetSelector css = (IChangeSetSelector)newSelection;
                ItemId<IChangeSet> selectedChangeSet = css.getSelectedChangeSet();
                q.makeVisible(selectedChangeSet);
            } else {
                q.setStartPosition(0);
            }
        }
    }

    public void addMenuEntries(List output) {
        output.add(this.preferencesAction);
        this.addHistoryActions(output);
        output.add(SeparatorExt.getInstance());
        output.add(this.showItemStatesAction);
        output.add(SeparatorExt.getInstance());
        this.layoutAction = new LayoutAction();
        this.layoutAction.setVisible(this.sashForm != null ? this.sashForm.getMaximizedControl() == null : false);
        MenuExt layoutMenu = new MenuExt();
        int i = 0;
        while (i < this.toggleOrientationActions.length) {
            layoutMenu.add((IActionExt)this.toggleOrientationActions[i]);
            ++i;
        }
        this.layoutAction.setSubMenu((IMenuExt)layoutMenu);
        output.add(this.layoutAction);
    }

    public void addToolbarEntries(List output) {
        this.addHistoryActions(output);
    }

    private void addHistoryActions(List result) {
        result.add(SeparatorExt.getInstance());
        result.add(this.showIncomingCollaboratorStreamHistory);
        result.add(this.showOutgoingCollaboratorStreamHistory);
        result.add(this.showBiggerInputAction);
        result.add(this.showAllStatesAction);
        result.add(this.showBaselineDiagramAction);
        result.add(this.toggleBaselinesAction);
    }

    protected IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
        return result;
    }

    public boolean canRefresh() {
        if (this.currentQuery instanceof IRefreshable) {
            IRefreshable refreshable = (IRefreshable)this.currentQuery;
            return refreshable.canRefresh();
        }
        return false;
    }

    public void refresh() {
        if (this.currentQuery instanceof IRefreshable) {
            IRefreshable refreshable = (IRefreshable)this.currentQuery;
            refreshable.refresh();
            this.recomputeHighlightedRow();
            this.refreshSelectedItemStates();
        }
    }

    private void refreshSelectedItemStates() {
        ChangeSetWrapper wrapper;
        if (this.showStates && this.currentStateInput != null && (wrapper = this.currentStateInput.getChangeSet()) != null && wrapper.getChangeSet().isActive()) {
            Realm realm = this.stateEntryInput.getRealm();
            this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_fetchingItemStatesOpName, (Operation)new UpdateStatesJob(realm, this.currentStateInput));
        }
    }

    public void requestInputChange(AbstractHistoryViewInput input) {
        if (this.partServices != null) {
            HistoryViewUtil.showHistory(UIContext.createPartContext((IWorkbenchPart)this.partServices.getPart()), input);
        } else {
            this.setInput(input);
        }
    }

    public final void setInput(Object item) {
        AbstractHistoryViewInput newInput = this.adaptInput(item);
        if (newInput == null) {
            return;
        }
        if (!Util.equals((Object)this.input, (Object)newInput)) {
            this.getControlSite().getNameable().setContentDescription(Messages.HistoryView_pendingDescription);
            this.inputChanged(newInput);
        }
    }

    public final IMenuExt getMenuContributions() {
        if (this.menu == null) {
            this.menu = new MenuExt();
            ArrayList menuContents = new ArrayList();
            this.addMenuEntries(menuContents);
            for (IActionExt next : menuContents) {
                this.menu.add(next);
            }
        }
        return this.menu;
    }

    public final IMenuExt getToolbarContributions() {
        if (this.toolbar == null) {
            this.toolbar = new MenuExt();
            ArrayList menuContents = new ArrayList();
            this.addToolbarEntries(menuContents);
            for (IActionExt next : menuContents) {
                this.toolbar.add(next);
            }
        }
        return this.toolbar;
    }

    private void openPreferences() {
        PartFactory factory = new PartFactory(HistoryPreferencesPart.class);
        IWorkingCopyFactory input = PreferencesInputFactory.getPreferencesWorkingCopy((String)"configuration", (String)this.getConfigPrefs().absolutePath(), (String)Messages.HistoryView_historyPreferencesWorkingCopyName);
        final IWizardPage wizardPage = Parts.createWizardPage((Object)input, (IPartFactory)factory, (String)"prefs", null);
        final Shell shell = this.getControlSite().getShell();
        WizardUtil.open((Shell)shell, (String)Messages.HistoryView_preferencesDialogTitle, (IWizardPage)wizardPage, (IRunnableWithResult)new IRunnableWithResult<Boolean>(){

            public Boolean run() {
                HistoryPreferencesPart part = (HistoryPreferencesPart)((Object)Adapters.getAdapter((Object)wizardPage, HistoryPreferencesPart.class));
                IWorkingCopy wc = part.getWorkingCopy();
                WorkingCopies.performSave((Shell)shell, (IWorkingCopy)wc, null);
                return true;
            }
        }, (String)"com.ibm.team.filesystem.ide.ui.preference_page_history_view");
    }

    private void updateStateInput(VersionableHistoryEntry entry) {
        if (this.showStates && this.input.getFocusItem() != null) {
            this.sashForm.setMaximizedControl(null);
        } else {
            this.sashForm.setMaximizedControl((Control)this.changeHistorySection);
        }
        if (this.currentStateInput != null && (this.currentStateInput.equals(entry) || !this.showStates)) {
            return;
        }
        this.currentStateInput = entry;
        if (entry == null || this.input.getFocusItem() == null) {
            this.stateEntryInput.clear();
            return;
        }
        if (entry != null) {
            Realm realm = this.stateEntryInput.getRealm();
            this.getControlSite().getOperationRunner().enqueue(Messages.HistoryView_fetchingItemStatesOpName, (Operation)new UpdateStatesJob(realm, entry));
        }
    }

    LayoutAction getLayoutAction() {
        return this.layoutAction;
    }

    int getOrientation() {
        return this.orientation;
    }

    void setOrientation(int orientation) {
        if (this.sashForm == null || this.sashForm.isDisposed()) {
            return;
        }
        this.orientation = orientation;
        IPreferenceStore preferences = UiPlugin.getDefault().getPreferenceStore();
        preferences.setValue("prefs_history_view_orientation", orientation);
        this.sashForm.setOrientation(orientation == 1 ? 256 : 512);
    }

    private void doOpenState(IChangeNode node, Shell shell) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        OpenRemoteFileAction openRemoteFileAction = new OpenRemoteFileAction();
        openRemoteFileAction.run(shell, activeWorkbenchWindow.getActivePage(), (IStructuredSelection)new StructuredSelection((Object)node));
    }

    private boolean isChangeSetBasedInput(AbstractHistoryViewInput input) {
        return input instanceof BaselineConfigurationHistoryViewInput || input instanceof WorkspaceConfigurationHistoryViewInput || input instanceof VersionableInWorkspaceHistoryViewInput || input instanceof VersionableInRepositoryHistoryViewInput || input instanceof VersionableInBaselineHistoryViewInput;
    }

    public class LayoutAction
    extends AbstractActionExt {
        private IMenuExt menuExt;

        public LayoutAction() {
            super(Messages.HistoryView_layoutOrientationLabel);
        }

        public int getStyle() {
            return 64;
        }

        public void setSubMenu(IMenuExt menuExt) {
            this.menuExt = menuExt;
        }

        public IMenuExt getSubmenu() {
            return this.menuExt;
        }

        public void run() {
        }

        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
        }

        public void setVisible(boolean isVisible) {
            super.setVisible(isVisible);
        }
    }

    private class ToggleOrientationAction
    extends AbstractActionExt {
        private final int actionOrientation;

        public ToggleOrientationAction(int orientation) {
            super("");
            if (orientation == 1) {
                this.setText(Messages.HistoryView_horizontalOrientationLabel);
            } else {
                this.setText(Messages.HistoryView_verticalOrientationLabel);
            }
            this.actionOrientation = orientation;
        }

        public int getStyle() {
            return 16;
        }

        public boolean getSelection() {
            return HistoryView.this.getOrientation() == this.actionOrientation;
        }

        public void run() {
            if (HistoryView.this.getOrientation() != this.actionOrientation) {
                int orientation = this.actionOrientation;
                HistoryView.this.setOrientation(orientation);
            }
        }
    }

    public class UpdateStatesJob
    extends RepositoryOperation {
        private final Realm realm;
        private final VersionableHistoryEntry entry;

        public UpdateStatesJob(Realm realm, VersionableHistoryEntry entry) {
            this.realm = realm;
            this.entry = entry;
        }

        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
            if (HistoryView.this.input.getFocusItem() == null) {
                return;
            }
            IVersionableHandle versionable = (IVersionableHandle)HistoryView.this.input.getFocusItem().getItem().toHandle();
            IChangeSet changeSet = this.entry.getChangeSet().getChangeSet();
            ITeamRepository repo = this.entry.getRepository();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            List changeNodes = ChangeSetNodeUtil.getChangeNodes((IChangeSetHandle)changeSet, (IVersionableHandle)versionable, (ITeamRepository)repo, (ItemNamespace)HistoryView.this.input.getNamespace(), (IProgressMonitor)progress.newChild(1));
            Collections.reverse(changeNodes);
            final List updatedChangeNodes = ChangeSetNodeUtil.getContentDeletedStatus((ITeamRepository)repo, (List)changeNodes, (IProgressMonitor)progress.newChild(1));
            this.realm.asyncExec(new Runnable(){

                @Override
                public void run() {
                    HistoryView.this.stateEntryInput.setContents((Collection)updatedChangeNodes);
                }
            });
        }
    }
}

