/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.ValidatorStatus;
import com.ibm.team.repository.rcp.ui.internal.menus.CheckAction;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.RadioAction;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.ToolkitUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.parts.AbstractEditorPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.repository.rcp.ui.workingcopy.IPreferencesWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class HistoryPreferencesPart
extends AbstractEditorPart {
    private Text value;
    private WritableValue<Integer> openActionType;
    private WritableValue<Boolean> searchIntermediateChangeSets;
    protected IEclipsePreferences prefs;
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("count")) {
                int intValue;
                int newValue = HistoryPreferencesPart.this.prefs.getInt("count", 100);
                try {
                    intValue = Integer.parseInt(HistoryPreferencesPart.this.value.getText());
                }
                catch (NumberFormatException nfe) {
                    intValue = 0;
                }
                if (newValue != intValue) {
                    HistoryPreferencesPart.this.value.setText("" + newValue);
                }
            }
            if (event.getKey().equals("doubleclickaction")) {
                HistoryPreferencesPart.this.openActionType.setValue((Object)new Integer(HistoryPreferencesPart.this.prefs.getInt("doubleclickaction", 0)));
            }
        }
    };
    private CombinedStatus validationStatus = new CombinedStatus();
    protected Control compareWithPreviousButton;
    protected Control openSelectedVersionButton;
    protected Control compareWithLocalVersionButton;
    protected Control searchIntermediateActionCheckBox;

    public HistoryPreferencesPart(IControlSite site, Object input) {
        super(site, input);
        WidgetFactoryContext context = site.getContext();
        MnemonicGenerator mg = site.getMnemonicGenerator();
        site.getNameable().setName(Messages.HistoryPreferencesPart_partTitle);
        site.getNameable().setContentDescription(Messages.HistoryPreferencesPart_partDescription);
        IPreferencesWorkingCopy workingCopy = (IPreferencesWorkingCopy)this.getWorkingCopy();
        this.prefs = workingCopy.getPreferences();
        this.prefs.addPreferenceChangeListener(this.preferenceChangeListener);
        Composite parent = site.getParent();
        WidgetToolkit toolkit = site.getToolkit();
        Composite lastEntriesGroup = toolkit.createComposite(parent);
        toolkit.createLabel(lastEntriesGroup, mg.generate(Messages.HistoryPreferencesPart_entriesToShowLabel));
        this.value = toolkit.createText(lastEntriesGroup, "" + this.prefs.getInt("count", 100), 2048);
        this.value.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                e.doit = Character.isDigit(e.character) || e.character == '\r' || e.character == '\u001b' || e.character == '\n' || e.character == '\b' || e.character < ' ' || e.character == '\u007f';
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.value.setTextLimit(10);
        ValidatorStatus valueValidator = new ValidatorStatus((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.value));
        valueValidator.addValidator(new IValidator(){

            public IStatus validate(Object value) {
                int intValue;
                String text = (String)value;
                if (text.length() == 0) {
                    return DatabindingUtil.createNoIconMessage((int)4, (String)Messages.HistoryPreferencesPart_missingEntriesToShowErrorMessage);
                }
                try {
                    intValue = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    return StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.HistoryPreferencesPart_tooManyEntriesErrorMessage, (Object)text));
                }
                if (intValue == 0) {
                    return StatusUtil.newStatus((Object)this, (String)Messages.HistoryPreferencesPart_notEnoughEntriesErrorMessage);
                }
                if (intValue > 300) {
                    return StatusUtil.newStatus((Object)this, (int)2, (String)Messages.HistoryPreferencesPart_excessiveEntriesSelectedWarning);
                }
                return Status.OK_STATUS;
            }
        });
        this.validationStatus.addStatus((IObservableValue)valueValidator);
        this.value.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int intValue;
                String text = HistoryPreferencesPart.this.value.getText();
                try {
                    intValue = Integer.parseInt(text);
                }
                catch (NumberFormatException nfe) {
                    intValue = 0;
                }
                if (HistoryPreferencesPart.this.prefs.getInt("count", 0) != intValue) {
                    HistoryPreferencesPart.this.prefs.putInt("count", intValue);
                }
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(lastEntriesGroup);
        this.openActionType = new WritableValue((Object)new Integer(this.prefs.getInt("doubleclickaction", 1)));
        Group openActionsGroup = new Group(parent, 0);
        openActionsGroup.setText(Messages.HistoryPreferencesPart_doubleClickGroup);
        SWTUtil.matchBackground((Control)openActionsGroup);
        this.compareWithPreviousButton = ToolkitUtil.createButton((WidgetFactoryContext)context, (Composite)openActionsGroup, (IActionExt)new RadioAction(Messages.HistoryPreferencesPart_compareWithPreviousRadio, (Object)new Integer(1), this.openActionType));
        this.openSelectedVersionButton = ToolkitUtil.createButton((WidgetFactoryContext)context, (Composite)openActionsGroup, (IActionExt)new RadioAction(Messages.HistoryPreferencesPart_openSelectedRadio, (Object)new Integer(0), this.openActionType));
        this.compareWithLocalVersionButton = ToolkitUtil.createButton((WidgetFactoryContext)context, (Composite)openActionsGroup, (IActionExt)new RadioAction(Messages.HistoryPreferencesPart_compareWithLocalRadio, (Object)new Integer(2), this.openActionType));
        this.openActionType.addListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                HistoryPreferencesPart.this.prefs.putInt("doubleclickaction", ((Integer)HistoryPreferencesPart.this.openActionType.getValue()).intValue());
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(1).margins(LayoutConstants.getMargins()).generateLayout((Composite)openActionsGroup);
        this.searchIntermediateChangeSets = new WritableValue((Object)new Boolean(this.prefs.getBoolean("searchIntermediateChangeSet", false)));
        CheckAction searchIntermediateAction = new CheckAction(Messages.HistoryPreferencesPart_searchIntermediateChangeSetsButton);
        this.searchIntermediateActionCheckBox = ToolkitUtil.createButton((WidgetFactoryContext)context, (Composite)parent, (IActionExt)searchIntermediateAction);
        searchIntermediateAction.addChangeListener(new IChangeListener(){

            public void changed(Object source, Object property) {
                CheckAction action = (CheckAction)source;
                HistoryPreferencesPart.this.prefs.putBoolean("searchIntermediateChangeSet", action.getSelection());
            }
        });
        searchIntermediateAction.setSelected(((Boolean)this.searchIntermediateChangeSets.getValue()).booleanValue());
        GridLayoutFactory.fillDefaults().numColumns(1).generateLayout(parent);
        DatabindingUtil.bindMessage((IControlSite)site, (IObservableValue)this.validationStatus);
    }

    protected void dispose() {
        this.prefs.removePreferenceChangeListener(this.preferenceChangeListener);
        super.dispose();
    }

    public IWorkingCopy getWorkingCopy() {
        return super.getWorkingCopy();
    }
}

