/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.internal.filesystem.ui.views.history.HistoryPageHost;
import com.ibm.team.repository.rcp.ui.internal.parts.NullMnemonicGenerator;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.AbstractControlSite;
import com.ibm.team.repository.rcp.ui.parts.IContextMenuHandler;
import com.ibm.team.repository.rcp.ui.parts.IMnemonicGenerationAlgorithm;
import com.ibm.team.repository.rcp.ui.parts.IPartSiteServices;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class HistoryPageSite
extends AbstractControlSite
implements IContextMenuHandler,
IAdaptable {
    private String name = "";
    private String description = "";
    private int menuCounter;
    private IHistoryPageSite site;
    private HistoryPageHost historyPage;
    private IPartSiteServices partServices;
    private PartSiteJobRunner siteJobRunner;

    public HistoryPageSite(Composite control, IHistoryPageSite site, HistoryPageHost page) {
        super(control);
        this.site = site;
        this.historyPage = page;
        final IWorkbenchPart part = site.getPart();
        if (part != null) {
            this.partServices = new IPartSiteServices(){

                public IWorkbenchPage getPage() {
                    return part.getSite().getPage();
                }

                public IWorkbenchPart getPart() {
                    return part;
                }

                public IWorkbenchWindow getWorkbenchWindow() {
                    return part.getSite().getWorkbenchWindow();
                }
            };
            IWorkbenchPartReference wpr = part.getSite().getPage().getReference(part);
            if (wpr != null) {
                this.name = wpr.getPartName();
            }
        }
    }

    protected MnemonicGenerator createMnemonicGenerator() {
        return new MnemonicGenerator((IMnemonicGenerationAlgorithm)new NullMnemonicGenerator());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPartSiteServices.class) {
            return this.partServices;
        }
        return null;
    }

    public void close() {
    }

    protected IOperationRunner getParentOperationRunner() {
        IWorkbenchPart part = this.site.getPart();
        if (part != null) {
            if (this.siteJobRunner == null) {
                this.siteJobRunner = new PartSiteJobRunner(part.getSite(), false);
            }
            return this.siteJobRunner;
        }
        return super.getParentOperationRunner();
    }

    public void setName(String newName) {
        if (this.siteJobRunner != null) {
            this.siteJobRunner.setName(newName);
        }
        this.name = newName;
        super.setName(newName);
    }

    public void setContentDescription(String contentDescription) {
        String oldDescription = this.description;
        this.description = contentDescription;
        super.setContentDescription(contentDescription);
        this.historyPage.doFirePropertyChange("org.eclipse.team.ui.name", oldDescription, this.description);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public final IWorkbenchPart getWorkbenchPart() {
        return this.site.getPart();
    }

    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
        IWorkbenchPart part = this.site.getPart();
        if (part == null) {
            return;
        }
        if (this.menuCounter == 0) {
            part.getSite().registerContextMenu(menuManager, selectionProvider);
        } else {
            String id = String.valueOf(part.getSite().getId()) + this.menuCounter;
            part.getSite().registerContextMenu(id, menuManager, selectionProvider);
        }
        ++this.menuCounter;
    }

    protected WidgetToolkit createToolkit() {
        return WidgetToolkit.createFormToolkit();
    }

    public final void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
        IWorkbenchPart part = this.site.getPart();
        if (part == null) {
            return;
        }
        part.getSite().registerContextMenu(menuId, menuManager, selectionProvider);
    }

    protected void dispose() {
        if (this.siteJobRunner != null) {
            this.siteJobRunner.dispose();
            this.siteJobRunner = null;
        }
        super.dispose();
    }
}

